% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss.R
\name{time_series}
\alias{time_series}
\title{Get time series}
\usage{
time_series(
  URL,
  name,
  attributes = NULL,
  longitude,
  latitude,
  start_date = NULL,
  end_date = NULL,
  token = NULL,
  ...
)
}
\arguments{
\item{URL}{URL of the server}

\item{name}{Coverage name.}

\item{attributes}{Vector of band names.}

\item{longitude}{Longitude in WGS84 coordinate system.}

\item{latitude}{Latitude in WGS84 coordinate system.}

\item{start_date}{Start date in the format yyyy-mm-dd or yyyy-mm 
depending on the coverage.}

\item{end_date}{End date in the format yyyy-mm-dd or yyyy-mm 
depending on the coverage.}

\item{token}{A character with token to be add in URL.}

\item{...}{Additional parameters that can be added in httr.}
}
\value{
time series in a tibble format (NULL)
}
\description{
Retrieves the time series for a pair of coordinates
}
\examples{
\dontrun{
# connect to a WTSS server
wtss_server <- "https://brazildatacube.dpi.inpe.br/wtss/"
# retrieve a time series
ndvi_ts <- Rwtss::time_series(wtss_server, 
                              "LC8_30_16D_STK-1", 
                              attributes = "NDVI", 
                              latitude = -14.31, 
                              longitude = -51.16,
                              token = "YOUR-BDC-TOKEN")
# plot the time series
plot(ndvi_ts)
}
}
\author{
Gilberto Camara
}
