% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_MSD.R
\name{do.msd}
\alias{do.msd}
\title{Maximum Scatter Difference}
\usage{
do.msd(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "whiten", "decorrelate"),
  C = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{C}{nonnegative balancing parameter for intra- and inter-class variance.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Maximum Scatter Difference (MSD) is a supervised linear dimension reduction method.
The basic idea of MSD is to use \emph{additive} cost function rather than \emph{multiplicative}
trace ratio criterion that was adopted by LDA. Due to such formulation, it can neglect sample-sample-size
problem from rank-deficiency of between-class variance matrix.
}
\examples{
## generate data of 3 types with clear difference
set.seed(100)
dt1  = aux.gensamples(n=20)-50
dt2  = aux.gensamples(n=20)
dt3  = aux.gensamples(n=20)+50

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = rep(1:3, each=20)

## try different balancing parameter
out1 = do.msd(X, label, C=0.01)
out2 = do.msd(X, label, C=1)
out3 = do.msd(X, label, C=100)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, pch=19, col=label, main="MSD::C=0.01")
plot(out2$Y, pch=19, col=label, main="MSD::C=1")
plot(out3$Y, pch=19, col=label, main="MSD::C=100")
par(opar)

}
\references{
\insertRef{song_face_2007}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
