% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getAll}
\alias{getAll}
\title{Return all System Configuration Settings}
\usage{
getAll(path = ".")
}
\arguments{
\item{path}{An optional character object specifying a path. Default is the
current directory.}
}
\value{
A data.frame with three colums for key, value and (source) type.
Not all keys return a value; in those cases an empty string is returned.
Type is one of \code{path}, \code{sys} and \code{conf} and signals how the
value was obtained.
}
\description{
Retrieve all configuration settings
}
\details{
This functions returns all configuration settings which can be queried
in a data.frame object. The system-level functions \code{sysconf},
\code{pathconf} and \code{confstr} provide all the underlying information.
}
\examples{
if (Sys.info()[["sysname"]] != "SunOS") {
    head(getAll(), 30)
    subset(getAll(), type=="path")
}
}
\seealso{
\code{\link{getConfig}}
}
\author{
Dirk Eddelbuettel
}
