% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.Normal.R
\name{Normal}
\alias{Normal}
\title{Normal}
\description{
Normal distribution in OOP way. Based on AbstractDist
}
\details{
See AbstractDist for generic methods
}
\examples{
## Generate sample
mean  = 1
sd    = 0.5
norml = ROOPSD::Normal$new( mean = mean , sd = sd )
X     = norml$rvs( n = 1000 )

## And fit parameters
norml$fit(X)

}
\section{Super class}{
\code{\link[ROOPSD:AbstractDist]{ROOPSD::AbstractDist}} -> \code{Normal}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{mean}}{[double] mean of the normal law}

\item{\code{sd}}{[double] standard deviation of the normal law}

\item{\code{params}}{[vector] params of the normal law}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Normal-new}{\code{Normal$new()}}
\item \href{#method-Normal-clone}{\code{Normal$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="cdf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-cdf'><code>ROOPSD::AbstractDist$cdf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="density"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-density'><code>ROOPSD::AbstractDist$density()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="diagnostic"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-diagnostic'><code>ROOPSD::AbstractDist$diagnostic()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="fit"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-fit'><code>ROOPSD::AbstractDist$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="icdf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-icdf'><code>ROOPSD::AbstractDist$icdf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="isf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-isf'><code>ROOPSD::AbstractDist$isf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="logdensity"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-logdensity'><code>ROOPSD::AbstractDist$logdensity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="pdeltaCI"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-pdeltaCI'><code>ROOPSD::AbstractDist$pdeltaCI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="qdeltaCI"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-qdeltaCI'><code>ROOPSD::AbstractDist$qdeltaCI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="qgradient"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-qgradient'><code>ROOPSD::AbstractDist$qgradient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="rvs"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-rvs'><code>ROOPSD::AbstractDist$rvs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="sf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-sf'><code>ROOPSD::AbstractDist$sf()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Normal-new"></a>}}
\if{latex}{\out{\hypertarget{method-Normal-new}{}}}
\subsection{Method \code{new()}}{
Create a new Normal object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Normal$new(mean = 0, sd = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mean}}{[double] Mean of the normal law}

\item{\code{sd}}{[double] Standard deviation of the normal law}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Normal` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Normal-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Normal-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Normal$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
