% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{calSize}
\alias{calSize}
\title{Calculating the accumulated sample size distribution by each wave.}
\usage{
calSize(s, c, maxWave, rr, bruteMC, tol = 0.025)
}
\arguments{
\item{s}{scalar; Number of seeds to initiate the sampling process.}

\item{c}{scalar; Number of coupons issued to each participant.}

\item{maxWave}{scalar; Planned field period scaled by wave, which does not include the initial round of recruiting seeds.}

\item{rr}{scalar or vector; a (constant) recruitment rate or a vector of length \emph{maxWave}, listing varying recruitment rates at each wave.
The recruitment rate represents the average coupon use rate. For example, if \emph{rr} is a vector,
the \emph{w}th element is the ratio of the number of successful recruits brought into the study at wave \emph{w} by their recruiters (participants from wave \emph{w-1})
to the total number of coupons issued to those recruiters, where \emph{w} ranges from 1 to \emph{maxWave}. Seeds are counted as participants at Wave 0.}

\item{bruteMC}{logical; If TRUE then use a brute force Monte Carlo approach to obtain empirical data and estimate sample size distribution;
If FALSE then compute the theoretical results of sample size distribution using an approximation algorithm.}

\item{tol}{scalar; Accuracy loss limit control, which is set up for the approximation algorithm when \emph{bruteMC}=FALSE, with default of 0.025.
This parameter determines the acceptable level of accuracy loss in the approximate computation of the sample size distribution.}
}
\value{
a list consisting of the following elements:
\item{Pr_Extinction_list}{vector; a vector of extinction probabilities, i.e., probability of not recruiting any new participants at each wave.}
\item{Pr_Size_by_Wave_w}{list; probability mass function and complementary cumulative distribution function of
attaining a certain sample size (including seeds) by each wave, w=1,...,maxWave. The round of seed collection is counted as wave 0.}
}
\description{
Calculating the accumulated sample size distribution by each wave.
}
\examples{
x <- calSize(s=10,c=3,maxWave=9,rr=0.3,bruteMC=FALSE,tol=0.025)

}
\references{
Raychaudhuri, Samik. \emph{Introduction to monte carlo simulation}, 2008 Winter simulation conference. IEEE, 2008.
}
