% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findbetamupsi_panel.r
\name{findbetamupsi_panel}
\alias{findbetamupsi_panel}
\title{The findbetamupsi (panel) function}
\usage{
findbetamupsi_panel(themean.vec, psi.percentile=0.90,
percentile.median, percentile95value,
seed = 280385, nsims = 10000, root.method = "multiroot")
}
\arguments{
\item{themean.vec}{specify the multiple sources prior belief about the mean as a vector. Each mean should take a value between 0 and 1.}

\item{psi.percentile}{specify the level of confidence that a certain fraction of the units under study has a prevalence less than the percentile.median. It takes a value between 0 and 1 and the default is 0.90.}

\item{percentile.median}{specify the median value that corresponds to the defined psi.percentile. It takes a value between 0 and 1 and has to be higher than both themean and the percentile.}

\item{percentile95value}{specify the value that the percentile.median does not exceed with 95\% confidence. It takes a value between 0 and 1 and has to be higher than the percentile.median.}

\item{seed}{A fixed seed for replication purposes.}

\item{nsims}{Number of simulations for the creation of various summary metrics of the elicited prior.}

\item{root.method}{Choose between two alternatives to solve the two non-linear equations to identify the hyperparameters of psi. root.method="multiroot" involves the basic function of the rootSolve package, root.method="nleqslv" involves the base functions of the nleqslv package.}
}
\value{
param_beta: The beta distribution parameters Beta(a,b)

param_gamma: The gamma distribution parameters gamma(a,b)

summary: A basic summary of the elicited prior

input: The initial input value that produced the above prior.

param_upper: simulated mu and psi of Beta(mu psi,psi(1-mu))
}
\description{
A function to estimate (a) the parameters of a Beta distribution for the expected mean of a proportion - usually the prevalence of disease/infection for the units in an area/region and (b) the parameters of a Gamma distribution expressing our prior belief about the variability of the prevalence estimates across the units of the area/region under consideration.
Information should be provided about the mean as a vector corresponding to multiple prior mean prevalences from experts or studies.
}
\examples{
## Example
## The mean prevalence of a disease/infection for the units within an area/region
## is thought to be 8\%, 20\%, 10\%, 15\% 20\% , 22\%, 10\%, 2\%, 2\%, 4\%, 5\%,
## we are also confident that 90\% of all units have a prevalence
## less or equal to 0.60 and we are 95\% certain that it does not exceed 0.70

findbetamupsi_panel(
  themean.vec = c(
    0.4, 0.2, 0.1, 0.3,
    0.4, 0.5, 0.1, 0.02, 0.04, 0.05
  ), psi.percentile = 0.90,
  percentile.median = 0.60, percentile95value = 0.70
)

findbetamupsi_panel(
  themean.vec = c(
    0.4, 0.2, 0.1, 0.3,
    0.4, 0.5, 0.1, 0.02, 0.04, 0.05
  ), psi.percentile = 0.90,
  percentile.median = 0.60, percentile95value = 0.70,
  root.method = "nleqslv"
)

}
\references{
Branscum, A. J., Gardner, I. A., & Johnson, W. O. (2005): Estimation of diagnostic test sensitivity and specificity through Bayesian modeling. Preventive veterinary medicine, \bold{68}, 145--163.
}
