% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findbeta_raw.R
\name{findbeta_raw}
\alias{findbeta_raw}
\title{The findbeta (raw) function}
\usage{
findbeta_raw(themean=NULL,themedian=NULL,themode=NULL,
 thevariance=NULL, therange=c(0,1), seed=280385, nsims=10000)
}
\arguments{
\item{themean}{specify your prior belief about the mean. It takes a value between 0 and 1. Not to be specified if a value has been given for the median or the mode.}

\item{themedian}{specify your prior belief about the median. It takes a value between 0 and 1. Not to be specified if a value has been given for the mean or the mode.}

\item{themode}{specify your prior belief about the mode. It takes a value between 0 and 1. Not to be specified if a value has been given for the mean or the median.}

\item{thevariance}{specify your prior belief about the variance. If the selected variance is larger than possible, the variance will be adjusted downwards to create comply with the range of a probability.}

\item{therange}{specify your prior belief about the range. It should be a two number vector that c(ul,ll), where ul>0, ll<1 and ul<ll. This scale metric applies for themode and themedian options.}

\item{seed}{A fixed seed for replication purposes.}

\item{nsims}{Number of simulations for the creation of various summary metrics of the elicited prior.}
}
\value{
parameters The beta distribution parameters Beta(a,b)

summary A basic summary of the elicited prior

input The initial input value that produced the above prior.
}
\description{
A function to estimate the parameters alpha and beta of a Beta distribution based on the existing prior beliefs (data and/or expert opinion).
Information should be provided on the raw values of the mean (or the median or the mode) and a corresponding scale metric, either the variance or the range of the parameter.
}
\examples{
## Example 1
## Based on the available literature the mean value for the sensitivity of a test
## is expected to be 0.90 and its variance equals to 0.1.

findbeta_raw(themean = 0.90, thevariance = 0.1)

## Example 2
## Based on the available literature the median value for the specificity of a
## test is expected to be 0.99 and its range between 0.1 and 1.

findbeta_raw(themedian = 0.70, therange = c(0.1, 1))


# Mode

findbeta_raw(themode = 0.70, therange = c(0.1, 1))

}
\references{
Branscum, A. J., Gardner, I. A., & Johnson, W. O. (2005): Estimation of diagnostic test sensitivity and specificity through Bayesian modeling. Preventive veterinary medicine, \bold{68}, 145--163.
}
