% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowSums.R
\name{rowSums}
\alias{rowSums}
\alias{colSums}
\title{Calculates the sum for each row (column) of a matrix-like object}
\usage{
rowSums(x, na.rm = FALSE, dims = 1, ...)

colSums(x, na.rm = FALSE, dims = 1, ...)
}
\arguments{
\item{x}{An NxK matrix-like object, a numeric data frame, or an array-like
object of two or more dimensions.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{dims}{A single integer indicating which dimensions are regarded
as rows or columns to sum over. For \code{rowSums}, the sum is over
dimensions \code{dims+1, ...}; for \code{colSums} it is over
dimensions \code{1:dims}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the sum for each row (column) of a matrix-like object.
}
\details{
This man page documents the \code{rowSums} and \code{colSums}
\emph{S4 generic functions} defined in the \pkg{MatrixGenerics} package.
See \code{?base::\link[base]{colSums}} for the default methods (defined
in the \pkg{base} package).
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowSums(mat)
colSums(mat)
}
\seealso{
\itemize{
\item \code{base::\link[base]{colSums}} for the default
\code{rowSums} and \code{colSums} methods.
\item \code{Matrix::\link[Matrix]{colSums}} in the \pkg{Matrix} package
for \code{rowSums} and \code{colSums} methods defined for
CsparseMatrix derivatives (e.g. dgCMatrix objects).
}
}
\keyword{algebra}
\keyword{arith}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
