% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointegrating_rank_estimation.R
\name{T.rho}
\alias{T.rho}
\title{Test for equality of all elements in an estimated d-vector based on pairwise comparisons.}
\usage{
T.rho(data, d.hat, m, m1, alpha = 0.05, s_bar = 1,
  h_n = 1/sqrt(log(max(dim(data)))))
}
\arguments{
\item{data}{data matrix of dimension (qxT).}

\item{d.hat}{the estimated d.vector}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.
used for the estimation of G, usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{m1}{the bandwidth parameter used for estimation of d.vec with m1>>m}

\item{alpha}{the desired significance level for the tests}

\item{s_bar}{number of subvectors to be tested in partitioning procedure. 
Default is \code{s_bar=1}, for independent use.}

\item{h_n}{bandwidth parameter. Default is \code{h_n=1/sqrt(log(max(dim(data))))} 
which is recommended by Nielsen and Shimotsu (2007) in their simulation study. 
Robinson and Yajima (2002) argue non-rejection with h_n=0 would imply 
non-rejection with any h_n>0.}
}
\description{
\code{T.rho} Uses pairwise test as suggested by Robinson and Yajima (2002) to test
for the equality of the memory parameters in a vector series.
}
\examples{
library(fracdiff)
T<-1000
d1<-0.2
d2<-0.4
X<-cbind(fracdiff.sim(n=T,d=d1)$series,fracdiff.sim(n=T,d=d1)$series,
fracdiff.sim(n=T,d=d2)$series,fracdiff.sim(n=T,d=d2)$series)
alpha<-0.05
m1<-floor(1+T^0.75)
m<-floor(1+T^0.65)
lW.wrap<-function(data,m){local.W(data,m)$d}
d.hat<-apply(X,2,lW.wrap, m=m1)
T.rho(data=X, d.hat=d.hat, m=m, m1=m1)
}
\references{
Robinson, P. M. and Yajima, Y. (2002): Determination of cointegrating rank
           in fractional systems. Journal of Econometrics, Vol. 106, No.2, pp. 217-241. 
           
           Nielsen, M. O. and Shimotsu, K. (2007): Determining the coinegrating rank in 
           nonstationary fractional systems by the exact local Whittle approach. Journal of Econometrics,
           141, pp. 574-596.
}
\author{
Christian Leschinski
}
