% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CH03_LM.R
\name{FCI_CH03}
\alias{FCI_CH03}
\title{Rank estimation in fractionally cointegrated systems.}
\usage{
FCI_CH03(X, diff_param = 1, m_peri, m)
}
\arguments{
\item{X}{vector of length T.}

\item{diff_param}{integer specifying the order of differentiation in order to ensure stationarity of data, where diff_param-1 are the number of differences. 
Default is \code{diff_param=1}.}

\item{m_peri}{fixed positive integer for averaging the periodogram, where \code{m_peri>(nbr of series + 3)}}

\item{m}{bandwith parameter specifying the number of Fourier frequencies
used for the estimation, usually \code{floor(1+T^delta)}, where 0<delta<1.}
}
\description{
\code{FCI_CH03} Rank estimation in fractionally cointegrated systems by Chen, Hurvich (2003).
 Returns estimated cointegrating rank.
}
\examples{
T<-1000
series<-FI.sim(T=T, q=3, rho=0.4, d=c(0.1,0.2,0.4), B=rbind(c(1,0,-1),c(0,1,-1),c(0,0,1)))
FCI_CH03(series,diff_param=1, m_peri=25, m=floor(1+T^0.65))
}
\references{
Chen, W. W. and Hurvich, C. M. (2003): Semiparametric estimation of multivariate fractional cointegration.
Journal of the American Statistical Association, Vol. 98, No. 463, pp. 629 - 642.
}
\author{
Christian Leschinski
}
