##########################################################################################
####            Testing fractional cointegration                                   #######
####               Nielsen (2010)                                                  #######                     
##########################################################################################

#' Simulated critical values for N10, memory in (0.51,1.49), dim_series<13, d1=0.1
#' @keywords internal
### for d1=0.1, without trend
crit_N10<-function(d, nbr, alpha)
{
 quant_90 <- matrix(data=c( 
2.4722064552583, 4.7120807148826,7.01747827791827,9.43619191020747,11.949569940919,14.5027952726024,17.0920186452209,19.7689432902916,22.4741383615102,25.2321581141748,27.9951028349063,30.7840045748598    ,
2.41336529911351,4.66831192606164,6.9353515401849,9.32515159122999,11.8069522661731,14.3168548324066,16.9346243447911,19.5777143658348,22.2721168337346,24.9677352047754,27.7354734967508,30.5130395373417   ,
2.39402047822975,4.56736674114085,6.81687389062708,9.19332678625999,11.6240607934153,14.1509015980509,16.7367148003184,19.3674682474833,22.0236701906468,24.7380315963452,27.4668605315989,30.2312220521893  ,
2.35009798294685,4.50254644673517,6.75556032014332,9.09542857126116,11.4994901992314,13.9998150937297,16.5533594790109,19.1827419608543,21.8054855339349,24.4812863171895,27.2098394600681,29.9787425409586  ,
2.30981213202038,4.41358258047816,6.64769555569082,8.94676695310989,11.3732043171873,13.8512732318766,16.403512212413,18.9617015742774,21.611440575116,24.2702076497207,26.9600818893985,29.7236952525235    ,
2.27606429919184,4.35899508511541,6.57782478848999,8.8481474187765,11.2562542053291,13.7081426254535,16.2272556174034,18.7825676894065,21.3918856421141,24.0539039757609,26.7513909001535,29.4569996661119   ,
2.24952739278009,4.31277973539439,6.46365488497839,8.75497313853163,11.1295375203656,13.5568501016662,16.0708065335535,18.6087019534698,21.1922674791246,23.8406535116445,26.5147021413025,29.2150079129132  ,
2.22194947039379,4.25132803399204,6.38625650540364,8.65878905162943,10.9965321290365,13.4318876866074,15.8918183543013,18.4308732841087,21.026384395987,23.62653712657,26.2887290226043,28.9731386107821     ,
2.17638794393224,4.18878997612568,6.30542174220302,8.54266448236428,10.8876560112566,13.2858149162603,15.7559785075192,18.2883325285693,20.8221287882029,23.4254102626656,26.0742883299582,28.7601061585591  ,
2.14345214851864,4.13769592905302,6.23785209324159,8.45738393400486,10.760436555441,13.1486902600561,15.5857147434286,18.0955189768505,20.6512086905747,23.2338997732009,25.865311648462,28.5211375114337    ,
2.12621897401527,4.08619055363905,6.15753894758767,8.35075338277314,10.6630716289152,13.0129344491604,15.479589243723,17.9253760416756,20.4592877707701,23.0488735136507,25.6532210176682,28.303060412128    ,
2.1097879040264, 4.03012946179609,6.08646711479565,8.28009916398431,10.5531282050858,12.8990135880657,15.3200309480928,17.8005151571073,20.2978717926968,22.860232462285,25.4625864737762,28.0948895019809   ,
2.07216523625776,3.97333058018993,6.02621375945037,8.20334884413399,10.4548874748045,12.7986799376704,15.1882799077662,17.6552891575192,20.1425154149267,22.6803989522832,25.2681205685192,27.8809615768072  ,
2.03961148597203,3.93147369493301,5.96699570915095,8.10298696317018,10.3475003159983,12.6588609799535,15.0472793031444,17.4971480267137,19.9706082922541,22.5129517355012,25.081681406957,27.6737161532301   ,
2.01309280145761,3.88003314740672,5.90162535625429,8.03729093456954,10.2715257508598,12.5690494785523,14.9178654245379,17.36263202547,19.8401819682142,22.3611793358583,24.9097960281149,27.4912266287629    ,
1.99236286796383,3.83611923784364,5.83458274854018,7.95284938148458,10.1752499431537,12.4593268517226,14.8200509025552,17.216954956362,19.68298499611,22.1818212377261,24.7257575559023,27.2961973290545     ,
1.97390270215269,3.77914515836617,5.78983546365975,7.88766817427214,10.0769784489205,12.3608016812254,14.6981258561704,17.0916685138993,19.5295072669747,22.0431778765578,24.5601146487415,27.1161652550775  ,
1.9493564625161, 3.76281640164873,5.74219372137472,7.81912580792364,9.98995373450792,12.2656815530502,14.60906576093,16.9816224689405,19.3917461881682,21.8705227127561,24.3918134048283,26.9516793651941    ,
1.91567003262866,3.71042593496026,5.68350862738119,7.75371527586784,9.92605448610662,12.1743720458576,14.4802006602586,16.8434719086313,19.2761684434196,21.7282240511508,24.2339714433535,26.7813408949722  ,
1.90212923472177,3.68954359239696,5.62170878097377,7.68972145218093,9.84043379052681,12.0674286785473,14.354761685406,16.7222159400984,19.1303774915935,21.5921207487185,24.0758389936742,26.5915059080264   ,
1.8892335066771, 3.64293968537679,5.58072367783836,7.61601891426881,9.76546549840475,12.001774208969,14.2810282222925,16.6309884834482,19.0042495594347,21.457527393903,23.9188598220369,26.440365256262     ,
1.86379105486946,3.6145227907454,5.52328704566506,7.5623290131359,9.70220424033845,11.9058149748203,14.1813861777702,16.5067524929939,18.8727637784941,21.3031816651228,23.7714783874247,26.2810056616698    ,
1.83775996321124,3.57245070054119,5.47031104030477,7.52541897437438,9.63478312922547,11.8198476789836,14.1017494319283,16.4007560595383,18.7721129832465,21.172494203631,23.6242355135632,26.1502863886865   ,
1.83309275392757,3.52773274218203,5.43123953295113,7.46113174234264,9.55010244483966,11.7362879564461,13.9861530883349,16.3199382454568,18.6569709865283,21.0589063622042,23.5116606179662,25.9880727371263  ,
1.80478893807919,3.5205869658861,5.38019473527148,7.38972143871249,9.49684081679568,11.6712378431121,13.9046121207273,16.210161457856,18.5504284490094,20.9462158015195,23.3888830853912,25.8504356028104    ,
1.79517749749045,3.48439074250697,5.34566023748861,7.35414813945212,9.43927828590692,11.6108917684722,13.829251548255,16.1099246081603,18.4459470186549,20.829029150553,23.2571917073999,25.7100495609705    ,
1.77358348859623,3.46853939827916,5.31396575256543,7.29175169278321,9.37317731902501,11.5282162136411,13.7478240612408,16.0247754412423,18.3417535514987,20.7099762724266,23.1283269295574,25.5764766011024  ,
1.75364783732463,3.43934734702743,5.28322108836456,7.25570351326694,9.29039019357577,11.4612343908404,13.6698896920232,15.9266014856173,18.2539471182998,20.6192774995451,23.0108998225049,25.4648426007277  ,
1.7309092051131, 3.40453943692795,5.2472204808485,7.2094439876749,9.25873543879636,11.4013914535329,13.5925344120663,15.8559326691324,18.1586301493276,20.5024410210476,22.8910270820342,25.3270847261423    ,
1.7311765684353, 3.36738042591866,5.21174812381224,7.16949779638224,9.21085434230786,11.3286322522406,13.5232131620732,15.7640285863816,18.0751186981459,20.4100312173078,22.8016705944929,25.2168883132875  ,
1.69497863372225,3.36393407668321,5.17519374704366,7.12885555956972,9.17300727486672,11.2774289831407,13.4643937454994,15.6828375072677,17.9685061983484,20.3217038389522,22.6992504360053,25.1175500275532  ,
1.71006450424395,3.33336839802905,5.14674101339032,7.0792573279689,9.11074136916111,11.2141316464189,13.3736709649167,15.6143394779095,17.8920313043631,20.2243703445652,22.5948510250196,24.9919949471236   ,
1.68483961102796,3.31952427327643,5.119501405524,7.05608524059105,9.06201396374807,11.162099734464,13.3293427745815,15.5406595824862,17.8070302674007,20.1366380364468,22.4943335160082,24.8883347964629     ,
1.66157657775786,3.3008113553525,5.09966190523759,7.0060293795628,9.024229996142,11.1145033875837,13.2685088946921,15.4639722095168,17.729853061494,20.0249583894103,22.3921011471518,24.7769077031142       ,
1.66341335582945,3.29305148123038,5.0760148164456,6.97172384635029,8.98289926381471,11.0575104199665,13.191178022449,15.4056688331183,17.6612159226619,19.9753305460595,22.2961209164503,24.6808674752002    ,
1.65071324301167,3.24874468378432,5.04242350071632,6.9422604519131,8.95570792941564,10.9999858928123,13.1446943032582,15.3315597542351,17.5889747427972,19.8758877304643,22.2018024948365,24.5831400737583   ,
1.63652596106854,3.25873823473994,5.01224908528815,6.91092810317354,8.90500307329849,10.9616407045806,13.0974439537448,15.2825579451209,17.5109802953133,19.7942459376118,22.1155333161394,24.4961525539891  ,
1.6315524127653, 3.21532941005323,5.00760676295074,6.87634609196067,8.86535538297528,10.9098618861462,13.0337713836404,15.2129406016193,17.4496968936355,19.7245430476623,22.0500993940956,24.3879112733935  ,
1.62881987853392,3.21809212297289,4.96723522985649,6.84987150158371,8.82444711972193,10.8858389720836,12.9894794246928,15.1582272806746,17.3822064103988,19.6580214533916,21.9583039783232,24.3153367014145  ,
1.61004535655226,3.19285488301164,4.95380824475275,6.82210555758793,8.78577567584748,10.8289339142731,12.9376532829864,15.0968150492991,17.3226839190148,19.5868697257545,21.8743225937893,24.2265126817369  ,
1.60435930244236,3.18469243650472,4.92852425363732,6.80015204838728,8.76518661640418,10.7897912627326,12.9002916911779,15.0556191011366,17.252284417931,19.5136551239695,21.81118785967,24.151406204489      ,
1.60549795157644,3.16436256562128,4.92353449304418,6.77474498393324,8.73053162312556,10.7491938166169,12.8324098608269,14.9982717656137,17.200083811363,19.4545335533541,21.7377079488758,24.0761454031755   ,
1.58457074493302,3.15420505165527,4.89565427320494,6.74324072972839,8.69392550119308,10.7054860534687,12.80477673872,14.950898436949,17.1409523156055,19.3773873040595,21.6684659682989,23.9935081151982     ,
1.57638307224234,3.14666893433875,4.86674043162406,6.71828361049641,8.65556398277453,10.6804793971896,12.7613283978096,14.8995250119668,17.0973731173455,19.3312991956191,21.5967630232751,23.9241059400212  ,
1.57451210449967,3.12310946683984,4.86852795878097,6.69571447286776,8.63987601112787,10.6450939775735,12.7222892737191,14.8489950353993,17.0296484865559,19.2640219599793,21.5435095030934,23.8452324809719  ,
1.55706972044581,3.11217293384945,4.83494232910928,6.6861773597759,8.61232055135171,10.617038801616,12.6834591584361,14.7944488130849,16.9819903915896,19.225878550191,21.472066438221,23.7822501033627      ,
1.56516485980072,3.09674683107982,4.82878244879723,6.66058382727221,8.58492220201217,10.5886378914454,12.6456632965495,14.762703985528,16.9336579983517,19.1534497492641,21.4171039768026,23.7179683660789   ,
1.56132757728494,3.08981922481826,4.80662820672865,6.63377358986599,8.55392286747823,10.5436948656903,12.6165559888863,14.7260630294375,16.888064070512,19.1014975421946,21.3723166241753,23.6526008489181   ,
1.53895019581135,3.07252785843083,4.79641072711374,6.61636629024247,8.523626887324,10.5250769036209,12.5654986783331,14.6886177649169,16.8479618394809,19.0510343622135,21.3053115667462,23.590926828316     ,
1.52889167815983,3.07436521545904,4.78747873355081,6.59405179056527,8.50117620511436,10.4789030995964,12.5435448712417,14.6288570215266,16.7925953271407,18.9967360706975,21.2554054498615,23.5345341587299  ,
1.53448361712231,3.0708752156884,4.76380994571189,6.57592432705468,8.48928841987241,10.4578344021278,12.5092217768962,14.6123170550543,16.7539330242298,18.9584486589526,21.1841701751096,23.4791571489081   ,
1.530616703258,  3.04782256913064,4.74718961025464,6.55551260395835,8.46454483306557,10.4350174245883,12.467536007617,14.5768032603081,16.7059147042384,18.90906385349,21.1473594019115,23.4187425986708     ,
1.51620463952436,3.04686264114924,4.74667332998359,6.54598028137001,8.44258365159524,10.405369089724,12.451510809115,14.5319145610717,16.6677729443788,18.8543464977925,21.0941570937006,23.3660269299646    ,
1.52555517634435,3.0380776404907,4.72721303934397,6.52814657348166,8.41640286054257,10.3851381656327,12.4177355739824,14.5119223075983,16.635877741283,18.8133418189916,21.0480690667454,23.3073913310199    ,
1.51806794598876,3.03026231932455,4.7165919273434,6.51360838639432,8.40102597585652,10.3708889157664,12.3799052199748,14.4643781117414,16.5961619158381,18.7755171319534,21.0026934116047,23.2627076366444   ,
1.50028679407876,3.01975652784639,4.71060790895359,6.49983245946548,8.37648191347857,10.3344399001965,12.3623845497033,14.4264932413315,16.5576544382987,18.7414473658412,20.9586769194986,23.2151197206238  ,
1.51540988573136,3.01332956542669,4.69285607266593,6.47684834044765,8.36280311882355,10.3181391444348,12.3302560493286,14.403903304329,16.5364991426025,18.7082841196473,20.9095352313397,23.1694041601025   ,
1.50376181467015,3.00201980374244,4.68690898904114,6.47472630939527,8.33903978629862,10.2966113684781,12.301481532094,14.3813901639991,16.5039876807048,18.6641544531707,20.8686791532316,23.1234090356328   ,
1.48825335700987,2.99616379015906,4.68173881200777,6.46619387329274,8.32785115389691,10.2820707993627,12.2842007245671,14.3424672210863,16.4655315663596,18.6302100605692,20.8289386983647,23.0705925969145  ,
1.50163753703912,2.98935856308309,4.67114330122113,6.45214899888937,8.30810527446159,10.2421979484885,12.2559309880928,14.3243787219442,16.4291657944711,18.5911617788293,20.7936896076641,23.0380909211005  ,
1.48382045567651,2.99660612696972,4.65132927081505,6.42223347566209,8.29065923830796,10.2358401834383,12.2384227760062,14.2928903407624,16.4020170601888,18.5592764198677,20.7521095791203,22.9914383897025  ,
1.48845548989496,2.97426343670343,4.6465908384016,6.41424139299023,8.27032876082298,10.2117455862669,12.2132025788087,14.2627447799621,16.3730224391715,18.5242085471625,20.7151059700774,22.9643078142167   ,
1.47837149096642,2.97867801676973,4.63533697316633,6.40286716558665,8.26579594131178,10.1901898750718,12.1880075296383,14.2375072016484,16.346328827057,18.4864471758369,20.6749074023364,22.9062096784403   ,
1.48907652621616,2.9671120736726,4.63359086501774,6.40194636604916,8.24359994344273,10.1750697337898,12.162268848022,14.2113436065326,16.3221507344994,18.4514736968014,20.6493029335727,22.8753921361322    ,
1.46741781931172,2.96769630742271,4.61523724391016,6.37565278740499,8.2436341435682,10.1522896214335,12.1451764273588,14.2019458216175,16.286456461896,18.4343803273324,20.6022665643219,22.842524642579     ,
1.48241181125166,2.95217477936218,4.61068866407292,6.38033679602703,8.22708107141895,10.1424669465914,12.1260003227654,14.1631611344882,16.2616233690581,18.4071256029673,20.5823356576925,22.8040763818681  ,
1.47099034763043,2.95006776470879,4.61173213273303,6.36411299242995,8.21155830070677,10.1290587344508,12.1103412383449,14.1494531484076,16.233299896979,18.3648830632904,20.5557783863011,22.7688367638252   ,
1.46720133941673,2.95083266598052,4.59051627504678,6.35134015320421,8.19384097404888,10.1242368347489,12.0841570205792,14.1240286571042,16.2152802409053,18.3533370107372,20.5315357503263,22.7315667458555  ,
1.46709550194161,2.93981479232467,4.59089478171299,6.34780925368747,8.18357197295628,10.0966178511491,12.0745109417877,14.1051470874475,16.1954780615219,18.3219061750422,20.4895300848049,22.6954174816931  ,
1.4596016447482, 2.94662287786833,4.57627983309533,6.34109387897322,8.17506505523875,10.0938254184935,12.0478977065954,14.0904937539749,16.1683442175664,18.2910204907367,20.459625279474,22.6743269229683   ,
1.46250297413143,2.93802490673599,4.58459240552108,6.31566984952887,8.16083102265838,10.0665588754088,12.0404617662719,14.0673908924211,16.1387846263668,18.2603094448625,20.4323649621897,22.6320826681012  ,
1.44870747345791,2.93079997498007,4.56033505288464,6.32287052609995,8.14736046353084,10.0564010953939,12.022753063899,14.0477438221437,16.1240765976842,18.2477207392461,20.4074576388159,22.6136485107045   ,
1.45997486629205,2.92473975745786,4.57408903274421,6.31368684285735,8.15223186570858,10.0367700039636,12.0095801829998,14.0271393102084,16.1039105779383,18.2299851435342,20.3777101520114,22.5845054515748  ,
1.45309641193978,2.9284530815515,4.56281027118993,6.29666153266239,8.12599930507467,10.0269189227561,11.9859772792087,14.0091078838676,16.0846733050303,18.1927065371678,20.3518392134324,22.5568896869095   ,
1.45435213392851,2.91791141967792,4.55971592126476,6.28878539579289,8.11907845985137,10.0135367152046,11.9695518221526,13.9935237188165,16.0610707142324,18.1751864640195,20.32837951043,22.5270003066359    ,
1.4440354729114, 2.91121487029259,4.54303104697721,6.28750760869993,8.10254872402107,10.0080059037844,11.9567041061771,13.9757412562578,16.0458231592948,18.1506877990957,20.3054130171457,22.4903747143733  ,
1.44801364045903,2.91241023392818,4.54514573697058,6.2798908595739,8.09816198032508,9.99480696459432,11.9502087507314,13.9670327458685,16.0188483924483,18.1342918327744,20.2838975844757,22.4679159396773   ,
1.45319581725971,2.90560320250057,4.53852322054422,6.26634434014192,8.0884417854266,9.98678112945836,11.9382434022401,13.9450626343721,16.0143474296754,18.1131748508536,20.2522704527901,22.4428339259878   ,
1.44479076443317,2.90866141883112,4.53323698507924,6.26690460449673,8.07760026983854,9.96979534545805,11.9219343965739,13.9359265088781,15.9922944874996,18.0934701298474,20.2345199859748,22.4260352853409  ,
1.43503002849961,2.90716072045737,4.52665014854827,6.25341577883568,8.06496495173519,9.96263324652791,11.9179116665172,13.9115786698966,15.9727958219309,18.0722613244284,20.2146123593726,22.4019351031534  ,
1.43823955376038,2.89870363038744,4.51575823918491,6.24667572857123,8.06540410892348,9.94139238789778,11.9039803288748,13.8992002072602,15.9555011629262,18.05635081821,20.1960806840257,22.3824112103299    ,
1.43985019266089,2.89656763353771,4.51950208241426,6.24527565089795,8.04822709278548,9.94105592831892,11.8879830143405,13.8902058868293,15.9475950770763,18.0416086207955,20.1757209320701,22.3610411511223  ,
1.42951541578131,2.8886045396157,4.51682230012636,6.23676270212121,8.04480466670784,9.9234581093549,11.8800681602105,13.8746768811922,15.9274485931439,18.0119166891435,20.1509114433424,22.3343869185019    ,
1.43266168806332,2.89031933015203,4.50484432715731,6.22778666813667,8.05548430215946,9.91501780490472,11.8690395633547,13.8615866792916,15.9098967243292,18.0055111611697,20.1378461123648,22.3194456338202  ,
1.43768170449007,2.88678094806196,4.50405463282505,6.22569626139873,8.03594338505615,9.90651552827605,11.8474926137147,13.8442548863223,15.8934306435353,17.9895563850996,20.1106710096989,22.2947475162548  ,
1.43646915581783,2.88465170693266,4.50181381459519,6.21704976335545,8.02742028274268,9.89732198473828,11.8385600252297,13.8337327178592,15.8780240523328,17.9704648057933,20.0993894592485,22.2707895902704  ,
1.43286629649631,2.87494401110015,4.49596156212887,6.21569376809923,8.02137128399625,9.89495754375512,11.8306948089158,13.8247179529196,15.8654469886351,17.9540979220604,20.080069772531,22.2553738702062   ,
1.43105069533332,2.88264376374266,4.49674686446162,6.21152827768502,8.00850722254543,9.88673416811234,11.8150680400017,13.8171164330476,15.8552840586433,17.9422201551745,20.0677940207125,22.2330283831812  ,
1.42766683392088,2.88392594161886,4.48506078246652,6.19455282531403,8.00746206214398,9.87963321981998,11.8132213027104,13.805272956242,15.831898440924,17.929408901964,20.0497042952592,22.2150814572801     ,
1.42285270977177,2.87622300687683,4.48591766135371,6.20464188534659,7.99478447271763,9.86826303325307,11.8077196589567,13.7881421642426,15.8229998361115,17.9048540104421,20.0314797399139,22.1939683367     ,
1.42968384124064,2.87447638998262,4.48816823748637,6.20051583779937,7.98608482440648,9.85808097998787,11.7903588258607,13.7835727983434,15.8097826186214,17.9009829442332,20.0169576933255,22.1853283371157  ,
1.42886969003175,2.86385747450314,4.47806933866914,6.19459550527092,7.9819486649013,9.85211846774582,11.7816901445946,13.7713634687061,15.8022789536987,17.8802292239172,20.0015897069096,22.164262073669    ,
1.41454218481203,2.87049950917943,4.47254953754146,6.17870037284952,7.98739804359886,9.85205154497961,11.7803239436085,13.7589319001855,15.7941340310584,17.8654484410671,19.9829830322223,22.1499787480179  ,
1.42101392321158,2.87348181091912,4.46852651247567,6.17429820703554,7.97587105334209,9.8366656014884,11.7680260025943,13.7483667910533,15.7822872931129,17.855914772382,19.9663241898423,22.1292869868886    ,
1.42744392134876,2.8660091573886,4.46743154153139,6.17202954350111,7.97359194111208,9.83711515776199,11.7572132408736,13.7303336101389,15.7666201162373,17.84083506753,19.9624909851144,22.1199840199696     ,
1.42099924961912,2.86137549616598,4.47488265999177,6.17028701083523,7.96442312004883,9.82404263306047,11.7471410734136,13.7303995080282,15.7535139579164,17.8243352663382,19.9431220524783,22.0922887182678  ,
1.41908362563969,2.86853835048018,4.46589168896728,6.17137282715231,7.96303005870588,9.81337160136988,11.7474310489056,13.7153729465448,15.746834402267,17.8247861869364,19.9324636860512,22.0884736972375   ,
1.42605190845516,2.86739348634956,4.4606874573681,6.16650941806804,7.9597181552988,9.81518711624821,11.7370547906904,13.7135866064287,15.7392373312039,17.8015797173128,19.9185574133551,22.0629718846959    ,
1.41882106224278,2.86682181145456,4.45400369880127,6.16676903692679,7.94938070399224,9.80356272282272,11.7322558664616,13.6947001507488,15.7195874953008,17.7969088520745,19.9036262304744,22.0539640829242 
), nrow=99,ncol=12, byrow=T) 
                                                                                                                                                                                            
 quant_95 <- matrix(data=c(                                                                                                                                                                                           
2.57007655333955,4.85780327642735,7.16987787997775,9.57977248012041,12.1068121344278,14.6487679144368,17.2538464385427,19.9270927406713,22.624728223594,25.3873949485897,28.1499021962863,30.9524254554695   ,
2.52039507703295,4.82835241753018,7.10601169898468,9.49292634810647,11.9682044166908,14.4854772801571,17.0701978624507,19.7301577856168,22.4247911505177,25.1268073577476,27.8867728317428,30.6750334004159  ,
2.50306674792583,4.7216096009376,6.98384285145533,9.36380593886314,11.7923536848272,14.2989509551161,16.8752070427255,19.5211898113736,22.1798364751828,24.8814545195129,27.620123971148,30.3909439869184    ,
2.46260871504641,4.67181769304301,6.91143076275344,9.26056045105452,11.6699364090739,14.1510165901449,16.7161818248281,19.3250519514963,21.9656569976726,24.6443683124809,27.3394556049596,30.1315596152501  ,
2.42417422396938,4.58847804566765,6.80414374410211,9.09737814806194,11.5177562911276,13.996582923464,16.5584349223518,19.101592176266,21.7475732491766,24.426055709379,27.1184161278511,29.8710186672624     ,
2.3884021224788, 4.51028203797944,6.73632163485621,9.00893284417388,11.4032459075277,13.8507229095617,16.3790581927955,18.9413715861386,21.567927856164,24.2137072156063,26.8955902408683,29.6136938940049   ,
2.35333474140743,4.46107708727475,6.61629450743126,8.9118489900645,11.2634889434555,13.7093586404552,16.2087846038925,18.7710630909171,21.3338200365719,23.9981882959126,26.6575591002306,29.354698009076    ,
2.31890504481745,4.41414068823114,6.54504752318935,8.83667947541095,11.1476464411564,13.5755884773016,16.0346099671972,18.5730915632782,21.1607672455114,23.7673559864853,26.4204442058478,29.1175642793346  ,
2.29408185343616,4.34803295793907,6.46109284815824,8.68617397469848,11.0219452868711,13.4381942564935,15.9078307870049,18.4326064646466,20.9498171877261,23.578830772872,26.2083233367846,28.9167195903343   ,
2.25377296727406,4.28581708005254,6.40808972059453,8.59293718292342,10.8988033613239,13.2897535863514,15.7285278570761,18.2509376996134,20.8004277335291,23.3747818377954,26.0210122001857,28.6705551038177  ,
2.24211948836775,4.21697480824513,6.30271328013472,8.50797217323266,10.8032431226724,13.163752807602,15.6059862830968,18.0798697773504,20.6100066164748,23.1939099402709,25.7917863724544,28.4532731381987   ,
2.22983249828375,4.18842306510652,6.21997438331876,8.41839084544066,10.6982095696154,13.0395837638693,15.4525233959832,17.942619887618,20.4424201463712,23.0013342339424,25.5944834832584,28.2409203150003   ,
2.18159772046562,4.10883377626413,6.16761123083447,8.32624097678229,10.5879919520551,12.9325814064244,15.3219868428206,17.7935444230322,20.2853063588724,22.822964953633,25.4020381582405,28.0218403785699   ,
2.15299469522503,4.0917599573503,6.09849082943647,8.25293044356147,10.4828982846525,12.7881164183438,15.1865528654528,17.6311085954081,20.1159135403584,22.650553751305,25.2202332286129,27.814467507488     ,
2.13204004491409,4.02983367786643,6.04740072245863,8.16931527564505,10.4071537452835,12.6955798780268,15.0504746358021,17.4949555043263,19.9810820829634,22.4821215848676,25.04873415187,27.6227338125959    ,
2.09778954614539,3.9856606904064,5.96404843196523,8.08440172153544,10.3079894981712,12.6007268771377,14.9386078302965,17.3481670143977,19.818442921171,22.3112186971926,24.8722563567347,27.4364231902194    ,
2.0858917021772, 3.91613961941411,5.92576084827858,8.02836246713125,10.2166743256749,12.4977350472743,14.8243557731457,17.2275876741937,19.6580138226308,22.1514097155618,24.6998021993534,27.2474585728978  ,
2.05917912821013,3.89687642132857,5.85167193436618,7.95103306965999,10.1156078890246,12.4010217176271,14.7227444751262,17.1149504017347,19.5243124010742,21.9957281816457,24.5229354717242,27.0895000892948  ,
2.02489344074743,3.86109308041547,5.8188076486534,7.87093600091126,10.0457476065968,12.304862178502,14.6137187699903,16.9733952164069,19.403788692773,21.8520842973612,24.3734500060526,26.9288347547916     ,
2.00112120196948,3.82236904608278,5.75341676522154,7.80948080973821,9.95778113729759,12.1947715843654,14.4853229007908,16.8712977103659,19.2559533559401,21.716517040368,24.2119548917538,26.7302670186478   ,
1.99132548303897,3.76742349371436,5.71321661597326,7.7478731561393,9.88542012887256,12.1264821373356,14.4027276501666,16.7395209451972,19.1438266860812,21.5647224561252,24.0497959530854,26.5738683511025   ,
1.97201045862455,3.75397082753884,5.64674908657961,7.69393939501285,9.82146622219814,12.0293290644681,14.2967769554823,16.6220840050202,18.9872627954042,21.4291315254069,23.9089993580875,26.4167820712441  ,
1.94549476174614,3.68785401434587,5.5939504348758,7.63399463773421,9.75235991844238,11.9420572827161,14.2205456712126,16.5303311069224,18.8911734252518,21.3040115411182,23.7544057316813,26.2739973374564   ,
1.9349596019911, 3.66026123116042,5.5654320715018,7.57143887311352,9.67397125808102,11.8516007078961,14.1054400634239,16.4399936195935,18.7816742575092,21.1677283986087,23.6264049941535,26.1227775542401   ,
1.90629825788007,3.64354653489849,5.49858846223445,7.49996908449279,9.61868195740509,11.7905772911988,14.0283360167952,16.3329050192918,18.667837394173,21.0811808561144,23.5063290347332,25.9769248116657   ,
1.894301370961,  3.6089586300595,5.46370566829242,7.47083670385338,9.55030325837,11.7141554807324,13.9545279216274,16.2195058339443,18.5636952347586,20.9572448573905,23.3768833619544,25.8326437838696      ,
1.8727948983228, 3.59255741411982,5.44845505766265,7.40157957695869,9.48161563827149,11.6472021058415,13.8687344986906,16.1398315260837,18.4550947256194,20.8264464099086,23.2413903499193,25.7044385485295  ,
1.85559001621645,3.56825795188537,5.38757336235159,7.36992414549216,9.40338153923215,11.5680395001541,13.7876807120878,16.045869912199,18.3749785001513,20.7228618429861,23.1245981273366,25.5730318252046   ,
1.83421734413932,3.51897150421167,5.35745946755577,7.32007097082595,9.3746519293366,11.5185993806467,13.7102633879124,15.9701969265347,18.2638185111856,20.607171983656,23.0143668897048,25.4530000716587    ,
1.82299764863632,3.47614053518266,5.32797927962311,7.27728022612202,9.3121846367996,11.4346178171927,13.6428682382159,15.8772681823456,18.1783910438966,20.5187841159907,22.9148282054954,25.3313305984407   ,
1.79927525651575,3.47199555831317,5.28325193525091,7.23776638345187,9.26851683753997,11.389073294921,13.5753952917314,15.7945933451231,18.0890570558226,20.4311486663863,22.8080441682614,25.2329830333004   ,
1.80955075439205,3.44294399005058,5.25079545619906,7.18732597680393,9.22228984185797,11.3161366979304,13.4879550188212,15.7303315232836,18.0046347520056,20.3377016566991,22.7089686106459,25.0849857264438  ,
1.78710177817102,3.42650283167731,5.2305520666706,7.16991918555397,9.17321166383225,11.2619620490908,13.4287067805192,15.6487676042419,17.9270254405701,20.2474185118546,22.6033449243729,24.9919689890316   ,
1.76138638129806,3.40837194298512,5.20208037297889,7.10863579425515,9.12590119305938,11.2248093356855,13.3769869623519,15.5627986267039,17.8338548209255,20.1382454648975,22.5017995535326,24.8882046779225  ,
1.75903394923545,3.39219001286288,5.16767846176365,7.07396658265285,9.07778847090967,11.1633091695085,13.2956187349927,15.5293855570795,17.7672217781971,20.0754341782333,22.4069401465529,24.7867778717802  ,
1.73977380206738,3.35516211108297,5.1512268788864,7.0406927857904,9.05679024358061,11.1069214975434,13.2518065041391,15.437834926492,17.6908585295642,19.9777454961585,22.3027054842733,24.6864589858685     ,
1.72571705312861,3.35082623776187,5.12025241744343,7.00381763678499,9.00293173896003,11.0553114413197,13.2023803657997,15.3910526504205,17.6245846728971,19.9158968756658,22.215680862805,24.5913156408635   ,
1.72262283796823,3.32215193365767,5.10375257753214,6.97835813116967,8.96510753863818,11.010484731781,13.1427123570659,15.3147567370298,17.5566533285323,19.8305012117334,22.1415710217939,24.5014713092967   ,
1.71149226280403,3.32137543636738,5.06440383037505,6.94719104757005,8.91839284085722,10.9775577879741,13.0868452398594,15.254249912307,17.4741070038661,19.7663646597792,22.0528712949924,24.4128993411799   ,
1.70752066991598,3.28716113856911,5.04114417192258,6.91570605166046,8.88349585543008,10.9188102778571,13.0390346583881,15.1977607670225,17.4137933169729,19.6821203329089,21.9773585510831,24.3451300513185  ,
1.70235396831352,3.27652405999587,5.01499691586364,6.90661718202838,8.85863757105753,10.8930737147663,12.9941793142578,15.1460297578256,17.3527359875476,19.6158109992235,21.927047591698,24.260711261614    ,
1.68905391828888,3.26118026947114,5.01210516773348,6.86096220175125,8.82719621462602,10.8308098084755,12.9209106141574,15.0993266001901,17.2978158117788,19.5526374531266,21.8460762109945,24.1749192786599  ,
1.66474229439633,3.24330965533307,4.98376771503801,6.83454767777579,8.78780337050119,10.8122529082102,12.9031631527544,15.0452492539653,17.2357049697132,19.4829011368049,21.763497076743,24.1004366026988   ,
1.66366945648747,3.23283596913789,4.95022585560364,6.80626016424198,8.74827002219387,10.7728184646099,12.8432936802989,14.9846060159311,17.1774427224276,19.4240874938909,21.6844375954823,24.0269664396639  ,
1.65949560433487,3.21181018265312,4.94780495448626,6.79880396854313,8.73252246605148,10.7395655176635,12.8146156993152,14.9323496435177,17.1247314665588,19.3557798153209,21.6383489568166,23.9380628704449  ,
1.64820694858687,3.20036176164428,4.92934864851357,6.76855872840359,8.70097533838037,10.7087097171042,12.777306913099,14.8795777023772,17.0713164885161,19.3104100717164,21.5664983066464,23.8730815653152   ,
1.65080597253767,3.18095307129222,4.91419724284364,6.74836589059862,8.67599551438562,10.6672914762909,12.7315138965239,14.8547159784263,17.0182279567094,19.2438208884915,21.51491329237,23.8147205187954    ,
1.63445067142618,3.18126723133863,4.89392816675025,6.72551243714785,8.64218152012156,10.6359618022167,12.6980869715371,14.8073545239646,16.9836099830064,19.1894268441287,21.4580359282404,23.741796751486   ,
1.6281879221698, 3.16044763790811,4.88233022320592,6.70052751925896,8.60626186159443,10.6021990834889,12.6439178179658,14.7728723583018,16.9289129747765,19.1455842554479,21.399627809237,23.6768599114615   ,
1.60638116338869,3.15266350468272,4.86538372817497,6.67476155989188,8.5865253113973,10.5566077161661,12.6214793556663,14.7133404383656,16.8859916348259,19.0856116669972,21.3455555061788,23.6340068155041   ,
1.62312795942871,3.15458833529788,4.85178320262233,6.66212908558054,8.57365880674437,10.5408310305365,12.5921603840798,14.6950976757444,16.84187377724,19.0484369647586,21.2697582168804,23.5688019380776    ,
1.59784960762918,3.13465500862894,4.82231443404831,6.64148251658376,8.54686967848273,10.5235070653051,12.556106251891,14.6558097997496,16.7850714895599,18.9924497901424,21.2340473858016,23.5071004711042   ,
1.60835996852448,3.12812358089218,4.82499469154566,6.62601490559608,8.52785832156819,10.4842566479188,12.5341087887631,14.616709515763,16.7505240075584,18.9417613486241,21.1844498566579,23.450825695571    ,
1.60761442571358,3.12191120161951,4.80527243764301,6.60697316803642,8.49499828848758,10.4653813950381,12.491627410881,14.5881375051451,16.7212768007154,18.9024639748561,21.1469123084232,23.3923712888109   ,
1.59147321609382,3.10469421384091,4.79094697076263,6.59199464262516,8.49190718517085,10.4523179186376,12.4549181887499,14.5458539358876,16.675480328625,18.849876429477,21.0845672235703,23.3470613041296    ,
1.58319514182517,3.09165168230715,4.79071073027931,6.58080320068942,8.4685262074475,10.4235018237483,12.4410425650386,14.5144651276264,16.6448513519192,18.8247343042545,21.0323680192613,23.2988566821177   ,
1.59033403978968,3.09824526726272,4.76902156036558,6.55232810776635,8.44391942263307,10.4040791819401,12.4059102087049,14.4845271689256,16.6183535259095,18.7917052460231,20.9904311030788,23.2585948514847  ,
1.59051899274446,3.08389601903584,4.76600259354053,6.5534799131375,8.41524314961316,10.3703668063793,12.3775753155856,14.4562649600789,16.580408407329,18.7476202338463,20.952528592483,23.2054578889915     ,
1.56637382590891,3.07963020177604,4.76227977469941,6.54190391177649,8.40388805569297,10.3556695104826,12.3634121592912,14.4248131137596,16.5549251716989,18.7101784131449,20.9090280727579,23.1596345087591  ,
1.57134588465127,3.0590064366839,4.74072986806604,6.53302247291835,8.39042317419579,10.3264612499113,12.3309396273144,14.4056754755499,16.5104560257658,18.6677990942827,20.8762530111515,23.1277712239238   ,
1.5642686883652, 3.07924998079572,4.7323037205823,6.49866194333683,8.36594224694618,10.3099506422744,12.3215269318953,14.3666834891862,16.4763387830746,18.6322485575113,20.830860057222,23.0714343926854    ,
1.56337990672039,3.05117192366323,4.72203153011682,6.4839935240473,8.35063272013987,10.2919482414202,12.293512696425,14.3390236534173,16.4529289486409,18.6042043637685,20.7911551016199,23.0425762621537    ,
1.54866991594327,3.05519000873154,4.70978948983366,6.48358095407134,8.33783207642243,10.2690615425806,12.2656274182136,14.3164914922118,16.4247666190914,18.5733879603756,20.7489809007589,22.9776835209152  ,
1.5618056053376, 3.03966590091588,4.71153478770414,6.4728327679674,8.32045378887771,10.2485686011898,12.2411965093515,14.286401886655,16.3890166487076,18.5311475012063,20.7295975875352,22.9584170899961    ,
1.54607997740895,3.03802477386979,4.68404735478,6.45454543208209,8.31815281312987,10.2242279643549,12.2188314763652,14.2659932974538,16.3614827474865,18.5123105205607,20.6780902686024,22.9237203814195     ,
1.54695335644293,3.02906136201481,4.68097450131154,6.45567120628774,8.30461465401625,10.2204009333828,12.1970768208616,14.2380652166772,16.3372418129212,18.4826598041196,20.6551324406384,22.8783121397876  ,
1.54481225715704,3.02363319110238,4.67909192723099,6.4338881811143,8.28181785042927,10.2054683340553,12.1851235377667,14.2200226661188,16.3136386417191,18.4390727711128,20.6221120839444,22.8502432596351   ,
1.53680960426244,3.0180732937125,4.65840175693416,6.4200811986975,8.25903378004041,10.1995313033675,12.1596646352896,14.1886919122641,16.2866529606777,18.4275486924257,20.6044045916745,22.8050703389996    ,
1.53690081663485,3.0063123224137,4.65745025871334,6.42141638632472,8.24926103230307,10.1618416429705,12.1493805837938,14.179334966163,16.2635146414126,18.3938117914245,20.5659130281203,22.7669710644158    ,
1.52652614414965,3.01562164564077,4.65075924752901,6.40819407480106,8.24467969270038,10.1586818729171,12.11581469837,14.1627558577142,16.2383211294913,18.3543722152681,20.5319046820448,22.7583851467695    ,
1.53005546529256,3.003520771719,4.64774804532465,6.38501766168222,8.22868421082315,10.139147889571,12.1117141807635,14.1410298658364,16.2082457219602,18.3348430665338,20.5056641885972,22.7134559330483     ,
1.51775247571679,2.99469901883505,4.62938094874752,6.38861120029755,8.22446099900766,10.1223538141529,12.0957785862031,14.1217163203909,16.1948695443231,18.318662144271,20.4800475214403,22.6865562172579   ,
1.5214690547321, 2.99189218897191,4.64090697943055,6.38300017911339,8.21766908452585,10.1091387675936,12.0766842031976,14.0974505156624,16.1745975327182,18.2967805451665,20.4500696519764,22.6566831692461  ,
1.51500586996085,2.99544791970137,4.63351817332029,6.36465323199387,8.18718375080455,10.0987671776826,12.0534536340359,14.0807836012407,16.1535068336312,18.2733782467079,20.4303447255686,22.623310955978   ,
1.52021135322207,2.98772928441963,4.6200105916398,6.35560696006814,8.18741752247717,10.0788461591989,12.0404894805216,14.0654661591183,16.1257176708643,18.2399976030259,20.4006179484771,22.5951616798197   ,
1.50664829253116,2.9797651620869,4.61488676091354,6.35321095369038,8.17280550150101,10.0723810142145,12.0231415100613,14.0497481247995,16.1181327162982,18.2193252038638,20.3749856957367,22.5627820040365   ,
1.51263397232515,2.97859825824488,4.61592411759614,6.34425080052837,8.16702090805915,10.0603536653846,12.0236753193843,14.0360851531368,16.088570013247,18.2038350949404,20.3536767062906,22.5355293675002   ,
1.51665796241041,2.97434729916881,4.60738485597613,6.33056097672279,8.16186204720021,10.0561157435059,12.0098689327831,14.0109144318582,16.0867173301966,18.1756140971433,20.3255612931848,22.5135974282503  ,
1.50873305113964,2.97352575424494,4.59794254394518,6.33343757352278,8.13803020370968,10.0398952232492,11.9844535023778,14.0108727888862,16.0558746735529,18.1683283577657,20.2987757146911,22.4907760589034  ,
1.49943783536558,2.96712078996387,4.59051112255923,6.31254581661715,8.13408137162553,10.0234182956797,11.9789877387948,13.9748608447783,16.0416583392033,18.1412001511432,20.2802587090323,22.4675171895397  ,
1.49664542621439,2.97036463916535,4.58469054047937,6.31548082704305,8.13486564326356,10.002531704305,11.9736419354921,13.9691952339004,16.026008201737,18.12447407499,20.2620834128541,22.4509123487097      ,
1.49614111985165,2.95971051567879,4.58113887395473,6.30968737852095,8.11684260423237,10.0126348675176,11.9531004589534,13.9583380174715,16.0078993725049,18.1088209393126,20.2459942814719,22.4194473933972  ,
1.50777778037285,2.95262373566139,4.58265605312358,6.29584138766624,8.11179825439308,9.98909257454141,11.9426274135525,13.9400883513732,15.9998341873187,18.0751201873007,20.2242910839742,22.401286245667   ,
1.498044405267,  2.95368729910167,4.56802641734179,6.29449729182029,8.11812090805635,9.97811236739707,11.9325307149886,13.9228359548018,15.9756460388126,18.0705053064559,20.2000551862192,22.3885433336981  ,
1.49751718030608,2.9494710236221,4.56182521011545,6.28896416797515,8.10262429639311,9.97270399563302,11.9101503078705,13.9184761432581,15.9555716203183,18.0588999703758,20.1807991327731,22.3665053064365   ,
1.49703438848346,2.95341388584812,4.5651590599473,6.28510238792685,8.08750341017318,9.96372539209322,11.9065827215913,13.8954163175785,15.9420771696405,18.0372590828015,20.1612231352187,22.3435674698694   ,
1.48909632144802,2.93800826699446,4.56069901539,6.27839921283582,8.08989773199083,9.96013123714882,11.8873470087232,13.8857540946676,15.9289259915766,18.0228235673955,20.1499011411949,22.3248070974452     ,
1.49316260711601,2.9465271698648,4.56006714865324,6.27403374960351,8.07084147279532,9.95301390438152,11.8767706220913,13.8744991419991,15.9188624591277,17.9952928846569,20.1340147560783,22.305334623588    ,
1.48944112641499,2.94278330101409,4.55019132532566,6.25908280802932,8.06538561007344,9.93956947531911,11.870387390038,13.8667517110125,15.8993500458264,17.985249429036,20.1125829472581,22.2832151032126    ,
1.48319259294819,2.94014797795715,4.54604186283187,6.26930697612398,8.06480889377569,9.92753192356,11.8735373794841,13.8576718690001,15.8833814507027,17.9668881247658,20.0942365800643,22.2587696348103     ,
1.47998730098592,2.93769257832697,4.54828595180708,6.26443399285151,8.05425234687559,9.92511516328023,11.8537098279854,13.8451550696631,15.8750737568118,17.9642512353931,20.0760020973429,22.2473884675028  ,
1.49325631139506,2.92570157803421,4.53689597849761,6.25622150706661,8.04479249631527,9.90983540834343,11.845500317951,13.829618267176,15.8666162654877,17.9407709424579,20.0606612431999,22.2264170193048    ,
1.47745362875012,2.93172298810584,4.53280366159544,6.24731820668149,8.04827845882334,9.91430959047511,11.8368221168197,13.8194108526285,15.8535229762047,17.9266082227821,20.0470074059655,22.2091953840534  ,
1.4825944602128, 2.93239944034719,4.52834809573589,6.22914432623002,8.0380196218304,9.90004797720934,11.8256638709718,13.8091479451116,15.8404011180415,17.9162626923222,20.0218767987672,22.1910620434958   ,
1.48482264760029,2.93118984876756,4.53025837116627,6.23894699992448,8.03463461197978,9.89588694597461,11.819115973922,13.7884590828811,15.8307922817098,17.9055934754646,20.0265137802277,22.1795912028721   ,
1.48067824350844,2.92525758067891,4.53211697705997,6.23332222514116,8.01932116369141,9.88024802715491,11.8073637375609,13.7936313586168,15.8150776194562,17.8813570343473,20.0084739141271,22.1511261617319  ,
1.48007942021957,2.92131410933417,4.53086957112011,6.23493283299704,8.02146769196237,9.87456331230959,11.7998118702209,13.7752892273864,15.808217683496,17.8856842142161,19.9870555425167,22.1536271913437   ,
1.48530124590464,2.92602233957673,4.52284667019111,6.22399933608354,8.01993891362653,9.88082794572739,11.795700745903,13.7732335824456,15.8022921864959,17.8622170938664,19.9807393162384,22.1195952830339   ,
1.47806719705258,2.92231557359133,4.51893376754751,6.22554860659297,8.01009605032865,9.85997829787583,11.7933460530704,13.7509489895151,15.783517273921,17.8543486883473,19.9588374723716,22.1187951330245
), nrow=99,ncol=12, byrow=T) 
 
 
quant_99 <- matrix(data=c( 
2.73254281660568,5.13476030116154,7.49931866673696,9.91009152038134,12.456989681586,14.9536758278269,17.5672810544576,20.2048288661951,22.922923882398,25.6963383161909,28.4476557400916,31.2277013400068    ,
2.68592585373535,5.08897851069705,7.38356184420125,9.80442291501955,12.2542341363856,14.8239740263543,17.3924885908983,20.0522239084132,22.7227725831548,25.4422764281757,28.20764342873,30.9814764606442    ,
2.66222648549842,4.98981784349509,7.29433675604229,9.71411435818926,12.0781456763687,14.5769433868257,17.1996990262001,19.8400031742939,22.4453596852832,25.1903938173571,27.9221482268463,30.6512791302685  ,
2.63225155190944,4.92035846282521,7.20064757468525,9.5558260673684,11.9568788675344,14.403300126769,17.0625247530094,19.6020188690927,22.2741295007226,24.9406402795967,27.6394946368696,30.4169556835881    ,
2.60592293807422,4.86628498910445,7.12209148770769,9.43547691939968,11.8138966551496,14.2649286896036,16.8338014985099,19.3914186268698,22.0678150082856,24.7181228455795,27.3932399513921,30.16700314823    ,
2.5715283751747, 4.79685703165538,7.03809547822948,9.33443443219665,11.6569641875146,14.1209302976224,16.6415443530138,19.2212026184197,21.8713592379428,24.4925312887882,27.1899333425483,29.9167361090378  ,
2.53247813639599,4.77319418022712,6.94274874259541,9.21462919274325,11.5292114258047,14.013656947246,16.5211099115063,19.0652926118696,21.6054689618299,24.2775744597614,26.9420194180831,29.6385350400495   ,
2.50732669788275,4.65972033787554,6.87400397976813,9.12791922108728,11.427238636937,13.8623004307721,16.297137093841,18.9060086347409,21.419930318127,24.0450567571608,26.7035527671757,29.4050942452751     ,
2.4903979520653, 4.61532811025811,6.76807565763685,8.99711958579974,11.3103812477217,13.695290410889,16.1568734991337,18.6719472379825,21.214591523741,23.8847662600329,26.4996568210973,29.2187024666973    ,
2.43261208265365,4.5813038775614,6.72248990820304,8.87583903088131,11.1816169513787,13.5628149191866,16.0006064092844,18.4931932506919,21.0504104791051,23.6496989708414,26.2898526753022,28.9509919007678   ,
2.42731140535672,4.48495137867583,6.57564018593298,8.79545586897877,11.0743292776566,13.4813231356613,15.8792077591408,18.3544199026143,20.9003116943906,23.4467581015386,26.0547243140878,28.7455226767573  ,
2.39694825854118,4.44946976328113,6.50853595998996,8.68498631340897,10.9932833558396,13.2978034365639,15.7205404587273,18.2361774709865,20.7008731135607,23.2587611105415,25.8524663661321,28.5035112465085  ,
2.35326342395831,4.38571027089173,6.43189236201597,8.58260632193927,10.8378213037048,13.2114387546504,15.5799413126151,18.0338341558694,20.5500861958836,23.0827586059791,25.6731583135893,28.287422586534   ,
2.34904062174842,4.35089995024419,6.34997081006622,8.51894210908005,10.7436990296168,13.0609656920115,15.4425027150178,17.8942771359302,20.3568259855454,22.9295309539396,25.4623760789967,28.0698365056909  ,
2.2904786645862, 4.29965176642041,6.27976195815354,8.44299351096197,10.6914311061414,12.9536422759625,15.3031764174306,17.762157249206,20.2054495368431,22.7231652500695,25.3535118142865,27.93052744962     ,
2.26540073517062,4.24488486001475,6.21435846426826,8.32224217897465,10.5804021341268,12.8479060532689,15.1928542170148,17.6361371563946,20.065200067164,22.5875536834783,25.1490203015961,27.6716522327572   ,
2.27638657985204,4.18852888236653,6.15353017154405,8.25597981015329,10.5002120170887,12.7310440725699,15.0872201291287,17.5300022015435,19.9169063198236,22.3919734950572,24.9393994331527,27.4945871541712  ,
2.23994646620816,4.14073142936752,6.1081554679457,8.20658414962561,10.337382987802,12.634460576528,14.94406808852,17.3507346990224,19.7672460239035,22.2790607379016,24.8117818465115,27.3454144320143       ,
2.22022109031061,4.12502185761207,6.07278103592889,8.11220648266839,10.314714989947,12.5281697677229,14.8635058563189,17.2321954615921,19.6351291855674,22.098980743616,24.616385362452,27.1754793544762     ,
2.17800034668878,4.05331987618828,6.04221229973937,8.04691717592619,10.2505103689164,12.4678739527848,14.7623417739123,17.1075238636856,19.4770130407777,21.9781451802968,24.4872114734784,26.9716094313983  ,
2.16908013368646,3.99727029274217,5.96133297653193,7.96989290885283,10.1134747522435,12.3913744987221,14.6829265908796,16.9724081745055,19.3880305574108,21.7978277394167,24.2744787946627,26.8060476504313  ,
2.13419585201442,4.00966243812484,5.87997163750068,7.90906343174279,10.0374565563239,12.2607930157117,14.5175351143897,16.8814881556539,19.2178890117505,21.644959854145,24.1521245923166,26.6457156607318   ,
2.10439199086411,3.95381430007921,5.82091187216358,7.8736818382427,10.0148491498811,12.1622055623091,14.4575076827155,16.7356164241528,19.1359913578926,21.5443405418681,23.9843276250913,26.489198447733    ,
2.15123727461924,3.91733361810434,5.7900553956642,7.82599761868284,9.89582481104484,12.068300240735,14.3517988633342,16.6627238951789,19.0145149426446,21.3903156070436,23.8588638857417,26.3322377471354    ,
2.08847478217209,3.8576772736681,5.70925076195589,7.72955221534091,9.86872884869444,12.0018006350171,14.2745641828459,16.5635322170075,18.9177599896239,21.3285279346431,23.7581051394957,26.1847635103785   ,
2.07704929173952,3.8322467879485,5.70583572387691,7.70687260126366,9.77973538749357,11.9310670063952,14.1740209587814,16.4447269067485,18.7816348399606,21.1700781575448,23.6526242047947,26.0652514852463   ,
2.05503727461538,3.81794555203947,5.67003719645269,7.61418117437773,9.71954949222159,11.8684661704072,14.0839123359572,16.3682200346253,18.6682552378921,21.0340352387943,23.4717988447598,25.9580706392915  ,
2.02628701943238,3.79206074404898,5.60326460107442,7.59318735570833,9.62699764817238,11.7775266564947,14.0019678312441,16.2693203531376,18.6031353389427,20.9552214569847,23.3556813628574,25.7967566933896  ,
2.0086661169589, 3.75412876525544,5.60612554449988,7.54252901628499,9.58990875107399,11.7172491740382,13.9191052908497,16.2025811054793,18.4852287756548,20.8386973811995,23.2381965270516,25.6709695169591  ,
1.9925268282886, 3.73079978621687,5.52867041199826,7.4920153388087,9.51439575174065,11.6754004278776,13.8696691700674,16.0997074992133,18.3887530887588,20.7399633402768,23.1339921010664,25.5351093249217   ,
1.98216184519392,3.68486571286909,5.50617652853247,7.44083446115847,9.49268690857325,11.593758554787,13.7844089451722,16.0223861080566,18.3075055278586,20.6266547380543,23.014400467984,25.4561450729961    ,
1.9719321988901, 3.6731477518312,5.46191519074473,7.3509675704174,9.40091454869187,11.5138915014683,13.6877808181301,15.9523730837584,18.2252332487459,20.5288537709893,22.9165483706758,25.302596435384     ,
1.95479516469608,3.64599086310334,5.42619096936633,7.36997914421222,9.40824058960714,11.4644415745166,13.6508392068521,15.8458620253489,18.1318423497542,20.4411136393577,22.8019227474441,25.188986534405   ,
1.93157114752297,3.62499695688563,5.41150886332827,7.30988345585287,9.3517537092062,11.4169450015474,13.5572804985214,15.7646826807697,18.0251279904334,20.3463398529406,22.7027156731279,25.1098286016731   ,
1.92456658462616,3.60652530670185,5.3946539100183,7.28422584162572,9.31863972453345,11.353440537197,13.4839149801079,15.7511856317921,17.9568147442016,20.2806193435461,22.6249386285125,24.9928012049989    ,
1.89746571692496,3.53777352323272,5.33195825590254,7.24837955296007,9.24948225297161,11.2797098821752,13.43429125493,15.641463352354,17.8688040026342,20.1834551653185,22.5021863715354,24.8958463910639     ,
1.88028372222051,3.56432692316339,5.29679241971573,7.19012440748235,9.1803955853721,11.246590903891,13.3939365126712,15.5851642105163,17.8022529658742,20.0979619326366,22.4087043768195,24.7901977504812    ,
1.87309523854117,3.55323342217278,5.30223985783546,7.15147039450003,9.1516373853558,11.1878440510416,13.3495188324975,15.5063588966391,17.7386262966267,20.0298739457824,22.3456056173578,24.6931059717873   ,
1.86142933216489,3.50633898507789,5.24110065056368,7.16977157323241,9.13923414272566,11.1564553904833,13.2649521685745,15.459090204165,17.6549790925839,19.9685138217457,22.2586389454282,24.6201823151967   ,
1.85404781597924,3.47253363105003,5.21052272056832,7.09699736102403,9.06344908155656,11.1149414576144,13.2259184342557,15.3869858607367,17.5918617890536,19.8537728852359,22.191798993387,24.5367384469222   ,
1.85816962669696,3.46130228718809,5.20060688852315,7.07400776452842,9.02632178113369,11.0705838684363,13.1709127407529,15.3112281956601,17.5560341207619,19.7852476242765,22.1264265378725,24.457869009705   ,
1.8539148821534, 3.48372783601714,5.1885622430815,7.02677321516062,8.99713167079556,11.0147442407031,13.1030573118951,15.2796251535538,17.4879727465009,19.7502406952974,22.0129040598762,24.3649513920673   ,
1.81111887040928,3.43379677095658,5.17502988931624,7.00949379019912,8.96313236256369,10.9939659998931,13.1002278118797,15.2287449302952,17.4331638934532,19.6737704107337,21.9607607403609,24.2933183513254  ,
1.82071857257063,3.39815696629753,5.1307139413246,6.99995967985413,8.9022866576972,10.9402218840821,13.0184368803093,15.1766236735995,17.3407607628032,19.5946688039405,21.8685430554742,24.2116782398746    ,
1.81869643954177,3.39064522383906,5.12190529123966,6.97947884511535,8.90022278572587,10.8992064106261,12.9860643916648,15.0891712543864,17.3037270984335,19.5360473431409,21.8238043243186,24.1118412056366  ,
1.799843030659,  3.36882524412202,5.09074024635508,6.94283113633272,8.86862393914696,10.8701890514783,12.9446250876903,15.0746661854724,17.2717251478762,19.4834287249813,21.7455450204586,24.0518230586839  ,
1.78018208752191,3.35723028804147,5.07848871821194,6.91337890735257,8.86864677484899,10.8392603607488,12.9009799437585,15.0165654811309,17.1829837882274,19.4419862282773,21.7111304977347,24.0027558709831  ,
1.78274409924299,3.34973875911701,5.06804640691839,6.88598784180606,8.83732041344191,10.7892692380731,12.8829321510367,14.982353514904,17.1520386114882,19.3500542713173,21.6589246281335,23.9249424975049   ,
1.78535711790317,3.35505407367909,5.0682127087075,6.88067217215356,8.77045705461984,10.8006561425963,12.8044338755416,14.945973812558,17.1139971767769,19.315128012279,21.5767621363653,23.8590253560157     ,
1.77491617374818,3.32396251999315,5.02090985555804,6.8532251126321,8.75784345494863,10.7227092795221,12.8107314041996,14.9135887204309,17.0546593200182,19.2505037025574,21.5120769696841,23.8141389412382   ,
1.80330650827314,3.31399664152398,5.00808223141052,6.82151151630979,8.74094402879951,10.7212705716399,12.7414010998438,14.8574771964216,17.0136743324698,19.2111254227733,21.4451342379605,23.7469387317319  ,
1.76185311096957,3.31284111373782,5.00070246707748,6.8126954713113,8.70386556056691,10.6933807962052,12.7239463491452,14.8172460792286,16.9351345451036,19.1566530124119,21.3969902146464,23.6982053130049   ,
1.74721617742443,3.29488985495765,4.96762003424103,6.77511067539924,8.67496181005609,10.6480030628748,12.6981263935799,14.7751438391988,16.9166460943911,19.1063150107421,21.3310588826986,23.6045639905776  ,
1.75674540126891,3.30133701526723,4.96892879541168,6.75303020929982,8.65387626030096,10.6330090539104,12.6626044091477,14.7429451738438,16.8909780503579,19.0753740642438,21.2908212605471,23.5357884729258  ,
1.72167254877973,3.27755656958909,4.94705935001496,6.7577975193564,8.64898553054376,10.6100892771082,12.6103491135302,14.7073971646849,16.8265053403072,19.0138677448387,21.2524266471771,23.5081999796883   ,
1.71948334587301,3.25130513912488,4.94967669970409,6.73157888958193,8.61318771409645,10.5821729419077,12.5903629288362,14.6663385276783,16.7971800407881,18.9793064612015,21.1849891343497,23.4617040129285  ,
1.72657900894807,3.25163163599515,4.91867216279398,6.69926605593851,8.5834802391641,10.568534071194,12.5629941112817,14.6372305515716,16.7605650926908,18.9392549588677,21.1727714379805,23.4205594015477    ,
1.73026760770603,3.25231810484306,4.91582190848357,6.68751941475138,8.5591575470568,10.5244754883553,12.5200353943858,14.5976583742538,16.7238894762038,18.9009107034407,21.1224105428886,23.3566536432223   ,
1.71501424362283,3.24557216509803,4.90541478182921,6.68785128292047,8.57139251103833,10.4994216534803,12.5044307271821,14.5879282655939,16.7226919322237,18.8651973841565,21.0636199172225,23.3115213619581  ,
1.69775862145803,3.22194081591825,4.88810124962703,6.67797303432618,8.52905064127776,10.4693177005343,12.4894004718947,14.5723582896364,16.6671015474024,18.8187372052434,21.0507853386542,23.2809255131917  ,
1.67373203925096,3.22008926835764,4.86224005762551,6.6622349023241,8.51815007451713,10.4684501210809,12.4650835684593,14.5026158808028,16.6397269564518,18.7861514571409,20.979759845684,23.2168839824816    ,
1.70366209294743,3.19408390317874,4.87482374226626,6.61954850045388,8.49540430991207,10.4446827526767,12.4385860475741,14.4900040810683,16.5852250803422,18.7425153912817,20.9429017201867,23.203881492592   ,
1.69506049268928,3.21280679061377,4.8469499667103,6.62338561766286,8.47627340664983,10.4306826111052,12.4130675845381,14.4587263663558,16.5855114821153,18.7309585780548,20.906837840871,23.1608587275619    ,
1.69030692920008,3.17782053421061,4.84646328984395,6.60922233793756,8.47101373485695,10.3936515571987,12.3993654306817,14.4262710430555,16.5409139650144,18.6828408065744,20.8583065878406,23.1269814672132  ,
1.69966548631036,3.20561437016954,4.84003955003916,6.60979604014052,8.44443835773916,10.3646715542656,12.3769486737058,14.4018260762089,16.5159491982521,18.6428330205168,20.8256618810271,23.0619104179392  ,
1.67262721736265,3.20313936718469,4.81966137149658,6.59257581232186,8.4439736834283,10.3480773873745,12.3327195751528,14.3871038933411,16.4903119147772,18.6153935925898,20.7946328453617,23.0394267580394   ,
1.66666495548423,3.15763859318462,4.82004420068187,6.56944574182417,8.420904051912,10.344050471906,12.3149129603313,14.3532815688342,16.4626548876738,18.5790013211284,20.7826909678841,23.0240070056462     ,
1.66138631605527,3.15721016998965,4.80731303853486,6.55498019681199,8.41148872100682,10.3436884014576,12.2945371963048,14.3472897821214,16.4318838577221,18.5689284531183,20.7584619644115,22.9267011490242  ,
1.6673415128942, 3.17548954662137,4.81375373925188,6.55784190190637,8.37728309660636,10.3076875359508,12.2702919351413,14.3356437564808,16.4084376282162,18.5192282065833,20.7059511643828,22.9159423913133  ,
1.6337071140353, 3.15679831163827,4.78634192278623,6.53901951346549,8.39055382732493,10.3061730126176,12.2503613106245,14.3048469819191,16.3668022364457,18.503403432553,20.690385826712,22.8974361818183    ,
1.63859078490889,3.1376329637452,4.79405224012041,6.51341794583545,8.36428228149836,10.2885805504756,12.2438363310791,14.275295667862,16.3410599972006,18.467345016651,20.643614520319,22.8669468767353      ,
1.64538286837004,3.15812090713865,4.77118543576134,6.53427591033326,8.35824939425256,10.2532318786704,12.2233984011117,14.2679585619544,16.3285602906256,18.4541778126803,20.6239126377436,22.8268261813891  ,
1.63760008516917,3.15369080354192,4.77069374506931,6.52702977564476,8.34419257050943,10.2214367813106,12.2208569289201,14.2266203350948,16.3032037974628,18.4198143859731,20.5811318416107,22.8134934292505  ,
1.64384559794075,3.12617370029156,4.77271118249615,6.50900288015341,8.30968631623482,10.2199528082852,12.1880484580522,14.2024617975409,16.2681024638466,18.4181970667682,20.5809853634407,22.7442809744842  ,
1.64651609118102,3.12361667840796,4.75484081330367,6.49231561525586,8.32234316809118,10.209066725251,12.1728325926768,14.204950879718,16.2517697739094,18.3631006804787,20.5356997485877,22.744976009226     ,
1.62594692168211,3.12325385377261,4.75782918035927,6.50215971793568,8.30184026163143,10.1969934777414,12.1466947017411,14.1770458544162,16.2539625109917,18.358882037176,20.5169730197062,22.6985895461828   ,
1.63503836717766,3.11219818904069,4.74625384098754,6.46249005601705,8.29330957408809,10.1950746973803,12.1556592750288,14.1747763474818,16.2217702971121,18.3338218106306,20.5023176756427,22.6658780497576  ,
1.62270393554269,3.12162984973753,4.74750981005288,6.45271729315493,8.2923520460206,10.1903992648286,12.1370680986371,14.1394378992655,16.2200052542928,18.3209243468003,20.4603379857633,22.6467371933887   ,
1.6259320766611, 3.101593516706,4.73386546426822,6.45298809606216,8.26398370297952,10.1661111682765,12.10038371359,14.1436223884339,16.1871370780474,18.2978232566374,20.4257723405948,22.6153489234971      ,
1.62733222087525,3.11146557869427,4.73336197756392,6.44482987424001,8.26244570894975,10.1455822942431,12.1087185542956,14.0884503569055,16.1555071670783,18.2807428371288,20.4119638818269,22.6024932744333  ,
1.62282657007349,3.09771454667557,4.71015712340003,6.45457531832538,8.28326767715395,10.1264816431937,12.1047362241877,14.1152879368341,16.1563749920729,18.2498946999715,20.4044072312447,22.5729643701661  ,
1.61660360522194,3.07788090539035,4.70196569937457,6.42664546594226,8.23819175825091,10.1363044597019,12.0820903698717,14.0859477183993,16.1317683298055,18.2438409242962,20.3813423372483,22.5402784916066  ,
1.6179525376428, 3.09642525356752,4.71508726032421,6.4331737021682,8.23018257829987,10.1098399934858,12.0656063439615,14.071580973462,16.1167182529549,18.2117305142708,20.3409468511952,22.5352849284263    ,
1.61125597868419,3.07396492023595,4.6697573158274,6.41342951701137,8.241327018678,10.1093984412491,12.0542556427279,14.0445898786334,16.085406411591,18.2049300984159,20.3375106645043,22.508723687889       ,
1.61636519353539,3.08220846951472,4.68940399255377,6.40016528246572,8.23619124080657,10.0860545666969,12.039403139784,14.0444811616149,16.0831201496114,18.1788657932479,20.3150027473256,22.4864658716568   ,
1.61125980513081,3.08604653588829,4.68631803921892,6.42154460798027,8.21300279686199,10.08939519854,12.0284120036195,14.0034168302662,16.068196843029,18.1583032486143,20.2831917529887,22.4639043522004     ,
1.60957304147867,3.07211702456778,4.68233906983334,6.39699810327529,8.2146603015181,10.0809179353897,12.0280408177,14.0132000850957,16.0438347911837,18.1478737846817,20.2652091927803,22.4550401807997      ,
1.61036180670619,3.0922604938473,4.68516528519537,6.40643219806577,8.19175607342648,10.0791751463615,11.998402996731,13.9838003355271,16.0330578902434,18.1293930078266,20.2580494878333,22.4371229625182    ,
1.59809795061701,3.07493570769769,4.68139888154444,6.37526467645456,8.18876772509643,10.0695588662276,11.9931302219503,13.9924060822975,16.0170165749415,18.1031269491852,20.2395783322465,22.3967509214312  ,
1.58848518109258,3.07380426033955,4.6807251541517,6.40035532170879,8.18683689318256,10.0487682199975,11.9889375143627,13.9804573858783,16.00111413282,18.0843954688347,20.2145927492485,22.3693327643341     ,
1.59925081133451,3.05894373947816,4.66517908123315,6.38340710206911,8.17723426642195,10.0410863528162,11.97857802896,13.9631615280533,15.9999067156584,18.0833684467725,20.1916818725891,22.3767483291811    ,
1.61292131392229,3.03661666943372,4.66755759797323,6.40549680025699,8.1617543493563,10.0342490776351,11.9688559477979,13.9566040947596,15.9757439126434,18.0642413822391,20.1955439264845,22.3446793837912   ,
1.58700201654997,3.06554408310197,4.65072315859345,6.36709821062253,8.16053959350128,10.0370027410512,11.967680177064,13.9404503779019,15.9691235013427,18.0492942337333,20.1682157864464,22.332797365082    ,
1.59269069554607,3.06613825987732,4.64184271702491,6.35715538904646,8.16331928330495,10.0194796400244,11.9406359993924,13.9253930191185,15.9703133178442,18.0318161211582,20.1459952803716,22.30112239234    ,
1.59795267998389,3.05549330010622,4.64524828446365,6.35835987117969,8.1533736497201,10.0169132888923,11.9392842521902,13.9153222045529,15.9515215571327,18.0208993198397,20.1332537953644,22.2865399240748   ,
1.59532442142485,3.05531747795504,4.66909288560116,6.35337294984955,8.14901450262247,10.0084543972154,11.9365363989195,13.8973428888606,15.9329726946451,17.9759215820287,20.1262038436415,22.2648342461247  ,
1.59114724004054,3.0495299275134,4.66042830826124,6.35503586873375,8.14084074379405,10.0112925057757,11.9112951574721,13.8859265732204,15.9299578815585,18.0073723711875,20.0954214712621,22.2559344251098   ,
1.58782348482579,3.04917900869936,4.64150614503618,6.34493069566788,8.13197059185021,9.9879751037988,11.8981614344685,13.887954238662,15.9107346159707,17.9529426435945,20.1164443564669,22.258955742694     ,
1.58082315098184,3.05795007697628,4.63503462909995,6.34068551358002,8.13300092705705,9.9655784544095,11.9056530819465,13.8836066257754,15.8839710842466,17.9639393237354,20.0653406198129,22.2308299639368
), nrow=99,ncol=12, byrow=T) 
 

rownames(quant_90)<-rownames(quant_95)<-rownames(quant_99)<-c("0.51","0.52","0.53","0.54","0.55","0.56","0.57","0.58","0.59","0.6","0.61","0.62","0.63","0.64","0.65","0.66","0.67","0.68","0.69","0.7","0.71","0.72","0.73","0.74","0.75","0.76","0.77","0.78","0.79","0.8","0.81","0.82","0.83","0.84","0.85","0.86","0.87","0.88","0.89","0.9","0.91","0.92","0.93","0.94","0.95","0.96","0.97","0.98","0.99","1","1.01","1.02","1.03","1.04","1.05","1.06","1.07","1.08","1.09","1.1","1.11","1.12","1.13","1.14","1.15","1.16","1.17","1.18","1.19","1.2","1.21","1.22","1.23","1.24","1.25","1.26","1.27","1.28","1.29","1.3","1.31","1.32","1.33","1.34","1.35","1.36","1.37","1.38","1.39","1.4","1.41","1.42","1.43","1.44","1.45","1.46","1.47","1.48","1.49")
colnames(quant_90)<- colnames(quant_95)<-colnames(quant_99)<- c("1", "2", "3", "4", "5","6", "7", "8","9", "10", "11", "12")

if(alpha==0.1){quant<-quant_90}
if(alpha==0.05){quant<-quant_95}
if(alpha==0.01){quant<-quant_99}                                        
return(quant[((d-0.5)*100),nbr])                           
}                                                                
 
#' Helper for memory estimation.
#' @keywords internal
elW_wrap<-function(X,m,mean_correct){ELW(X,m,mean_correct)$d}

                                                                

#' @title Nonparametric test for fractional cointegration (Nielsen (2010))
#' @description \code{FCI_CH06} Nonparametric test and rank estimation for fractional cointegration by Nielson (2010).
#'  Returns either test statistic, critical value and testing decision (null hypothesis: no fractional cointegration) or the estimated cointegrating rank.
# #' @details add details here.
#' @param X data matrix.
#' @param d1 fixed order of integration, default is \code{d1=0.1} as recommended by Nielsen (2010), no critical values for other choices available.
#' @param m bandwith parameter specifying the number of Fourier frequencies
#' used for the memory estimation required for the asymptotic distribution, usually \code{floor(1+T^delta)}, where 0<delta<1.
#' @param mean_correct specifies the form of mean correction in the memory estimation.
#' @param type string that determines whether the test or the rank estimation procedure is applied.
#' @param alpha desired significance level. Default is \code{alpha=0.05}.
#' @references Nielsen, M. O. (2010): Nonparametric cointegration analysis of fractional systems with unknown integration orders.
#' Journal of Econometrics, Vol. 155, No. 2, pp. 170 - 187.
#' @author Christian Leschinski, Michelle Voges
#' @examples
#' T<-1000
#' series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.1,0.9), B=rbind(c(1,-1),c(0,1)))
#' FCI_N10(series, m=floor(T^0.75), type="test")
#' series<-FI.sim(T=T, q=2, rho=0.4, d=c(0.9,0.9))
#' FCI_N10(series, m=floor(T^0.75), type="test")
#' series<-FI.sim(T=T, q=3, rho=0.4, d=c(0.2,0.2,1), B=rbind(c(1,-0.5,-0.3),c(0,1,-0.4),c(0,0,1)))
#' FCI_N10(series,m=floor(T^0.75),type="rank")
#' @export

FCI_N10<-function(X, d1=0.1, m, mean_correct=c("mean", "init", "weighted", "none"), type=c("test","rank"), alpha=0.05){
  if(d1!= 0.1 ){stop("no critical values available for choice of d_1")}
  if(which.max(dim(X))!=1){X<-t(X)}
  T<-nrow(X)
  dim_series<-ncol(X)
  if(dim_series>12){stop("no critical values for data of this dimension")}
  ### calculate d_hat for critical values
  d_hat<- round(mean(apply(X,2,elW_wrap, mean_correct, m=m)),2) # memory of data (equal by assumption)
  if(d_hat<0.51||d_hat>1.49){warning("no critical values available for these memory parameters")}
  if(d_hat<0.51){d_hat<-0.51}
  if(d_hat>1.49){d_hat<-1.49}
  
  ### calculate eigenvalues
  tildeX<-apply(X,2,fdiff, d=-d1)
  At<-t(X)[,T:1]%*%X[T:1,]
  Bt<-t(tildeX)[,T:1]%*%tildeX[T:1,]
  Rt <- At%*%solve(Bt)
  eigenvalues <- rev(eigen(Rt)$values) # eigenvalues sorted in ascending order (important for multivariate)
  ### testing decision
  if(type=="test")
  {
  stats<-T^(2*d1)*sum(eigenvalues)
  crit<-crit_N10(d=d_hat, nbr=dim_series, alpha)

  dec <- stats>crit
  erg <- list("Ts"=stats, "crit"=crit, "reject"=dec)
  }
  if(type=="rank")
  {
  r<-c(0:(dim_series-1))
  erg_2 <- crit<- 0
  stats<-1
  while(stats>crit){
  for(i in 1:(dim_series-1)){
                              stats<-T^(2*d1)*sum(eigenvalues[1:(dim_series-r[i])])
                              crit<-crit_N10(d=d_hat, nbr=(dim_series-r[i]), alpha)
                              if(stats>crit){erg<-1}else{erg<-0}
                              erg_2 <- erg_2+erg  
                              } 
                crit<-1
                stats<-0}
  erg <- list("rank"=erg_2)
  }  
  return(erg)
}
