# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

construct_ADchol_Rcpp <- function(U, P_list) {
    .Call(`_LMMsolver_construct_ADchol_Rcpp`, U, P_list)
}

logdet <- function(arg, lambda) {
    .Call(`_LMMsolver_logdet`, arg, lambda)
}

#' Calculate the partial derivatives of log-determinant.
#'
#' This function calculates the partial derivatives of the the log-determinant in an
#' efficient way, by using reverse Automated Differentiation of the Cholesky Algorithm,
#' see Smith (1995) for details. Let
#'  \deqn{C = \sum_{i} \theta_i P_i}
#' where the matrices \eqn{P_i} are stored in the `ADchol` object. The partial derivatives
#' of matrix \eqn{C} are defined by:
#' \deqn{\frac{\partial C}{\partial \theta_i} = \text{trace} [C^{-1} P_i]},
#' but are calculated in a more efficient way using backwards Automated Differentiation.
#'
#' @param ADobj object of class ADchol.
#' @param theta a vector with precision or penalty parameters
#'
#' @return The gradient with partial derivatives of \eqn{log|C|} with respect to
#' parameters \eqn{\theta_i}. As attribute \code{logdet}, \eqn{log|C|} is returned.
#'
#' @references
#' Smith, S. P. (1995). Differentiation of the Cholesky algorithm.
#' Journal of Computational and Graphical Statistics, 4(2), 134-147.
#'
#' @noRd
#' @keywords internal
#'
dlogdet <- function(ADobj, theta, b_ = NULL) {
    .Call(`_LMMsolver_dlogdet`, ADobj, theta, b_)
}

partialDerivCholesky <- function(cholC) {
    .Call(`_LMMsolver_partialDerivCholesky`, cholC)
}

diagXCinvXt <- function(cholC, transposeX) {
    .Call(`_LMMsolver_diagXCinvXt`, cholC, transposeX)
}

ForwardCholesky <- function(cholC, b) {
    .Call(`_LMMsolver_ForwardCholesky`, cholC, b)
}

BackwardCholesky <- function(cholC, b) {
    .Call(`_LMMsolver_BackwardCholesky`, cholC, b)
}

RowKron <- function(sX1, sX2) {
    .Call(`_LMMsolver_RowKron`, sX1, sX2)
}

