% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_crit.R
\name{normal_crit}
\alias{normal_crit}
\alias{normal_crit.ICS}
\alias{normal_crit.default}
\title{Selection of Non-normal Invariant Components Using Marginal
Normality Tests}
\usage{
normal_crit(object, ...)

\method{normal_crit}{ICS}(
  object,
  level = 0.05,
  test = c("agostino.test", "jarque.test", "anscombe.test", "bonett.test",
    "shapiro.test"),
  max_select = NULL,
  select_only = FALSE,
  ...
)

\method{normal_crit}{default}(
  object,
  level = 0.05,
  test = c("agostino.test", "jarque.test", "anscombe.test", "bonett.test",
    "shapiro.test"),
  max_select = NULL,
  select_only = FALSE,
  gen_kurtosis = NULL,
  ...
)
}
\arguments{
\item{object}{object of class \code{"ICS"} or a data frame or matrix.}

\item{\dots}{additional arguments are currently ignored.}

\item{level}{the initial level used to make a decision based on the test
p-values. See details. Default is 0.05.}

\item{test}{name of the normality test to be used. Possibilities are
\code{"jarque.test"}, \code{"anscombe.test"}, \code{"bonett.test"}, \code{"agostino.test"},
\code{"shapiro.test"}.
Default is \code{"agostino.test"}.}

\item{max_select}{the maximal number of components to select.}

\item{select_only}{boolean. If \code{TRUE} only the vector names of the selected
invariant components is returned. If \code{FALSE} additional details are returned.}

\item{gen_kurtosis}{vector of generalized kurtosis values.}
}
\value{
If \code{select_only} is  \code{TRUE} a vector of the names of the invariant
components or variables to select. If \code{FALSE} an object of class \code{"ICS_crit"}
is returned with the following objects:
\itemize{
\item \code{crit}: the name of the criterion "normal".
\item \code{level}: the level of the test.
\item \code{max_select}: the maximal number of components to select.
\item \code{test}: name of the normality test to be used.
\item \code{pvalues}: the p-values of the tests.
\item \code{adjusted_levels}: the adjusted levels.
\item \code{select}: the names of the invariant components or variables to select.
\item \code{gen_kurtosis}: the vector of generalized kurtosis values in case of
\code{ICS} object.
}
}
\description{
Identifies invariant coordinates that are non normal using univariate
normality tests as in the \code{comp.norm.test} function from the
\code{ICSOutlier} package, with the difference that both the
first and last few components are investigated.
}
\details{
The procedure sequentially tests the first and the last components until
finding no additional components as non-normal. The quantile levels are
adjusted for multiple testing by taking the level as \code{level}/\emph{j} for the
\emph{j}th component.
}
\examples{
X <- iris[,-5]
out <- ICS(X)
normal_crit(out, level = 0.1, select_only = FALSE)

}
\references{
Alfons, A., Archimbaud, A., Nordhausen, K., & Ruiz-Gazen, A. (2022).
Tandem clustering with invariant coordinate selection.
\emph{arXiv preprint arXiv:2212.06108}..

Archimbaud, A., Nordhausen, K., and Ruiz-Gazen, A. (2018).
ICSOutlier: Unsupervised Outlier Detection for Low-Dimensional Contamination Structure,
The RJournal, Vol. 10(1):234–250. \doi{10.32614/RJ-2018-034}

Archimbaud, A., Nordhausen, K., and Ruiz-Gazen, A. (2016).
ICSOutlier: Outlier Detection Using Invariant Coordinate Selection.
R package version 0.3-0
}
\seealso{
\code{\link[=med_crit]{med_crit()}}, \code{\link[=var_crit]{var_crit()}}, \code{\link[=discriminatory_crit]{discriminatory_crit()}},
\code{\link[=jarque.test]{jarque.test()}}, \code{\link[=anscombe.test]{anscombe.test()}},
\code{\link[=bonett.test]{bonett.test()}}, \code{\link[=agostino.test]{agostino.test()}}, \code{\link[stats:shapiro.test]{stats::shapiro.test()}}.
}
\author{
Andreas Alfons, Aurore Archimbaud, Klaus Nordhausen and Anne Ruiz-Gazen
}
