% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.cis.R
\name{glm.cis}
\alias{glm.cis}
\title{Compute confidence intervals for predictions.}
\usage{
glm.cis(preds, ses, alpha, df)
}
\arguments{
\item{preds}{The predictions based on the additive linear component of the model.}

\item{ses}{The standard error(s) of the prediction.}

\item{alpha}{The desired confidence level.}

\item{df}{The desired degrees of freedom.}
}
\value{
The output is a matrix.
}
\description{
Apply an exponential transformation to the confidence intervals and predictions from binomial and Poisson models.
}
\examples{
data(campaign)
attach(campaign)
cmpgn.out <- glm(TOTCONTR ~ CANDGENDER + PARTY + INCUMCHALL + HISPPCT,
                 family=Gamma(link = 'log'), data=campaign)
newdat_gender <- data.frame(CANDGENDER = c('F','M'), PARTY= rep('Democrat',2),
                            INCUMCHALL=rep("C", 2), HISPPCT=rep(mean(campaign$HISPPCT),2))
preds_gender <- predict(cmpgn.out, newdata = newdat_gender, se.fit = TRUE)
glm.cis(preds_gender$fit, preds_gender$se.fit, 0.95,cmpgn.out$df.residual)

}
