% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distances_17102018.R
\name{DSGD}
\alias{DSGD}
\title{Calculates a distance by the SGD between fuzzy numbers}
\usage{
DSGD(X, Y, i = 1, j = 1, breakpoints = 100, theta = 1/3)
}
\arguments{
\item{X}{a fuzzy number.}

\item{Y}{a fuzzy number.}

\item{i}{parameter of the density function of the Beta distribution, fixed by default to i = 1.}

\item{j}{parameter of the density function of the Beta distribution, fixed by default to j = 1.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{theta}{a numerical value between 0 and 1, representing a weighting parameter. By default, theta is fixed to 1/3 referring to the Lebesgue space. This measure is used in the calculations of the following distances: d_Bertoluzza, d_mid/spr and d_phi-wabl/ldev/rdev.}
}
\value{
A numerical value.
}
\description{
Calculates a distance by the SGD between fuzzy numbers
}
