% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-distance.R
\docType{methods}
\name{distance}
\alias{distance}
\alias{distance,FuzzyNumber,FuzzyNumber-method}
\alias{distance,DiscontinuousFuzzyNumber,FuzzyNumber-method}
\alias{distance,FuzzyNumber,DiscontinuousFuzzyNumber-method}
\alias{distance,DiscontinuousFuzzyNumber,DiscontinuousFuzzyNumber-method}
\title{Calculate the Distance Between Two Fuzzy Numbers}
\usage{
\S4method{distance}{FuzzyNumber,FuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)

\S4method{distance}{FuzzyNumber,DiscontinuousFuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)

\S4method{distance}{DiscontinuousFuzzyNumber,FuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)

\S4method{distance}{DiscontinuousFuzzyNumber,DiscontinuousFuzzyNumber}(e1, e2, type=c("Euclidean", "EuclideanSquared"), ...)
}
\arguments{
\item{e1}{a fuzzy number}

\item{e2}{a fuzzy number}

\item{...}{additional arguments passed to \code{\link{integrate}}}

\item{type}{one of \code{"Euclidean"}, \code{"EuclideanSquared"}}
}
\value{
Returns the calculated distance, i.e. a single numeric value.
}
\description{
Currently, only Euclidean distance may be calculated.
We have \eqn{d_E^2(A,B) := \int_0^1  (A_L(\alpha)-B_L(\alpha))^2\,d\alpha,\int_0^1 + (A_U(\alpha)-B_U(\alpha))^2\,d\alpha
}{d_E^2(A,B) := int_0^1  (A_L(\alpha)-B_L(\alpha))^2 d\alpha + int_0^1  (A_U(\alpha)-B_U(\alpha))^2 d\alpha},
see (Grzegorzewski, 1988).
}
\details{
The calculation are done using numerical integration,
}
\references{
Grzegorzewski P., Metrics and orders in space of fuzzy numbers,
Fuzzy Sets and Systems 97, 1998, pp. 83-94.
}
\seealso{
Other FuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{FuzzyNumber-class}},
\code{\link{FuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{alphacut}()},
\code{\link{ambiguity}()},
\code{\link{as.FuzzyNumber}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{core}()},
\code{\link{evaluate}()},
\code{\link{expectedInterval}()},
\code{\link{expectedValue}()},
\code{\link{integrateAlpha}()},
\code{\link{piecewiseLinearApproximation}()},
\code{\link{plot}()},
\code{\link{show}()},
\code{\link{supp}()},
\code{\link{trapezoidalApproximation}()},
\code{\link{value}()},
\code{\link{weightedExpectedValue}()},
\code{\link{width}()}

Other DiscontinuousFuzzyNumber-method: 
\code{\link{DiscontinuousFuzzyNumber-class}},
\code{\link{DiscontinuousFuzzyNumber}},
\code{\link{Extract}},
\code{\link{integrateAlpha}()},
\code{\link{plot}()}
}
\concept{DiscontinuousFuzzyNumber-method}
\concept{FuzzyNumber-method}
