% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Abstract.R
\name{Abstract}
\alias{Abstract}
\alias{print.abstract}
\title{Display Compact Abstract of a Data Frame}
\usage{
Abstract(
  x,
  sep = ", ",
  zero.form = ".",
  maxlevels = 5,
  trunc = TRUE,
  list.len = 999
)

\method{print}{abstract}(x, sep = NULL, width = NULL, trunc = NULL, print.gap = 2, ...)
}
\arguments{
\item{x}{a \code{data.frame} to be described}

\item{sep}{the separator for concatenating the levels of a factor}

\item{zero.form}{a symbol to be used, when a variable has zero NAs.}

\item{maxlevels}{(integer, \code{Inf}) Max. number of factor levels to display.
Default is 5. Set this to \code{Inf}, if all levels are needed.}

\item{trunc}{logical, defining if level names exceeding the column with
should be truncated. Default is \code{TRUE}.}

\item{list.len}{numeric; maximum number of list elements to display.}

\item{width}{Console width. If \code{NULL}, defaults to
\link[base:options]{options("width")}.}

\item{print.gap}{(integer) Number of spaces between columns.}

\item{...}{Further arguments to \code{print} method.}
}
\value{
an object of class \code{abstract}, essentially a character matrix
with 5 or 6 columns containing:
\enumerate{
\item a column number (\code{Nr}),
\item the name of the column (\code{ColName}),
\item the column class (\code{Class}),
\item the number of NAs (\code{NAs}),
\item the levels if the variable is a factor (\code{Levels}),
\item (if there are any) descriptive labels for the column (\code{Labels}).
}
}
\description{
Compactly display the content and structure of a \code{data.frame}, including
variable labels. \code{str()} is optimized for lists and its output is
relatively technical, when it comes to e.g. attributes. \code{summary()} on
the other side already calculates some basic statistics.
}
\details{
The levels of a factor and describing variable labels (as created by
\code{\link[=Label]{Label()}}) will be wrapped within the columns.

The first 4 columns are printed with the needed fix width, the last 2
(Levels and Labels) are wrapped within the column. The width is calculated
depending on the width of the screen as given by \code{getOption("width")}.

\code{ToWord} has an interface for the class \code{abstract}.
}
\examples{

d.mydata <- d.pizza
# let's use some labels
Label(d.mydata) <- "Lorem ipsum dolor sit amet, consetetur sadipscing elitr,
sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat,
sed diam voluptua. At vero eos et accusam."

Label(d.mydata$temperature) <- "Amet, consetetur sadipscing elitr, sed diam nonumy "

Abstract(d.mydata)

}
\seealso{
\code{\link[utils:str]{utils::str()}}, \code{\link[base:summary]{base::summary()}}, \code{\link[=ColumnWrap]{ColumnWrap()}}, \code{\link[=Desc]{Desc()}}

Other Statistical summary functions: 
\code{\link{Desc}()}
}
\author{
Andri Signorell \href{mailto:andri@signorell.net}{andri@signorell.net}
}
\concept{Desc}
\concept{Statistical summary functions}
\keyword{print}
