% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colMedians.R, R/rowMedians.R
\name{colMedians,DelayedMatrix-method}
\alias{colMedians,DelayedMatrix-method}
\alias{rowMedians,DelayedMatrix-method}
\title{Calculates the median for each row (column) of a matrix-like object}
\usage{
\S4method{colMedians}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowMedians}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the median for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowMedians}} /
\code{matrixStats::\link[matrixStats]{colMedians}}.
}
\examples{
# A DelayedMatrix with a 'Matrix' seed
dm_Matrix <- DelayedArray(Matrix::Matrix(c(rep(1L, 5),
                                           as.integer((0:4) ^ 2),
                                           seq(-5L, -1L, 1L)),
                                         ncol = 3))

colMedians(dm_Matrix)

rowMedians(dm_Matrix)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowMedians}()} and
\code{matrixStats::\link[matrixStats:rowMedians]{colMedians}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link[MatrixGenerics]{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
}
}
\author{
Peter Hickey
}
