; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN f_error (F)
  (FORMAT T "error: partial function ~A;" F)
  (IF (AND (COMPILED-FUNCTION-P (SYMBOL-FUNCTION F))
           (Y-OR-N-P "track ~A ? " F))
      (track_function (source_code F)))
  (ERROR ""))

(DEFUN track (V1)
 (LET ((Source (source_code V1)))
  (IF (NULL Source) 
      (error "~A is not defined in Qi~%" V1)
      (track_function Source))))

(DEFUN track_function (V3)
 (COND
  ((AND (CONSP V3) (CONSP (CDR V3)) (CONSP (CDR (CDR V3)))
    (CONSP (CDR (CDR (CDR V3)))) (NULL (CDR (CDR (CDR (CDR V3))))))
   (LET* ((V4 (CDR V3)) (V5 (CAR V4)) (V6 (CDR V4)) (V7 (CAR V6)))
    (EVAL (LIST (CAR V3) V5 V7 (insert_tracking_code V5 V7 (CAR (CDR V6)))))))
  (T (implementation_error 'track_function))))

(DEFUN insert_tracking_code (V8 V9 V10)
 (LIST 'PROGN (LIST 'INCF '*call*)
  (LIST 'input_track '*call* (LIST 'QUOTE V8) (CONS 'LIST V9))
  (LIST 'terpri_or_read_char)
  (LIST 'LET (LIST (LIST 'RESULT V10))
   (LIST 'output_track '*call* (LIST 'QUOTE V8) 'RESULT) (LIST 'DECF '*call*)
   (LIST 'terpri_or_read_char) 'RESULT)))

(DEFUN step (V15)
 (COND ((EQ '+ V15) (SETQ *step* 'true)) 
       ((EQ '- V15) (SETQ *step* 'false))
       (T (ERROR "step expects a + or a -.~%"))))

(SETQ *step* 'false)

(DEFUN terpri_or_read_char () 
  (if *step* (check_char (READ-CHAR)) (TERPRI)))

(DEFUN check_char (V20) (COND ((EQL #\^ V20) (abort)) (T 'true)))

(DEFUN input_track (V21 V22 V23)
 (output "~%~A<~A> Inputs to ~A ~%~A ~{~S, ~} ==>" (spaces V21) V21 V22
  (spaces V21) V23))

(DEFUN spaces (V24)
 (COND ((EQL 0 V24) "") (T (FORMAT NIL "  ~A" (spaces (1- V24))))))

(DEFUN output_track (V25 V26 V27)
 (output "~%~A<~A> Output from ~A ~%~A==> ~S" (spaces V25) V25 V26 (spaces V25)
  V27))

(DEFUN untrack (V28) (COMPILE (EVAL (source_code V28))))

(DEFUN spy (V15)
  (COND ((EQ '+ V15) (SETQ *spy* 'true)) 
       ((EQ '- V15) (SETQ *spy* 'false))
       (T (ERROR "spy expects a + or a -.~%"))))

(DEFUN profile (Func) (profile-help (source_code Func)))

(DEFUN profile-help (V573)
 (COND
  ((AND (CONSP V573) (CONSP (CDR V573)) (CONSP (CDR (CDR V573))))
   (LET ((PrfFunc (gensym "Profile")))
     (EVAL
      (CONS (CAR V573)
       (CONS (CAR (CDR V573))
        (CONS (CAR (CDR (CDR V573)))
         (CONS
          (CONS 'profile_func
           (CONS (CAR (CDR V573))
            (CONS (CONS PrfFunc (CAR (CDR (CDR V573)))) NIL)))
          NIL)))))
     (EVAL
      (CONS (CAR V573)
       (CONS PrfFunc
        (CONS (CAR (CDR (CDR V573)))
         (SUBST PrfFunc (CAR (CDR V573)) (CDR (CDR (CDR V573))) ':TEST
          'EQUAL)))))
     (COMPILE (CAR (CDR V573))) (COMPILE PrfFunc) (CAR (CDR V573))))
  (T (error "Cannot profile.~%"))))

(DEFUN unprofile (Func) (untrack Func))

(DEFMACRO profile_func (F EXPR)
   `(PROGN 
     (LET* ((START (GET-INTERNAL-RUN-TIME))
               (RESULT ,EXPR)
               (FINISH (- (GET-INTERNAL-RUN-TIME) START)))
           (put-prop 'profile-stats (QUOTE ,F) (+ (get-prop 'profile-stats (QUOTE ,F) 0) FINISH))
           RESULT)))

(DEFUN profile-results (X) 
  (FORMAT T "~{~A, ~A secs~%~}~%" (calibrate-profile (SYMBOL-PLIST 'profile-stats)))
  (SETF (SYMBOL-PLIST 'profile-stats) NIL)
  'profiled)

(DEFUN calibrate-profile (P)
   (IF (NULL P)
       NIL
       (IF (AND (CONSP P) (CONSP (CDR P)))
           (CONS (CAR P) (CONS (calibrate (CADR P)) (calibrate-profile (CDDR P))))
           (implementation_error 'calibrate-profile)))) 
   
(DEFUN calibrate (Time) (* 1.0 (/ Time INTERNAL-TIME-UNITS-PER-SECOND)))

(DEFMACRO harness (&REST Tests)
   `(MAPC 'run-test (MAPCAR 'harness-test (QUOTE ,Tests))))

(DEFUN harness-test (Test) (CONS Test (freeze Test)))

(DEFUN run-test (X) 
  (FORMAT T "~S " (CAR X)) 
  (output "= ~S~%" (eval (thaw (CDR X))))
  ;(SLEEP 3)
  ) 

