/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetInsertStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectFieldsStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldUpgrade;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgUpgradeSDb {
    private static String PRISTINE_STORAGE_EXT = ".svn-base";
    private static int PRISTINE_BASENAME_OLD_LEN = 40;

    private static String versionStringFromFormat(int wcFormat) {
        switch (wcFormat) {
            case 4: {
                return "<=1.3";
            }
            case 8: {
                return "1.4";
            }
            case 9: {
                return "1.5";
            }
            case 10: {
                return "1.6";
            }
        }
        return "(unreleased development version)";
    }

    public static int upgrade(File wcRootAbsPath, SVNWCDb db, SVNSqlJetDb sDb, int startFormat, ISVNEventHandler eventHandler) throws SVNException {
        SVNErrorMessage err;
        int resultFormat = 0;
        if (startFormat < 12) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Working copy ''{0}'' is too old (format {1}, created by Subversion {2})", wcRootAbsPath, startFormat, SvnNgUpgradeSDb.versionStringFromFormat(startFormat));
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (startFormat < 19) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Working copy ''{0}'' is an old development version (format {1}); to upgrade it, use a format 18 client, then use ''tools/dev/wc-ng/bump-to-19.py'', then use the current client", (Object)wcRootAbsPath, startFormat);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        switch (startFormat) {
            case 19: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo20());
                resultFormat = 20;
            }
            case 20: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo21());
                resultFormat = 21;
            }
            case 21: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo22());
                resultFormat = 22;
            }
            case 22: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo23());
                resultFormat = 23;
            }
            case 23: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo24());
                resultFormat = 24;
            }
            case 24: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo25());
                resultFormat = 25;
            }
            case 25: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo26());
                resultFormat = 26;
            }
            case 26: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo27());
                resultFormat = 27;
            }
            case 27: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo28());
                resultFormat = 28;
            }
            case 28: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo29());
                resultFormat = 29;
            }
            case 29: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo30());
                resultFormat = 30;
            }
            case 30: {
                SvnNgUpgradeSDb.runBump(db, sDb, wcRootAbsPath, new bumpTo31());
                resultFormat = 31;
            }
        }
        SvnOldUpgrade.wipeObsoleteFiles(wcRootAbsPath);
        if (resultFormat != 0 && eventHandler != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(wcRootAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.UPGRADED_PATH, SVNEventAction.UPGRADED_PATH, null, null);
            eventHandler.handleEvent(event, -1.0);
        }
        return resultFormat;
    }

    private static void migrateTreeConflictData(SVNSqlJetDb sDb) throws SVNException {
        SVNSqlJetSelectStatement stmt = new SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.ACTUAL_NODE__Fields>(sDb, (Enum)SVNWCDbSchema.ACTUAL_NODE){

            @Override
            protected void defineFields() {
                this.fields.add(SVNWCDbSchema.ACTUAL_NODE__Fields.wc_id);
                this.fields.add(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath);
                this.fields.add(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
            }

            @Override
            protected boolean isFilterPassed() throws SVNException {
                return !this.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
            }
        };
        try {
            while (((SVNSqlJetStatement)stmt).next()) {
                SvnNgUpgradeSDb.migrateSingleTreeConflictData(sDb, stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data), stmt.getColumnLong(SVNWCDbSchema.ACTUAL_NODE__Fields.wc_id), SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath)));
            }
        }
        finally {
            ((SVNSqlJetStatement)stmt).reset();
        }
        stmt = new SVNSqlJetUpdateStatement(sDb, (Enum)SVNWCDbSchema.ACTUAL_NODE){

            @Override
            public Map<String, Object> getUpdateValues() throws SVNException {
                Map<String, Object> rowValues = this.getRowValues();
                rowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data.toString(), null);
                return rowValues;
            }
        };
        try {
            stmt.exec();
        }
        finally {
            ((SVNSqlJetStatement)stmt).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateSingleTreeConflictData(SVNSqlJetDb sDb, String treeConflictData, long wcId, File localRelPath) throws SVNException {
        Map conflicts = SVNTreeConflictUtil.readTreeConflicts(localRelPath, treeConflictData);
        for (File entryPath : conflicts.keySet()) {
            SVNTreeConflictDescription conflict = (SVNTreeConflictDescription)conflicts.get(entryPath);
            SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
            stmt.bindf("is", wcId, conflict.getPath());
            boolean haveRow = false;
            try {
                haveRow = stmt.next();
            }
            finally {
                stmt.reset();
            }
            stmt = haveRow ? sDb.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CONFLICT_DATA) : sDb.getStatement(SVNWCDbStatements.INSERT_ACTUAL_CONFLICT_DATA);
            stmt.bindf("iss", wcId, conflict.getPath(), SVNTreeConflictUtil.getSingleTreeConflictData(conflict));
            if (!haveRow) {
                stmt.bindString(4, SVNFileUtil.getFilePath(localRelPath));
            }
            try {
                stmt.exec();
            }
            finally {
                stmt.reset();
            }
        }
    }

    public static void setVersion(SVNSqlJetDb sDb, int version) throws SVNException {
        try {
            sDb.getDb().pragma("pragma user_version = " + version);
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
        }
    }

    private static void runBump(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath, Bumpable bump) throws SVNException {
        sDb.beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            bump.bumpTo(db, sDb, wcRootAbsPath);
        }
        catch (SVNException e) {
            sDb.rollback();
            throw e;
        }
        finally {
            sDb.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeExternals(SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_EXTERNAL_PROPERTIES);
        stmt.bindf("is", 1, "");
        try {
            while (stmt.next()) {
                SVNExternal[] externalDefs;
                SVNProperties props = stmt.getColumnProperties(SVNWCDbSchema.NODES__Fields.properties);
                String externalsValues = props.getStringValue("svn:externals");
                File localRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.properties));
                File localAbsPath = SVNFileUtil.createFilePath(wcRootAbsPath, localRelPath);
                if (externalsValues == null) continue;
                for (SVNExternal externalDef : externalDefs = SVNExternal.parseExternals(localAbsPath, externalsValues)) {
                    File externalPath = SVNFileUtil.createFilePath(localAbsPath, externalDef.getPath());
                    SVNSqlJetStatement addStmt = sDb.getStatement(SVNWCDbStatements.INSERT_EXTERNAL);
                    try {
                        addStmt.bindf("isssssis", 1, SVNFileUtil.getFilePath(externalPath), SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(externalPath)), "normal", "unknown", SVNFileUtil.getFilePath(localRelPath), 1, "");
                        addStmt.exec();
                    }
                    finally {
                        addStmt.reset();
                    }
                }
            }
        }
        finally {
            stmt.reset();
        }
    }

    private static class bumpTo31
    implements Bumpable {
        private bumpTo31() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            try {
                if (sDb.getDb().getSchema().getTable("NODES").getColumn("inherited_props") != null) {
                    SvnNgUpgradeSDb.setVersion(sDb, 31);
                    return;
                }
                if (sDb.getDb().getSchema().getIndex("I_ACTUAL_CHANGELIST") != null) {
                    sDb.getDb().dropIndex("I_ACTUAL_CHANGELIST");
                }
                if (sDb.getDb().getSchema().getIndex("I_EXTERNALS_PARENT") != null) {
                    sDb.getDb().dropIndex("I_EXTERNALS_PARENT");
                }
                sDb.getDb().alterTable("ALTER TABLE NODES ADD COLUMN inherited_props BLOB;");
                sDb.getDb().dropIndex("I_NODES_PARENT");
                sDb.getDb().createIndex("CREATE UNIQUE INDEX I_NODES_PARENT ON NODES (wc_id, parent_relpath, local_relpath, op_depth);");
                sDb.getDb().dropIndex("I_ACTUAL_PARENT");
                sDb.getDb().createIndex("CREATE UNIQUE INDEX I_ACTUAL_PARENT ON ACTUAL_NODE (wc_id, parent_relpath, local_relpath);");
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
            SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_WCROOT_NODES);
            SVNSqlJetStatement markRootStmt = sDb.getStatement(SVNWCDbStatements.UPDATE_IPROPS);
            byte[] emptyInheritedProps = SVNSkel.createEmptyList().unparse();
            try {
                while (stmt.next()) {
                    long wcId = stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.wc_id);
                    String localRelPath = stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath);
                    try {
                        markRootStmt.bindf("isb", wcId, localRelPath, emptyInheritedProps);
                        markRootStmt.done();
                    }
                    finally {
                        markRootStmt.reset();
                    }
                }
            }
            finally {
                stmt.reset();
            }
            SvnNgUpgradeSDb.setVersion(sDb, 31);
        }
    }

    private static class bumpTo30
    implements Bumpable {
        private bumpTo30() {
        }

        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            try {
                if (sDb.getDb().getSchema().getTable("NODES").getColumn("inherited_props") == null) {
                    sDb.getDb().createIndex("CREATE UNIQUE INDEX IF NOT EXISTS I_NODES_MOVED ON NODES (wc_id, moved_to, op_depth);");
                    sDb.getDb().createIndex("CREATE INDEX IF NOT EXISTS I_PRISTINE_MD5 ON PRISTINE (md5_checksum);");
                    ISqlJetCursor actulaNode = sDb.getDb().getTable("ACTUAL_NODE").open();
                    while (!actulaNode.eof()) {
                        String conflictOld = actulaNode.getString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old.toString());
                        String conflictWorking = actulaNode.getString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working.toString());
                        String conflictNew = actulaNode.getString(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new.toString());
                        String propReject = actulaNode.getString(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject.toString());
                        byte[] treeConflictData = actulaNode.getBlobAsArray(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data.toString());
                        if (conflictOld == null && conflictWorking == null && conflictNew == null && propReject == null && treeConflictData == null) {
                            actulaNode.next();
                            continue;
                        }
                        String localRelpath = actulaNode.getString(SVNWCDbSchema.ACTUAL_NODE__Fields.local_relpath.toString());
                        SVNSkel conflictData = SvnWcDbConflicts.convertToConflictSkel(wcRootAbsPath, db, localRelpath, conflictOld, conflictWorking, conflictNew, propReject, treeConflictData);
                        HashMap<String, byte[]> newRowValues = new HashMap<String, byte[]>();
                        if (conflictData != null) {
                            newRowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data.toString(), conflictData.unparse());
                        }
                        newRowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old.toString(), null);
                        newRowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working.toString(), null);
                        newRowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new.toString(), null);
                        newRowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject.toString(), null);
                        newRowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data.toString(), null);
                        actulaNode.updateByFieldNames(newRowValues);
                        actulaNode.next();
                    }
                }
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 30);
        }
    }

    private static class bumpTo29
    implements Bumpable {
        private bumpTo29() {
        }

        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            File pristineDirAbsPath = SVNWCUtils.admChild(wcRootAbsPath, "pristine");
            for (File dir : SVNFileListUtil.listFiles(pristineDirAbsPath)) {
                for (File file : SVNFileListUtil.listFiles(dir)) {
                    if (SVNFileType.getType(file) != SVNFileType.FILE || SVNFileUtil.getFileName(file).length() != PRISTINE_BASENAME_OLD_LEN) continue;
                    File newAbsPath = SVNFileUtil.createFilePath(SVNFileUtil.getFilePath(file) + PRISTINE_STORAGE_EXT);
                    SVNFileUtil.rename(file, newAbsPath);
                }
            }
            try {
                sDb.getDb().createTable("CREATE TABLE EXTERNALS (   wc_id  INTEGER NOT NULL REFERENCES WCROOT (id),   local_relpath  TEXT NOT NULL,   parent_relpath  TEXT NOT NULL,   repos_id  INTEGER NOT NULL REFERENCES REPOSITORY (id),   presence  TEXT NOT NULL,   kind  TEXT NOT NULL,   def_local_relpath         TEXT NOT NULL,   def_repos_relpath         TEXT NOT NULL,   def_operational_revision  TEXT,   def_revision              TEXT,   PRIMARY KEY (wc_id, local_relpath) ); ");
                sDb.getDb().createIndex("CREATE INDEX I_EXTERNALS_PARENT ON EXTERNALS (wc_id, parent_relpath);");
                sDb.getDb().createIndex("CREATE UNIQUE INDEX I_EXTERNALS_DEFINED ON EXTERNALS (wc_id, def_local_relpath, local_relpath);");
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
            SvnNgUpgradeSDb.upgradeExternals(sDb, wcRootAbsPath);
            try {
                if (sDb.getDb().getSchema().getTriggerNames().contains("nodes_update_checksum_trigger")) {
                    sDb.getDb().dropTrigger("nodes_update_checksum_trigger");
                }
                if (sDb.getDb().getSchema().getTriggerNames().contains("nodes_insert_trigger")) {
                    sDb.getDb().dropTrigger("nodes_insert_trigger");
                }
                if (sDb.getDb().getSchema().getTriggerNames().contains("nodes_delete_trigger")) {
                    sDb.getDb().dropTrigger("nodes_delete_trigger");
                }
                sDb.getDb().createTrigger("CREATE TRIGGER nodes_update_checksum_trigger AFTER UPDATE OF checksum ON nodes WHEN NEW.checksum IS NOT OLD.checksum BEGIN UPDATE pristine SET refcount = refcount + 1 WHERE checksum = NEW.checksum; UPDATE pristine SET refcount = refcount - 1 WHERE checksum = OLD.checksum; END;");
                sDb.getDb().createTrigger("CREATE TRIGGER nodes_insert_trigger AFTER INSERT ON nodes WHEN NEW.checksum IS NOT NULL BEGIN UPDATE pristine SET refcount = refcount + 1 WHERE checksum = NEW.checksum; END;");
                sDb.getDb().createTrigger("CREATE TRIGGER nodes_delete_trigger AFTER DELETE ON nodes WHEN OLD.checksum IS NOT NULL BEGIN UPDATE pristine SET refcount = refcount - 1 WHERE checksum = OLD.checksum; END;");
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 29);
        }
    }

    private static class bumpTo28
    implements Bumpable {
        private bumpTo28() {
        }

        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            UpdateChecksum uc = new UpdateChecksum(sDb, SVNWCDbSchema.NODES);
            uc.run();
            SvnNgUpgradeSDb.setVersion(sDb, 28);
        }
    }

    private static class bumpTo27
    implements Bumpable {
        private bumpTo27() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.ACTUAL_NODE__Fields> stmt = new SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.ACTUAL_NODE__Fields>(sDb, (Enum)SVNWCDbSchema.ACTUAL_NODE){

                @Override
                protected void defineFields() {
                    this.fields.add(SVNWCDbSchema.ACTUAL_NODE__Fields.wc_id);
                }

                @Override
                protected boolean isFilterPassed() throws SVNException {
                    return !this.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) || !this.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) || !this.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) || !this.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working) || !this.isColumnNull(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data);
                }
            };
            boolean haveRow = false;
            try {
                haveRow = stmt.next();
            }
            finally {
                stmt.reset();
            }
            if (haveRow) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The working copy at ''{0}'' is format 26 with conflicts; use a format 26 client to resolve before using this client", (Object)wcRootAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 27);
        }
    }

    private static class bumpTo26
    implements Bumpable {
        private bumpTo26() {
        }

        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            try {
                if (sDb.getDb().getSchema().getViewNames().contains("NODES_BASE")) {
                    sDb.getDb().dropView("NODES_BASE");
                }
                sDb.getDb().createView("CREATE VIEW NODES_BASE AS SELECT * FROM nodes WHERE op_depth = 0;");
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 26);
        }
    }

    private static class bumpTo25
    implements Bumpable {
        private bumpTo25() {
        }

        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            try {
                sDb.getDb().createView("CREATE VIEW NODES_CURRENT AS SELECT * FROM nodes JOIN (SELECT wc_id, local_relpath, MAX(op_depth) AS op_depth FROM nodes GROUP BY wc_id, local_relpath) AS filter ON nodes.wc_id = filter.wc_id AND nodes.local_relpath = filter.local_relpath AND nodes.op_depth = filter.op_depth;");
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 25);
        }
    }

    private static class bumpTo24
    implements Bumpable {
        private bumpTo24() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            SVNSqlJetUpdateStatement stmt = new SVNSqlJetUpdateStatement(sDb, (Enum)SVNWCDbSchema.PRISTINE){
                private SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.NODES__Fields> select;
                {
                    super(sDb, fromTable);
                    this.select = new SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.NODES__Fields>(this.sDb, (Enum)SVNWCDbSchema.NODES){

                        @Override
                        protected boolean isFilterPassed() throws SVNException {
                            return ((String)this.getBind(1)).equals(this.getColumnString(SVNWCDbSchema.NODES__Fields.checksum));
                        }

                        @Override
                        protected void defineFields() {
                            this.fields.add(SVNWCDbSchema.NODES__Fields.wc_id);
                        }

                        @Override
                        protected Object[] getWhere() throws SVNException {
                            return new Object[0];
                        }
                    };
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Map<String, Object> getUpdateValues() throws SVNException {
                    Map<String, Object> rowValues = this.getRowValues();
                    this.select.bindString(1, (String)rowValues.get(SVNWCDbSchema.PRISTINE__Fields.checksum.toString()));
                    long rowCount = 0L;
                    try {
                        while (this.select.next()) {
                            ++rowCount;
                        }
                    }
                    finally {
                        this.select.reset();
                    }
                    rowValues.put(SVNWCDbSchema.PRISTINE__Fields.refcount.toString(), rowCount);
                    return rowValues;
                }
            };
            try {
                stmt.exec();
            }
            finally {
                stmt.reset();
            }
            SvnNgUpgradeSDb.setVersion(sDb, 24);
            try {
                sDb.getDb().createTrigger("CREATE TRIGGER nodes_insert_trigger AFTER INSERT ON nodes WHEN NEW.checksum IS NOT NULL BEGIN UPDATE pristine SET refcount = refcount + 1 WHERE checksum = NEW.checksum; END;");
                sDb.getDb().createTrigger("CREATE TRIGGER nodes_delete_trigger AFTER DELETE ON nodes WHEN OLD.checksum IS NOT NULL BEGIN UPDATE pristine SET refcount = refcount - 1 WHERE checksum = OLD.checksum; END;");
                sDb.getDb().createTrigger("CREATE TRIGGER nodes_update_checksum_trigger AFTER UPDATE OF checksum ON nodes WHEN NEW.checksum IS NOT OLD.checksum BEGIN UPDATE pristine SET refcount = refcount + 1 WHERE checksum = NEW.checksum; UPDATE pristine SET refcount = refcount - 1 WHERE checksum = OLD.checksum; END;");
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
        }
    }

    private static class bumpTo23
    implements Bumpable {
        private bumpTo23() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.NODES__Fields> stmt = new SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.NODES__Fields>(sDb, (Enum)SVNWCDbSchema.NODES){

                @Override
                protected void defineFields() {
                    this.fields.add(SVNWCDbSchema.NODES__Fields.wc_id);
                }

                @Override
                protected boolean isFilterPassed() throws SVNException {
                    return this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) > 0L;
                }
            };
            boolean haveRow = false;
            try {
                haveRow = stmt.next();
            }
            finally {
                stmt.reset();
            }
            if (haveRow) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The working copy at ''{0}'' is format 22 with WORKING nodes; use a format 22 client to diff/revert before using this client", (Object)wcRootAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 23);
        }
    }

    private static class bumpTo22
    implements Bumpable {
        private bumpTo22() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            SVNSqlJetUpdateStatement stmt = new SVNSqlJetUpdateStatement(sDb, (Enum)SVNWCDbSchema.ACTUAL_NODE){

                @Override
                public Map<String, Object> getUpdateValues() throws SVNException {
                    Map<String, Object> rowValues = this.getRowValues();
                    rowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data.toString(), rowValues.get(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data.toString()));
                    return rowValues;
                }
            };
            try {
                stmt.exec();
            }
            finally {
                stmt.reset();
            }
            stmt = new SVNSqlJetUpdateStatement(sDb, (Enum)SVNWCDbSchema.ACTUAL_NODE){

                @Override
                public Map<String, Object> getUpdateValues() throws SVNException {
                    Map<String, Object> rowValues = this.getRowValues();
                    rowValues.put(SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data.toString(), null);
                    return rowValues;
                }
            };
            try {
                stmt.exec();
            }
            finally {
                stmt.reset();
            }
            SvnNgUpgradeSDb.setVersion(sDb, 22);
        }
    }

    private static class bumpTo21
    implements Bumpable {
        private bumpTo21() {
        }

        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            SvnNgUpgradeSDb.setVersion(sDb, 21);
            SvnNgUpgradeSDb.migrateTreeConflictData(sDb);
        }
    }

    private static class bumpTo20
    implements Bumpable {
        private bumpTo20() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bumpTo(SVNWCDb db, SVNSqlJetDb sDb, File wcRootAbsPath) throws SVNException {
            try {
                sDb.getDb().createTable("CREATE TABLE NODES ( wc_id  INTEGER NOT NULL REFERENCES WCROOT (id), local_relpath  TEXT NOT NULL, op_depth INTEGER NOT NULL,   parent_relpath  TEXT, repos_id  INTEGER REFERENCES REPOSITORY (id), repos_path  TEXT, revision  INTEGER, presence  TEXT NOT NULL,   moved_here  INTEGER, moved_to  TEXT, kind  TEXT NOT NULL, properties  BLOB, depth  TEXT, checksum  TEXT REFERENCES PRISTINE (checksum), symlink_target  TEXT,   changed_revision  INTEGER, changed_date INTEGER, changed_author TEXT, translated_size  INTEGER, last_mod_time  INTEGER,   dav_cache  BLOB, file_external  TEXT, PRIMARY KEY (wc_id, local_relpath, op_depth) ); ");
                sDb.getDb().createIndex("CREATE INDEX I_NODES_PARENT ON NODES (wc_id, parent_relpath, op_depth); ");
                UpdateChecksum uc = new UpdateChecksum(sDb, SVNWCDbSchema.BASE_NODE);
                uc.run();
                uc = new UpdateChecksum(sDb, SVNWCDbSchema.WORKING_NODE);
                uc.run();
                SVNSqlJetInsertStatement stmt = new SVNSqlJetInsertStatement(sDb, SVNWCDbSchema.NODES){
                    private SVNSqlJetSelectStatement select;
                    {
                        super(sDb, tableName);
                        this.select = new SVNSqlJetSelectStatement(this.sDb.getTemporaryDb(), (Enum)SVNWCDbSchema.BASE_NODE){};
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public long exec() throws SVNException {
                        try {
                            int n = 0;
                            while (this.select.next()) {
                                try {
                                    this.table.insertByFieldNamesOr(null, this.getInsertValues());
                                    ++n;
                                }
                                catch (SqlJetException e) {
                                    SVNSqlJetDb.createSqlJetError(e);
                                    long l = -1L;
                                    this.select.reset();
                                    return l;
                                }
                            }
                            long l = n;
                            return l;
                        }
                        finally {
                            this.select.reset();
                        }
                    }

                    @Override
                    protected Map<String, Object> getInsertValues() throws SVNException {
                        Map<String, Object> selectedRow = this.select.getRowValues();
                        HashMap<String, Object> insertValues = new HashMap<String, Object>();
                        insertValues.put(SVNWCDbSchema.NODES__Fields.wc_id.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.wc_id.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.local_relpath.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.local_relpath.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.op_depth.toString(), 0);
                        insertValues.put(SVNWCDbSchema.NODES__Fields.parent_relpath.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.parent_relpath.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.repos_id.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.repos_path.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.repos_path.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.revision.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.revnum.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.presence.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.presence.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.depth.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.depth.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.moved_here.toString(), null);
                        insertValues.put(SVNWCDbSchema.NODES__Fields.moved_to.toString(), null);
                        insertValues.put(SVNWCDbSchema.NODES__Fields.kind.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.kind.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.changed_revision.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.changed_rev.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.changed_date.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.changed_date.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.changed_author.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.changed_author.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.checksum.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.checksum.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.properties.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.properties.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.translated_size.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.translated_size.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.last_mod_time.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.last_mod_time.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.dav_cache.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.dav_cache.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.symlink_target.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.symlink_target.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.file_external.toString(), selectedRow.get(SVNWCDbSchema.BASE_NODE__Fields.file_external.toString()));
                        return insertValues;
                    }
                };
                try {
                    stmt.exec();
                }
                finally {
                    stmt.reset();
                }
                stmt = new SVNSqlJetInsertStatement(sDb, SVNWCDbSchema.NODES){
                    private SVNSqlJetSelectStatement select;
                    {
                        super(sDb, tableName);
                        this.select = new SVNSqlJetSelectStatement(this.sDb.getTemporaryDb(), (Enum)SVNWCDbSchema.BASE_NODE){};
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public long exec() throws SVNException {
                        try {
                            int n = 0;
                            while (this.select.next()) {
                                try {
                                    this.table.insertByFieldNamesOr(null, this.getInsertValues());
                                    ++n;
                                }
                                catch (SqlJetException e) {
                                    SVNSqlJetDb.createSqlJetError(e);
                                    long l = -1L;
                                    this.select.reset();
                                    return l;
                                }
                            }
                            long l = n;
                            return l;
                        }
                        finally {
                            this.select.reset();
                        }
                    }

                    @Override
                    protected Map<String, Object> getInsertValues() throws SVNException {
                        Map<String, Object> selectedRow = this.select.getRowValues();
                        HashMap<String, Object> insertValues = new HashMap<String, Object>();
                        insertValues.put(SVNWCDbSchema.NODES__Fields.wc_id.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.wc_id.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.local_relpath.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.local_relpath.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.op_depth.toString(), 2);
                        insertValues.put(SVNWCDbSchema.NODES__Fields.parent_relpath.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.parent_relpath.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.copyfrom_repos_id.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.repos_path.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.copyfrom_repos_path.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.revision.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.copyfrom_revnum.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.presence.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.presence.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.depth.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.depth.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.moved_here.toString(), null);
                        insertValues.put(SVNWCDbSchema.NODES__Fields.moved_to.toString(), null);
                        insertValues.put(SVNWCDbSchema.NODES__Fields.kind.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.kind.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.changed_revision.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.changed_rev.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.changed_date.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.changed_date.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.changed_author.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.changed_author.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.checksum.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.checksum.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.properties.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.properties.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.translated_size.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.translated_size.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.last_mod_time.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.last_mod_time.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.dav_cache.toString(), null);
                        insertValues.put(SVNWCDbSchema.NODES__Fields.symlink_target.toString(), selectedRow.get(SVNWCDbSchema.WORKING_NODE__Fields.symlink_target.toString()));
                        insertValues.put(SVNWCDbSchema.NODES__Fields.file_external.toString(), null);
                        return insertValues;
                    }
                };
                try {
                    stmt.exec();
                }
                finally {
                    stmt.reset();
                }
                sDb.getDb().dropTable("BASE_NODE");
                sDb.getDb().dropTable("WORKING_NODE");
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
            }
            SvnNgUpgradeSDb.setVersion(sDb, 21);
        }
    }

    private static class UpdateChecksum {
        private SVNSqlJetDb sDb;
        private Enum<?> tableName;

        public UpdateChecksum(SVNSqlJetDb sDb, Enum<?> tableName) {
            this.sDb = sDb;
            this.tableName = tableName;
        }

        public void run() throws SVNException {
            SVNSqlJetUpdateStatement stmt = new SVNSqlJetUpdateStatement(this.sDb, this.tableName){
                private SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.PRISTINE__Fields> select;
                {
                    super(sDb, fromTable);
                    this.select = new SVNSqlJetSelectFieldsStatement<SVNWCDbSchema.PRISTINE__Fields>(this.sDb, (Enum)SVNWCDbSchema.PRISTINE){

                        @Override
                        protected boolean isFilterPassed() throws SVNException {
                            return ((String)this.getBind(1)).equals(this.getColumnString(SVNWCDbSchema.PRISTINE__Fields.md5_checksum));
                        }

                        @Override
                        protected void defineFields() {
                            this.fields.add(SVNWCDbSchema.PRISTINE__Fields.checksum);
                        }

                        @Override
                        protected Object[] getWhere() throws SVNException {
                            return new Object[0];
                        }
                    };
                }

                @Override
                public Map<String, Object> getUpdateValues() throws SVNException {
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public long exec() throws SVNException {
                    long n = 0L;
                    try {
                        this.statementStarted();
                        while (this.next()) {
                            Map<String, Object> rowValues = this.getRowValues();
                            String checksum = (String)rowValues.get("checksum");
                            if (checksum == null) continue;
                            this.select.bindString(1, checksum);
                            try {
                                if (!this.select.next()) continue;
                                rowValues.put("checksum", this.select.getColumnString(SVNWCDbSchema.PRISTINE__Fields.checksum));
                            }
                            finally {
                                this.select.reset();
                                continue;
                            }
                            this.update(rowValues);
                            ++n;
                        }
                        this.statementCompleted(null);
                    }
                    catch (SqlJetException e) {
                        this.statementCompleted(e);
                        SVNSqlJetDb.createSqlJetError(e);
                    }
                    return n;
                }
            };
            try {
                stmt.exec();
            }
            finally {
                stmt.reset();
            }
        }
    }

    private static interface Bumpable {
        public void bumpTo(SVNWCDb var1, SVNSqlJetDb var2, File var3) throws SVNException;
    }
}

