/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.newsclub.net.unix.AFUNIXSelectorProvider;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketCore;
import org.newsclub.net.unix.AFUNIXSocketCredentials;
import org.newsclub.net.unix.AFUNIXSocketExtensions;
import org.newsclub.net.unix.AFUNIXSomeSocket;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.SocketOptionsMapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AFUNIXSocketChannel
extends SocketChannel
implements AFUNIXSomeSocket,
AFUNIXSocketExtensions {
    private final AFUNIXSocket afSocket;
    private final AtomicBoolean connectPending = new AtomicBoolean(false);

    AFUNIXSocketChannel(AFUNIXSocket socket) {
        super(AFUNIXSelectorProvider.getInstance());
        this.afSocket = socket;
    }

    public static AFUNIXSocketChannel open() throws IOException {
        return AFUNIXSelectorProvider.provider().openSocketChannel();
    }

    public static AFUNIXSocketChannel open(SocketAddress remote) throws IOException {
        AFUNIXSocketChannel sc = AFUNIXSocketChannel.open();
        try {
            sc.connect(remote);
        }
        catch (Throwable x) {
            try {
                sc.close();
            }
            catch (Throwable suppressed) {
                x.addSuppressed(suppressed);
            }
            throw x;
        }
        assert (sc.isConnected());
        return sc;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        return (T)this.afSocket.getAFImpl().getOption(optionId);
    }

    @Override
    public <T> AFUNIXSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        Integer optionId = SocketOptionsMapper.resolve(name);
        if (optionId == null) {
            throw new UnsupportedOperationException("unsupported option");
        }
        this.afSocket.getAFImpl().setOption(optionId, value);
        return this;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return SocketOptionsMapper.SUPPORTED_SOCKET_OPTIONS;
    }

    @Override
    public AFUNIXSocketChannel bind(SocketAddress local) throws IOException {
        this.afSocket.bind(local);
        return this;
    }

    @Override
    public AFUNIXSocketChannel shutdownInput() throws IOException {
        this.afSocket.getAFImpl().shutdownInput();
        return this;
    }

    @Override
    public AFUNIXSocketChannel shutdownOutput() throws IOException {
        this.afSocket.getAFImpl().shutdownOutput();
        return this;
    }

    @Override
    public AFUNIXSocket socket() {
        return this.afSocket;
    }

    @Override
    public boolean isConnected() {
        boolean connected = this.afSocket.isConnected();
        if (connected) {
            this.connectPending.set(false);
        }
        return connected;
    }

    @Override
    public boolean isConnectionPending() {
        return this.connectPending.get();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        boolean connected = this.afSocket.connect0(remote, 0);
        if (!connected) {
            this.connectPending.set(true);
        }
        return connected;
    }

    @Override
    public boolean finishConnect() throws IOException {
        boolean connected;
        if (this.isConnected()) {
            return true;
        }
        if (!this.isConnectionPending()) {
            return false;
        }
        boolean bl = connected = NativeUnixSocket.finishConnect(this.afSocket.getFileDescriptor()) || this.isConnected();
        if (connected) {
            this.connectPending.set(false);
        }
        return connected;
    }

    @Override
    public AFUNIXSocketAddress getRemoteAddress() throws IOException {
        return this.afSocket.getRemoteSocketAddress();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.afSocket.getAFImpl().read(dst, null);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        return this.read(dsts[offset]);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (length == 0) {
            return 0L;
        }
        return this.write(srcs[offset]);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.afSocket.getAFImpl().write(src);
    }

    @Override
    public AFUNIXSocketAddress getLocalAddress() throws IOException {
        return this.afSocket.getLocalSocketAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.afSocket.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        this.getAFCore().implConfigureBlocking(block);
    }

    @Override
    public FileDescriptor[] getReceivedFileDescriptors() throws IOException {
        return this.afSocket.getReceivedFileDescriptors();
    }

    @Override
    public void clearReceivedFileDescriptors() {
        this.afSocket.clearReceivedFileDescriptors();
    }

    @Override
    public void setOutboundFileDescriptors(FileDescriptor ... fdescs) throws IOException {
        if (fdescs != null && fdescs.length > 0 && !this.isConnected()) {
            throw new SocketException("Not connected");
        }
        this.afSocket.setOutboundFileDescriptors(fdescs);
    }

    @Override
    public boolean hasOutboundFileDescriptors() {
        return this.afSocket.hasOutboundFileDescriptors();
    }

    @Override
    public AFUNIXSocketCredentials getPeerCredentials() throws IOException {
        return this.afSocket.getPeerCredentials();
    }

    @Override
    public int getAncillaryReceiveBufferSize() {
        return this.afSocket.getAncillaryReceiveBufferSize();
    }

    @Override
    public void setAncillaryReceiveBufferSize(int size) {
        this.afSocket.setAncillaryReceiveBufferSize(size);
    }

    @Override
    public void ensureAncillaryReceiveBufferSize(int minSize) {
        this.afSocket.ensureAncillaryReceiveBufferSize(minSize);
    }

    AFUNIXSocketCore getAFCore() {
        return this.afSocket.getAFImpl().getCore();
    }

    @Override
    public FileDescriptor getFileDescriptor() throws IOException {
        return this.afSocket.getFileDescriptor();
    }

    public String toString() {
        return super.toString() + this.afSocket.toStringSuffix();
    }
}

