/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.trie4j.Algorithms;
import org.trie4j.Trie;

public abstract class AbstractTrie
implements Trie {
    @Override
    public int findShortestWord(CharSequence chars, int start, int end, StringBuilder word) {
        for (int i = start; i < end; ++i) {
            Iterator<String> it = this.commonPrefixSearch(chars.subSequence(i, end).toString()).iterator();
            if (!it.hasNext()) continue;
            if (word != null) {
                word.append(it.next());
            }
            return i;
        }
        return -1;
    }

    @Override
    public int findLongestWord(CharSequence chars, int start, int end, StringBuilder word) {
        for (int i = start; i < end; ++i) {
            Iterator<String> it = this.commonPrefixSearch(chars.subSequence(i, end).toString()).iterator();
            String last = null;
            while (it.hasNext()) {
                last = it.next();
            }
            if (last == null) continue;
            if (word != null) {
                word.append(last);
            }
            return i;
        }
        return -1;
    }

    @Override
    public void dump(Writer writer) throws IOException {
        writer.write("-- dump " + this.getClass().getName() + " --\n");
        Algorithms.dump(this.getRoot(), writer);
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public void freeze() {
    }

    @Override
    public void insert(String word) {
        throw new UnsupportedOperationException();
    }
}

