/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.URLConnection;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.Translate;
import org.htmlparser.visitors.NodeVisitor;

public class StringBean
extends NodeVisitor
implements Serializable {
    public static final String PROP_STRINGS_PROPERTY = "strings";
    public static final String PROP_LINKS_PROPERTY = "links";
    public static final String PROP_URL_PROPERTY = "URL";
    public static final String PROP_REPLACE_SPACE_PROPERTY = "replaceNonBreakingSpaces";
    public static final String PROP_COLLAPSE_PROPERTY = "collapse";
    public static final String PROP_CONNECTION_PROPERTY = "connection";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int NEWLINE_SIZE = NEWLINE.length();
    protected PropertyChangeSupport mPropertySupport = new PropertyChangeSupport(this);
    protected Parser mParser = new Parser();
    protected String mStrings = null;
    protected boolean mLinks = false;
    protected boolean mReplaceSpace = true;
    protected boolean mCollapse = true;
    protected int mCollapseState = 0;
    protected StringBuffer mBuffer = new StringBuffer(4096);
    protected boolean mIsScript = false;
    protected boolean mIsPre = false;
    protected boolean mIsStyle = false;

    public StringBean() {
        super(true, true);
    }

    protected void carriageReturn() {
        int length = this.mBuffer.length();
        if (0 != length && NEWLINE_SIZE <= length && !this.mBuffer.substring(length - NEWLINE_SIZE, length).equals(NEWLINE)) {
            this.mBuffer.append(NEWLINE);
        }
        this.mCollapseState = 0;
    }

    protected void collapse(StringBuffer buffer, String string) {
        int chars = string.length();
        if (0 != chars) {
            block3: for (int i = 0; i < chars; ++i) {
                char character = string.charAt(i);
                switch (character) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\u200b': {
                        if (0 == this.mCollapseState) continue block3;
                        this.mCollapseState = 1;
                        continue block3;
                    }
                    default: {
                        if (1 == this.mCollapseState) {
                            buffer.append(' ');
                        }
                        this.mCollapseState = 2;
                        buffer.append(character);
                    }
                }
            }
        }
    }

    protected String extractStrings() throws ParserException {
        this.mCollapseState = 0;
        this.mParser.visitAllNodesWith(this);
        String ret = this.mBuffer.toString();
        this.mBuffer = new StringBuffer(4096);
        return ret;
    }

    protected void updateStrings(String strings) {
        if (null == this.mStrings || !this.mStrings.equals(strings)) {
            String oldValue = this.mStrings;
            this.mStrings = strings;
            this.mPropertySupport.firePropertyChange(PROP_STRINGS_PROPERTY, oldValue, strings);
        }
    }

    protected void setStrings() {
        this.mCollapseState = 0;
        if (null != this.getURL()) {
            try {
                try {
                    this.mParser.visitAllNodesWith(this);
                    this.updateStrings(this.mBuffer.toString());
                }
                finally {
                    this.mBuffer = new StringBuffer(4096);
                }
            }
            catch (EncodingChangeException ece) {
                this.mIsPre = false;
                this.mIsScript = false;
                this.mIsStyle = false;
                try {
                    this.mParser.reset();
                    this.mBuffer = new StringBuffer(4096);
                    this.mCollapseState = 0;
                    this.mParser.visitAllNodesWith(this);
                    this.updateStrings(this.mBuffer.toString());
                }
                catch (ParserException pe) {
                    this.updateStrings(pe.toString());
                }
                finally {
                    this.mBuffer = new StringBuffer(4096);
                }
            }
            catch (ParserException pe) {
                this.updateStrings(pe.toString());
            }
        } else {
            this.mStrings = null;
            this.mBuffer = new StringBuffer(4096);
        }
    }

    private void resetStrings() {
        if (null != this.mStrings) {
            try {
                this.mParser.setURL(this.getURL());
                this.setStrings();
            }
            catch (ParserException pe) {
                this.updateStrings(pe.toString());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.removePropertyChangeListener(listener);
    }

    public String getStrings() {
        if (null == this.mStrings) {
            if (0 == this.mBuffer.length()) {
                this.setStrings();
            } else {
                this.updateStrings(this.mBuffer.toString());
            }
        }
        return this.mStrings;
    }

    public boolean getLinks() {
        return this.mLinks;
    }

    public void setLinks(boolean links) {
        boolean oldValue = this.mLinks;
        if (oldValue != links) {
            this.mLinks = links;
            this.mPropertySupport.firePropertyChange(PROP_LINKS_PROPERTY, oldValue, links);
            this.resetStrings();
        }
    }

    public String getURL() {
        return null != this.mParser ? this.mParser.getURL() : null;
    }

    public void setURL(String url) {
        String old = this.getURL();
        URLConnection conn = this.getConnection();
        if (null == old && null != url || null != old && !old.equals(url)) {
            try {
                if (null == this.mParser) {
                    this.mParser = new Parser(url);
                } else {
                    this.mParser.setURL(url);
                }
                this.mPropertySupport.firePropertyChange(PROP_URL_PROPERTY, old, this.getURL());
                this.mPropertySupport.firePropertyChange(PROP_CONNECTION_PROPERTY, conn, this.mParser.getConnection());
                this.setStrings();
            }
            catch (ParserException pe) {
                this.updateStrings(pe.toString());
            }
        }
    }

    public boolean getReplaceNonBreakingSpaces() {
        return this.mReplaceSpace;
    }

    public void setReplaceNonBreakingSpaces(boolean replace) {
        boolean oldValue = this.mReplaceSpace;
        if (oldValue != replace) {
            this.mReplaceSpace = replace;
            this.mPropertySupport.firePropertyChange(PROP_REPLACE_SPACE_PROPERTY, oldValue, replace);
            this.resetStrings();
        }
    }

    public boolean getCollapse() {
        return this.mCollapse;
    }

    public void setCollapse(boolean collapse) {
        this.mCollapseState = 0;
        boolean oldValue = this.mCollapse;
        if (oldValue != collapse) {
            this.mCollapse = collapse;
            this.mPropertySupport.firePropertyChange(PROP_COLLAPSE_PROPERTY, oldValue, collapse);
            this.resetStrings();
        }
    }

    public URLConnection getConnection() {
        return null != this.mParser ? this.mParser.getConnection() : null;
    }

    public void setConnection(URLConnection connection) {
        String url = this.getURL();
        URLConnection conn = this.getConnection();
        if (null == conn && null != connection || null != conn && !conn.equals(connection)) {
            try {
                if (null == this.mParser) {
                    this.mParser = new Parser(connection);
                } else {
                    this.mParser.setConnection(connection);
                }
                this.mPropertySupport.firePropertyChange(PROP_URL_PROPERTY, url, this.getURL());
                this.mPropertySupport.firePropertyChange(PROP_CONNECTION_PROPERTY, conn, this.mParser.getConnection());
                this.setStrings();
            }
            catch (ParserException pe) {
                this.updateStrings(pe.toString());
            }
        }
    }

    @Override
    public void visitStringNode(Text string) {
        if (!this.mIsScript && !this.mIsStyle) {
            String text = string.getText();
            if (!this.mIsPre) {
                text = Translate.decode(text);
                if (this.getReplaceNonBreakingSpaces()) {
                    text = text.replace('\u00a0', ' ');
                }
                if (this.getCollapse()) {
                    this.collapse(this.mBuffer, text);
                } else {
                    this.mBuffer.append(text);
                }
            } else {
                this.mBuffer.append(text);
            }
        }
    }

    @Override
    public void visitTag(Tag tag) {
        String name;
        if (tag instanceof LinkTag && this.getLinks()) {
            this.mBuffer.append("<");
            this.mBuffer.append(((LinkTag)tag).getLink());
            this.mBuffer.append(">");
        }
        if ((name = tag.getTagName()).equalsIgnoreCase("PRE")) {
            this.mIsPre = true;
        } else if (name.equalsIgnoreCase("SCRIPT")) {
            this.mIsScript = true;
        } else if (name.equalsIgnoreCase("STYLE")) {
            this.mIsStyle = true;
        }
        if (tag.breaksFlow()) {
            this.carriageReturn();
        }
    }

    @Override
    public void visitEndTag(Tag tag) {
        String name = tag.getTagName();
        if (name.equalsIgnoreCase("PRE")) {
            this.mIsPre = false;
        } else if (name.equalsIgnoreCase("SCRIPT")) {
            this.mIsScript = false;
        } else if (name.equalsIgnoreCase("STYLE")) {
            this.mIsStyle = false;
        }
    }

    public static void main(String[] args) {
        if (0 >= args.length) {
            System.out.println("Usage: java -classpath htmlparser.jar org.htmlparser.beans.StringBean <http://whatever_url>");
        } else {
            StringBean sb = new StringBean();
            sb.setLinks(false);
            sb.setReplaceNonBreakingSpaces(true);
            sb.setCollapse(true);
            sb.setURL(args[0]);
            System.out.println(sb.getStrings());
        }
    }
}

