/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.ini;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class INIFilter
extends AbstractFilter {
    protected Map<String, String> align;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("INIFILTER_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.ini"), new Instance("*.lng"), new Instance("*.strings", StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8.name())};
    }

    private String leftTrim(String s) {
        int i;
        int cp;
        for (i = 0; i < s.length() && ((cp = s.codePointAt(i)) == 32 || cp == 9); i += Character.charCount(cp)) {
        }
        return s.substring(i, s.length());
    }

    private String buildId(String group, String key) {
        StringBuilder sb = new StringBuilder();
        if (group != null) {
            sb.append(group).append('/');
        }
        sb.append(key.trim());
        return sb.toString();
    }

    private String buildVirtualId(String group, String key, int counter) {
        StringBuilder sb = new StringBuilder();
        if (group != null) {
            sb.append(group).append('/');
        }
        if (key != null) {
            sb.append(key.trim());
        }
        sb.append("/#").append(counter);
        return sb.toString();
    }

    @Override
    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        String str;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        String group = null;
        String key = null;
        int line = 0;
        int contlines = 0;
        while ((str = lbpr.readLine()) != null) {
            int afterEqualsPos;
            String omegatId;
            ++line;
            String trimmed = str.trim();
            boolean hasQuote = false;
            if (trimmed.isEmpty() || trimmed.codePointAt(0) == 35 || trimmed.codePointAt(0) == 59) {
                outfile.write(str);
                outfile.write(lbpr.getLinebreak());
                contlines = 0;
                key = null;
                continue;
            }
            if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
                group = trimmed.substring(trimmed.offsetByCodePoints(0, 1), trimmed.offsetByCodePoints(trimmed.length(), -1));
                outfile.write(str);
                outfile.write(lbpr.getLinebreak());
                contlines = 0;
                key = null;
                continue;
            }
            int equalsPos = str.indexOf(61);
            if (equalsPos == -1) {
                omegatId = key == null ? this.buildId(group, "#L" + line) : this.buildVirtualId(group, key, ++contlines);
                afterEqualsPos = 0;
                while (str.codePointCount(afterEqualsPos, str.length()) > 1 && str.codePointAt(afterEqualsPos) == 32) {
                    afterEqualsPos = str.offsetByCodePoints(afterEqualsPos, 1);
                }
            } else {
                int nextOffset;
                while (str.codePointCount(equalsPos, str.length()) > 1 && str.codePointAt(nextOffset = str.offsetByCodePoints(equalsPos, 1)) == 32) {
                    equalsPos = nextOffset;
                }
                key = str.substring(0, equalsPos);
                omegatId = this.buildId(group, key);
                afterEqualsPos = str.offsetByCodePoints(equalsPos, 1);
                contlines = 0;
            }
            outfile.write(str.substring(0, afterEqualsPos));
            String value = str.substring(afterEqualsPos);
            value = this.leftTrim(value);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(value.offsetByCodePoints(0, 1), value.offsetByCodePoints(value.length(), -1));
                hasQuote = true;
            }
            if (this.entryAlignCallback != null) {
                this.align.put(omegatId, value);
                continue;
            }
            if (this.entryParseCallback != null) {
                this.entryParseCallback.addEntry(omegatId, value, null, false, null, null, this, null);
                continue;
            }
            if (this.entryTranslateCallback == null) continue;
            String trans = this.entryTranslateCallback.getTranslation(omegatId, value, null);
            if (trans == null) {
                trans = value;
            }
            if (hasQuote) {
                outfile.write(34);
            }
            outfile.write(trans);
            if (hasQuote) {
                outfile.write(34);
            }
            outfile.write(lbpr.getLinebreak());
        }
        lbpr.close();
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc, String sourcePath) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, sourcePath, this);
        }
    }
}

