/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.doublearray;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.trie4j.AbstractTermIdTrie;
import org.trie4j.Node;
import org.trie4j.TermIdNode;
import org.trie4j.TermIdTrie;
import org.trie4j.Trie;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.util.BitSet;
import org.trie4j.util.FastBitSet;
import org.trie4j.util.Pair;
import sun.misc.Unsafe;

@Deprecated
public class UnsafeDoubleArray
extends AbstractTermIdTrie
implements Externalizable,
TermIdTrie {
    private static final Unsafe unsafe;
    private int size;
    private int nodeSize;
    private int[] base;
    private int[] check;
    private long firstEmptyCheckOffset = Unsafe.ARRAY_INT_BASE_OFFSET + Unsafe.ARRAY_INT_INDEX_SCALE;
    private long last = Unsafe.ARRAY_INT_BASE_OFFSET;
    private SuccinctBitVector term;
    private Set<Character> chars = new TreeSet<Character>();
    private int[] charToScaledCode = new int[65536];
    private static final int BASE_EMPTY = Integer.MAX_VALUE;
    private static final DoubleArrayNode[] emptyNodes;

    public UnsafeDoubleArray() {
    }

    public UnsafeDoubleArray(Trie trie) {
        this(trie, trie.size() * 2);
    }

    public UnsafeDoubleArray(Trie trie, int arraySize) {
        this(trie, arraySize, new TermNodeListener(){

            @Override
            public void listen(Node node, int nodeIndex) {
            }
        });
    }

    public UnsafeDoubleArray(Trie trie, int arraySize, TermNodeListener listener) {
        if (arraySize <= 1) {
            arraySize = 2;
        }
        this.size = trie.size();
        this.nodeSize = trie.nodeSize();
        this.base = new int[arraySize];
        Arrays.fill(this.base, Integer.MAX_VALUE);
        this.check = new int[arraySize];
        Arrays.fill(this.check, -1 * Unsafe.ARRAY_INT_INDEX_SCALE);
        FastBitSet bs = new FastBitSet(arraySize);
        this.build(trie.getRoot(), this.arrayIndexToOffset(0), bs, listener);
        this.term = new BytesRank1OnlySuccinctBitVector(bs.getBytes(), bs.size());
        this.base = Arrays.copyOf(this.base, this.offsetToIntArrayIndex(this.last) + this.chars.size());
        this.check = Arrays.copyOf(this.check, this.offsetToIntArrayIndex(this.last) + this.chars.size());
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TermIdNode getRoot() {
        return this.newDoubleArrayNode(0);
    }

    public int[] getBase() {
        return this.base;
    }

    public int[] getCheck() {
        return this.check;
    }

    public BitSet getTerm() {
        return this.term;
    }

    @Override
    public boolean contains(String text) {
        long nodeOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            int cid = this.charToScaledCode[text.charAt(i)];
            if (cid == 0) {
                return false;
            }
            long next = unsafe.getInt(this.base, nodeOffset) + cid;
            if (next < 0L || (long)unsafe.getInt(this.check, next) != nodeOffset) {
                return false;
            }
            nodeOffset = next;
        }
        return this.term.get((int)(nodeOffset - (long)Unsafe.ARRAY_INT_BASE_OFFSET >> 2));
    }

    public int getNodeId(String text) {
        long nodeOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            int code = this.charToScaledCode[text.charAt(i)];
            if (code == 0) {
                return -1;
            }
            long next = unsafe.getInt(this.base, nodeOffset) + code;
            if (next < 0L || (long)unsafe.getInt(this.check, next) != nodeOffset) {
                return -1;
            }
            nodeOffset = next;
        }
        return this.offsetToIntArrayIndex(nodeOffset);
    }

    @Override
    public int getTermId(String text) {
        int nid = this.getNodeId(text);
        return this.term.get(nid) ? this.term.rank1(nid) - 1 : -1;
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        long checkEnd = this.arrayIndexToOffset(this.check.length);
        long nodeOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharScaledCode(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int b = unsafe.getInt(this.base, nodeOffset);
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            long next = b + cid;
            if (next >= checkEnd || (long)unsafe.getInt(this.check, next) != nodeOffset) {
                return ret;
            }
            nodeOffset = next;
            if (!this.term.get(this.offsetToIntArrayIndex(nodeOffset))) continue;
            ret.add(new String(chars, 0, i + 1));
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> commonPrefixSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        long checkEnd = this.arrayIndexToOffset(this.check.length);
        long nodeOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharScaledCode(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int b = unsafe.getInt(this.base, nodeOffset);
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            long next = b + cid;
            if (next >= checkEnd || (long)unsafe.getInt(this.check, next) != nodeOffset) {
                return ret;
            }
            nodeOffset = next;
            int nodeIndex = this.offsetToIntArrayIndex(nodeOffset);
            if (!this.term.get(nodeIndex)) continue;
            ret.add(Pair.create(new String(chars, 0, i + 1), this.term.rank1(nodeIndex) - 1));
        }
        return ret;
    }

    @Override
    public int findWord(CharSequence chars, int start, int end, StringBuilder word) {
        for (int i = start; i < end; ++i) {
            long nodeOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
            try {
                long next;
                int b;
                int cid;
                for (int j = i; j < end && (cid = this.findCharScaledCode(chars.charAt(j))) != -1 && (b = unsafe.getInt(this.base, nodeOffset)) != Integer.MAX_VALUE && nodeOffset == (long)unsafe.getInt(this.check, next = (long)(b + cid)); ++j) {
                    nodeOffset = next;
                    if (!this.term.get(this.offsetToIntArrayIndex(nodeOffset))) continue;
                    if (word != null) {
                        word.append(chars, i, j + 1);
                    }
                    return i;
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        }
        return -1;
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = prefix.toCharArray();
        int charsLen = chars.length;
        long checkEnd = this.arrayIndexToOffset(this.check.length);
        long nodeOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharScaledCode(chars[i]);
            if (cid == -1) {
                return ret;
            }
            long next = unsafe.getInt(this.base, nodeOffset) + cid;
            if (next < 0L || next >= checkEnd || (long)unsafe.getInt(this.check, next) != nodeOffset) {
                return ret;
            }
            nodeOffset = next;
        }
        int nodeIndex = this.offsetToIntArrayIndex(nodeOffset);
        if (this.term.get(nodeIndex)) {
            ret.add(prefix);
        }
        LinkedList<Pair<Long, String>> q = new LinkedList<Pair<Long, String>>();
        q.add(Pair.create(nodeOffset, prefix));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            long no = (Long)p.getFirst();
            long b = unsafe.getInt(this.base, no);
            if (b == Integer.MAX_VALUE) continue;
            String c = (String)p.getSecond();
            for (char v : this.chars) {
                long next = b + (long)this.charToScaledCode[v];
                if (next < 0L || next >= checkEnd || (long)unsafe.getInt(this.check, next) != no) continue;
                String n = c + v;
                if (this.term.get(this.offsetToIntArrayIndex(next))) {
                    ret.add(n);
                }
                q.push(Pair.create(next, n));
            }
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> predictiveSearchWithTermId(String prefix) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = prefix.toCharArray();
        int charsLen = chars.length;
        if (charsLen == 0) {
            return ret;
        }
        if (this.nodeSize == 0) {
            return ret;
        }
        long checkEnd = this.arrayIndexToOffset(this.check.length);
        long nodeOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharScaledCode(chars[i]);
            if (cid == -1) {
                return ret;
            }
            long next = unsafe.getInt(this.base, nodeOffset) + cid;
            if (next < 0L || next >= checkEnd || (long)unsafe.getInt(this.check, next) != nodeOffset) {
                return ret;
            }
            nodeOffset = next;
        }
        int nodeIndex = this.offsetToIntArrayIndex(nodeOffset);
        if (this.term.get(nodeIndex)) {
            ret.add(Pair.create(prefix, this.term.rank1(nodeIndex) - 1));
        }
        LinkedList<Pair<Long, String>> q = new LinkedList<Pair<Long, String>>();
        q.add(Pair.create(nodeOffset, prefix));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            long no = (Long)p.getFirst();
            int b = unsafe.getInt(this.base, no);
            if (b == Integer.MAX_VALUE) continue;
            String c = (String)p.getSecond();
            for (char v : this.chars) {
                long next = b + this.charToScaledCode[v];
                if (next < 0L || next >= checkEnd || (long)unsafe.getInt(this.check, next) != no) continue;
                String n = c + v;
                int nextIndex = this.offsetToIntArrayIndex(next);
                if (this.term.get(nextIndex)) {
                    ret.add(Pair.create(n, this.term.rank1(nextIndex) - 1));
                }
                q.push(Pair.create(next, n));
            }
        }
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        out.writeInt(this.base.length);
        for (int v : this.base) {
            out.writeInt(v);
        }
        for (int v : this.check) {
            out.writeInt(v);
        }
        out.writeObject(this.term);
        out.writeInt((int)this.firstEmptyCheckOffset);
        out.writeInt(this.chars.size());
        Object object = this.chars.iterator();
        while (object.hasNext()) {
            char c = ((Character)object.next()).charValue();
            out.writeChar(c);
            out.writeInt(this.charToScaledCode[c]);
        }
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            this.writeExternal(out);
        }
        finally {
            out.flush();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        int len = in.readInt();
        this.base = new int[len];
        for (i = 0; i < len; ++i) {
            this.base[i] = in.readInt();
        }
        this.check = new int[len];
        for (i = 0; i < len; ++i) {
            this.check[i] = in.readInt();
        }
        try {
            this.term = (SuccinctBitVector)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.firstEmptyCheckOffset = in.readInt();
        int n = in.readInt();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = in.readChar();
            int v = in.readInt();
            this.chars.add(Character.valueOf(c));
            this.charToScaledCode[c] = v;
        }
    }

    public void load(InputStream is) throws IOException {
        try {
            this.readExternal(new ObjectInputStream(is));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void trimToSize() {
        int sz = (int)this.last + 1 + 65535;
        this.base = Arrays.copyOf(this.base, sz);
        this.check = Arrays.copyOf(this.check, sz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Writer w) {
        PrintWriter writer = new PrintWriter(w);
        try {
            int i;
            writer.println("array size: " + this.base.length);
            writer.print("      |");
            for (i = 0; i < 16; ++i) {
                writer.print(String.format("%3d|", i));
            }
            writer.println();
            writer.print("|base |");
            for (i = 0; i < 16; ++i) {
                if (this.base[i] == Integer.MAX_VALUE) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.base[i]));
            }
            writer.println();
            writer.print("|check|");
            for (i = 0; i < 16; ++i) {
                if (this.check[i] < 0) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.check[i]));
            }
            writer.println();
            writer.print("|term |");
            for (i = 0; i < 16; ++i) {
                writer.print(String.format("%3d|", this.term.get(i) ? 1 : 0));
            }
            writer.println();
            writer.print("chars: ");
            int c = 0;
            for (char e : this.chars) {
                writer.print(String.format("%c:%d,", Character.valueOf(e), this.charToScaledCode[e]));
                if (++c <= 16) continue;
                break;
            }
            writer.println();
            writer.println("chars count: " + this.chars.size());
            writer.println();
        }
        finally {
            writer.flush();
        }
    }

    private void build(Node node, long nodeOffset, FastBitSet bs, TermNodeListener listener) {
        char[] letters = node.getLetters();
        int lettersLen = letters.length;
        for (int i = 1; i < lettersLen; ++i) {
            bs.unsetIfLE(this.offsetToIntArrayIndex(nodeOffset));
            int cid = this.getCharScaledCode(letters[i]);
            long emptyOffset = this.findFirstEmptyCheckOffset();
            this.setCheck(emptyOffset, nodeOffset);
            unsafe.putInt(this.base, nodeOffset, (int)(emptyOffset - (long)cid));
            nodeOffset = emptyOffset;
        }
        int nodeIndex = this.offsetToIntArrayIndex(nodeOffset);
        if (node.isTerminate()) {
            bs.set(nodeIndex);
            listener.listen(node, nodeIndex);
        } else {
            bs.unsetIfLE(nodeIndex);
        }
        Node[] children = node.getChildren();
        int childrenLen = children.length;
        if (childrenLen == 0) {
            return;
        }
        int[] heads = new int[childrenLen];
        int maxHead = 0;
        int minHead = Integer.MAX_VALUE;
        for (int i = 0; i < childrenLen; ++i) {
            heads[i] = this.getCharScaledCode(children[i].getLetters()[0]);
            maxHead = Math.max(maxHead, heads[i]);
            minHead = Math.min(minHead, heads[i]);
        }
        long offset = this.findInsertOffset(heads, minHead, maxHead);
        unsafe.putInt(this.base, nodeOffset, (int)offset);
        for (int cid : heads) {
            this.setCheck(offset + (long)cid, nodeOffset);
        }
        TreeMap<Integer, ArrayList<Pair<Node, Integer>>> nodes = new TreeMap<Integer, ArrayList<Pair<Node, Integer>>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg1 - arg0;
            }
        });
        for (int i = 0; i < children.length; ++i) {
            ArrayList<Pair<Node, Integer>> p;
            Node[] c = children[i].getChildren();
            int n = 0;
            if (c != null) {
                n = c.length;
            }
            if ((p = (ArrayList<Pair<Node, Integer>>)nodes.get(n)) == null) {
                p = new ArrayList<Pair<Node, Integer>>();
                nodes.put(n, p);
            }
            p.add(Pair.create(children[i], heads[i]));
        }
        for (Map.Entry e : nodes.entrySet()) {
            for (Pair e2 : (List)e.getValue()) {
                this.build((Node)e2.getFirst(), (long)((Integer)e2.getSecond()).intValue() + offset, bs, listener);
            }
        }
    }

    private DoubleArrayNode newDoubleArrayNode(int id) {
        return new DoubleArrayNode(id);
    }

    private DoubleArrayNode newDoubleArrayNode(int id, char s) {
        return new DoubleArrayNode(id, s);
    }

    private int findCharScaledCode(char c) {
        int v = this.charToScaledCode[c];
        if (v != 0) {
            return v;
        }
        return -1;
    }

    private int offsetToIntArrayIndex(long offset) {
        return (int)((offset - (long)Unsafe.ARRAY_INT_BASE_OFFSET) / (long)Unsafe.ARRAY_INT_INDEX_SCALE);
    }

    private long arrayIndexToOffset(int index) {
        return Unsafe.ARRAY_INT_BASE_OFFSET + index * Unsafe.ARRAY_INT_INDEX_SCALE;
    }

    private long findInsertOffset(int[] headOffsets, int minHeadOffset, int maxHeadOffset) {
        long empty = this.findFirstEmptyCheckOffset();
        while (true) {
            long offset;
            if ((offset = empty - (long)minHeadOffset) + (long)maxHeadOffset >= this.arrayIndexToOffset(this.check.length)) {
                this.extend(this.offsetToIntArrayIndex(offset + (long)maxHeadOffset));
            }
            boolean found = true;
            for (int ho : headOffsets) {
                if (unsafe.getInt(this.check, offset + (long)ho) < 0) continue;
                found = false;
                break;
            }
            if (found) {
                return offset;
            }
            empty = this.findNextEmptyCheckOffset(empty);
        }
    }

    private int getCharScaledCode(char c) {
        int v = this.charToScaledCode[c];
        if (v != 0) {
            return v;
        }
        this.chars.add(Character.valueOf(c));
        this.charToScaledCode[c] = v = (this.chars.size() + 1) * Unsafe.ARRAY_INT_INDEX_SCALE;
        return v;
    }

    private void extend(int i) {
        int sz = this.base.length;
        int nsz = Math.max(i + 65535, (int)((double)sz * 1.5));
        this.base = Arrays.copyOf(this.base, nsz);
        Arrays.fill(this.base, sz, nsz, Integer.MAX_VALUE);
        this.check = Arrays.copyOf(this.check, nsz);
        Arrays.fill(this.check, sz, nsz, -1 * Unsafe.ARRAY_INT_INDEX_SCALE);
    }

    private long findFirstEmptyCheckOffset() {
        long i = this.firstEmptyCheckOffset;
        while (unsafe.getInt(this.check, i) >= 0 || unsafe.getInt(this.base, i) != Integer.MAX_VALUE) {
            i += (long)Unsafe.ARRAY_INT_INDEX_SCALE;
        }
        this.firstEmptyCheckOffset = i;
        return i;
    }

    private long findNextEmptyCheckOffset(long offset) {
        int d = unsafe.getInt(this.check, offset) * -1;
        if (d <= 0) {
            throw new RuntimeException();
        }
        long prev = offset;
        long endOffset = this.arrayIndexToOffset(this.check.length);
        if (endOffset <= (offset += (long)d)) {
            this.extend(this.offsetToIntArrayIndex(offset));
            return offset;
        }
        if (unsafe.getInt(this.check, offset) < 0) {
            return offset;
        }
        offset += (long)Unsafe.ARRAY_INT_INDEX_SCALE;
        while (offset < endOffset) {
            if (unsafe.getInt(this.check, offset) < 0) {
                unsafe.putInt(this.check, prev, (int)(prev - offset));
                return offset;
            }
            offset += (long)Unsafe.ARRAY_INT_INDEX_SCALE;
        }
        this.extend(this.offsetToIntArrayIndex(offset));
        unsafe.putInt(this.check, prev, (int)(prev - offset));
        return offset;
    }

    private void setCheck(long offset, long nodeOffset) {
        if (this.firstEmptyCheckOffset == offset) {
            this.firstEmptyCheckOffset = this.findNextEmptyCheckOffset(this.firstEmptyCheckOffset);
        }
        unsafe.putInt(this.check, offset, (int)nodeOffset);
        this.last = Math.max(this.last, offset);
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        emptyNodes = new DoubleArrayNode[0];
    }

    protected class DoubleArrayNode
    implements TermIdNode {
        private char firstChar = '\u0000';
        private int nodeId;

        public DoubleArrayNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public DoubleArrayNode(int nodeId, char firstChar) {
            this.nodeId = nodeId;
            this.firstChar = firstChar;
        }

        @Override
        public boolean isTerminate() {
            int nid = this.nodeId;
            CharSequence children;
            int n;
            while ((n = (children = this.listupChildChars(nid)).length()) != 0) {
                int b = UnsafeDoubleArray.this.offsetToIntArrayIndex(UnsafeDoubleArray.this.base[nid]);
                char firstChar = children.charAt(0);
                if (n > 1) {
                    return UnsafeDoubleArray.this.term.get(nid);
                }
                int firstNid = b + UnsafeDoubleArray.this.charToScaledCode[firstChar] / Unsafe.ARRAY_INT_INDEX_SCALE;
                if (UnsafeDoubleArray.this.term.get(firstNid)) {
                    return true;
                }
                nid = firstNid;
            }
            return UnsafeDoubleArray.this.term.get(nid);
        }

        @Override
        public char[] getLetters() {
            StringBuilder ret = new StringBuilder();
            if (this.firstChar != '\u0000') {
                ret.append(this.firstChar);
            }
            return ret.toString().toCharArray();
        }

        public DoubleArrayNode[] getChildren() {
            int nid = this.nodeId;
            CharSequence children;
            int n;
            while ((n = (children = this.listupChildChars(nid)).length()) != 0) {
                int b = UnsafeDoubleArray.this.offsetToIntArrayIndex(UnsafeDoubleArray.this.base[nid]);
                if (n > 1 || UnsafeDoubleArray.this.term.get(nid)) {
                    return this.listupChildNodes(b, children);
                }
                nid = b + UnsafeDoubleArray.this.charToScaledCode[children.charAt(0)] / Unsafe.ARRAY_INT_INDEX_SCALE;
            }
            return emptyNodes;
        }

        @Override
        public DoubleArrayNode getChild(char c) {
            int code = UnsafeDoubleArray.this.charToScaledCode[c];
            if (code == -1) {
                return null;
            }
            int nid = UnsafeDoubleArray.this.offsetToIntArrayIndex(UnsafeDoubleArray.this.base[this.nodeId] + code);
            if (nid >= 0 && nid < UnsafeDoubleArray.this.check.length && UnsafeDoubleArray.this.offsetToIntArrayIndex(UnsafeDoubleArray.this.check[nid]) == this.nodeId) {
                return new DoubleArrayNode(nid, c);
            }
            return null;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getTermId() {
            if (!UnsafeDoubleArray.this.term.get(this.nodeId)) {
                return -1;
            }
            return UnsafeDoubleArray.this.term.rank1(this.nodeId) - 1;
        }

        private CharSequence listupChildChars(int nodeId) {
            StringBuilder b = new StringBuilder();
            long bs = UnsafeDoubleArray.this.base[nodeId];
            Iterator iterator = UnsafeDoubleArray.this.chars.iterator();
            while (iterator.hasNext()) {
                char c = ((Character)iterator.next()).charValue();
                long nodeOffset = bs + (long)UnsafeDoubleArray.this.charToScaledCode[c];
                if (nodeOffset < 0L || nodeOffset >= UnsafeDoubleArray.this.arrayIndexToOffset(UnsafeDoubleArray.this.check.length) || unsafe.getInt(UnsafeDoubleArray.this.check, nodeOffset) != nodeId) continue;
                b.append(c);
            }
            return b;
        }

        private DoubleArrayNode[] listupChildNodes(int baseIndex, CharSequence chars) {
            int n = chars.length();
            DoubleArrayNode[] ret = new DoubleArrayNode[n];
            for (int i = 0; i < n; ++i) {
                char c = chars.charAt(i);
                int code = UnsafeDoubleArray.this.charToScaledCode[c] / Unsafe.ARRAY_INT_INDEX_SCALE;
                ret[i] = UnsafeDoubleArray.this.newDoubleArrayNode(baseIndex + code, c);
            }
            return ret;
        }
    }

    public static interface TermNodeListener {
        public void listen(Node var1, int var2);
    }
}

