/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.madlonkay.supertmxmerge.MergeController;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.gui.LocStringConverter;
import org.madlonkay.supertmxmerge.gui.MapToTextConverter;
import org.madlonkay.supertmxmerge.gui.MenuFrame;
import org.madlonkay.supertmxmerge.gui.MergeCell;
import org.madlonkay.supertmxmerge.gui.ReasonablySizedPanel;
import org.madlonkay.supertmxmerge.gui.SaveButtonConverter;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class MergeWindow
extends JPanel {
    private final Window window;
    private final List<AbstractButton> leftRadioButtons = new ArrayList<AbstractButton>();
    private final List<AbstractButton> rightRadioButtons = new ArrayList<AbstractButton>();
    private final List<AbstractButton> centerRadioButtons = new ArrayList<AbstractButton>();
    private boolean isTwoWayMerge = false;
    private boolean isDetailMode = false;
    private List<MergeController.ConflictInfo> conflicts = null;
    private List<MergeCell> detailModeCells = new ArrayList<MergeCell>();
    private int detailModeIndex = -1;
    private ActionListener mergeSelectionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MergeWindow.this.nextButton.setEnabled(true);
            MergeWindow.this.doneButton.setEnabled(MergeWindow.this.controller.isConflictsAreResolved());
        }
    };
    private JButton allBaseButton;
    private JButton allLeftButton;
    private JButton allRightButton;
    private JButton backButton;
    private JPanel bottomButtonsPanel;
    private JPanel bottomPanel;
    private JLabel centerFilename;
    private JLabel centerTextUnits;
    private LocStringConverter conflictCountConverter;
    private JLabel conflictCountLabel;
    private ReasonablySizedPanel conflictInfoPanel;
    private MergeController controller;
    private JLabel currentConflict;
    private JButton doneButton;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private JLabel instructionsLabel;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JLabel leftFilename;
    private JLabel leftTextUnits;
    private MapToTextConverter mapToTextConverter;
    private JButton modeSwtichButton;
    private JButton nextButton;
    private JLabel rightFilename;
    private JLabel rightTextUnits;
    private SaveButtonConverter saveButtonConverter;
    private JPanel topPanel;
    private LocStringConverter unitCountConverter;
    private BindingGroup bindingGroup;

    public static JFrame newAsFrame(MergeController controller, boolean isTwoWayMerge) {
        MenuFrame frame = new MenuFrame(LocString.get("STM_MERGE_WINDOW_TITLE"));
        frame.setContentPane(new MergeWindow(frame, controller, isTwoWayMerge));
        frame.setDefaultCloseOperation(0);
        return frame;
    }

    public static JDialog newAsDialog(MergeController controller, boolean isTwoWayMerge, Window parentWindow) {
        JDialog dialog = new JDialog(parentWindow, LocString.get("STM_MERGE_WINDOW_TITLE"), Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setDefaultCloseOperation(0);
        dialog.add(new MergeWindow(dialog, controller, isTwoWayMerge));
        return dialog;
    }

    public MergeWindow(final Window window, final MergeController controller, boolean isTwoWayMerge) {
        this.initComponents();
        this.window = window;
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (!controller.isConflictsAreResolved()) {
                    if (!controller.isCanCancel()) {
                        return;
                    }
                    int response = JOptionPane.showConfirmDialog(window, LocString.get("STM_CONFIRM_CLOSE_MESSAGE"), LocString.get("STM_MERGE_WINDOW_TITLE"), 0, 2);
                    if (response != 0) {
                        return;
                    }
                }
                window.dispose();
            }
        });
        this.controller = controller;
        this.isTwoWayMerge = isTwoWayMerge;
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.conflicts = controller.getConflicts();
        this.isDetailMode = this.conflicts.size() <= controller.getListViewThreshold();
        this.initContent();
    }

    private void initContent() {
        this.detailModeCells.clear();
        this.detailModeIndex = -1;
        this.centerRadioButtons.clear();
        this.leftRadioButtons.clear();
        this.rightRadioButtons.clear();
        Map<Key, AbstractButton[]> presets = this.controller.getSelections();
        this.controller.clearSelections();
        this.conflictInfoPanel.removeAll();
        this.jProgressBar1.setVisible(true);
        this.jProgressBar1.setValue(0);
        if (this.isDetailMode) {
            this.conflictInfoPanel.setLayout(new GridLayout(1, 1));
            this.currentConflict.setVisible(true);
            this.modeSwtichButton.setText(LocString.get("STM_LIST_VIEW_BUTTON"));
        } else {
            this.conflictInfoPanel.setLayout(new BoxLayout(this.conflictInfoPanel, 3));
            this.nextButton.setVisible(false);
            this.backButton.setVisible(false);
            this.doneButton.setVisible(true);
            this.doneButton.setEnabled(this.controller.isConflictsAreResolved());
            this.currentConflict.setVisible(false);
            this.modeSwtichButton.setText(LocString.get("STM_DETAIL_VIEW_BUTTON"));
        }
        new InitWorker(presets).execute();
        this.leftFilename.setText(this.controller.getLeftTmx().getName());
        this.centerFilename.setText(this.controller.getBaseTmx().getName());
        this.rightFilename.setText(this.controller.getRightTmx().getName());
        this.leftTextUnits.setText(this.unitCountConverter.convert(this.controller.getLeftTmx().getSize()));
        this.centerTextUnits.setText(this.unitCountConverter.convert(this.controller.getBaseTmx().getSize()));
        this.rightTextUnits.setText(this.unitCountConverter.convert(this.controller.getRightTmx().getSize()));
        this.leftFilename.setToolTipText(MapToTextConverter.mapToHtml(this.controller.getLeftTmx().getMetadata()));
        this.centerFilename.setToolTipText(MapToTextConverter.mapToHtml(this.controller.getBaseTmx().getMetadata()));
        this.rightFilename.setToolTipText(MapToTextConverter.mapToHtml(this.controller.getRightTmx().getMetadata()));
        this.conflictCountLabel.setText(this.conflictCountConverter.convert(this.controller.getConflictCount()));
        this.allBaseButton.setVisible(!this.isTwoWayMerge);
        this.centerFilename.setVisible(!this.isTwoWayMerge);
        this.centerTextUnits.setVisible(!this.isTwoWayMerge);
        GuiUtil.sizeForScreen(this);
    }

    private void addMergeCell(MergeCell cell) {
        if (this.isDetailMode) {
            this.detailModeCells.add(cell);
            if (this.detailModeIndex < 0) {
                this.nextButtonActionPerformed(null);
            }
        } else {
            this.conflictInfoPanel.add(cell);
        }
    }

    private void swapCells(int before, int after) {
        if (before == after) {
            return;
        }
        if (before > -1 && before < this.conflicts.size()) {
            MergeCell current = this.detailModeCells.get(before);
            this.conflictInfoPanel.remove(current);
        }
        if (after > -1 && after < this.conflicts.size()) {
            MergeCell newCell = this.detailModeCells.get(after);
            this.conflictInfoPanel.add(newCell);
            newCell.validate();
            newCell.repaint();
        }
    }

    private void updateDetailModeState() {
        this.currentConflict.setText(LocString.getFormat("STM_DETAIL_VIEW_LOCATION", this.detailModeIndex + 1, this.conflicts.size()));
        this.backButton.setVisible(this.conflicts.size() > 1);
        this.backButton.setEnabled(this.detailModeIndex != 0);
        this.nextButton.setVisible(this.conflicts.size() > 1 && this.detailModeIndex < this.conflicts.size() - 1);
        this.nextButton.setEnabled(this.detailModeCells.get(this.detailModeIndex).isSelectionPerformed());
        this.doneButton.setVisible(this.detailModeIndex == this.conflicts.size() - 1);
        this.doneButton.setEnabled(this.controller.isConflictsAreResolved());
    }

    private void activateAllButtons(List<AbstractButton> buttons) {
        for (AbstractButton b : buttons) {
            b.setSelected(true);
        }
        this.controller.actionPerformed(null);
        this.doneButton.setEnabled(this.controller.isConflictsAreResolved());
        if (this.isDetailMode) {
            this.updateDetailModeState();
        }
    }

    private MergeController getController() {
        return this.controller;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.controller = this.getController();
        this.unitCountConverter = new LocStringConverter("STM_NUMBER_OF_UNITS", "STM_NUMBER_OF_UNITS_SINGULAR");
        this.saveButtonConverter = new SaveButtonConverter();
        this.conflictCountConverter = new LocStringConverter("STM_NUMBER_OF_CONFLICTS", "STM_NUMBER_OF_CONFLICTS_SINGULAR");
        this.mapToTextConverter = new MapToTextConverter();
        this.topPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.leftFilename = new JLabel();
        this.centerFilename = new JLabel();
        this.rightFilename = new JLabel();
        this.leftTextUnits = new JLabel();
        this.centerTextUnits = new JLabel();
        this.rightTextUnits = new JLabel();
        this.jPanel6 = new JPanel();
        this.conflictCountLabel = new JLabel();
        this.instructionsLabel = new JLabel();
        this.jPanel5 = new JPanel();
        this.allLeftButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.allBaseButton = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.allRightButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.conflictInfoPanel = new ReasonablySizedPanel();
        this.bottomPanel = new JPanel();
        this.modeSwtichButton = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.bottomButtonsPanel = new JPanel();
        this.filler4 = new Box.Filler(new Dimension(4, 0), new Dimension(4, 0), new Dimension(4, 0));
        this.currentConflict = new JLabel();
        this.filler3 = new Box.Filler(new Dimension(4, 0), new Dimension(4, 0), new Dimension(4, 0));
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.doneButton = new JButton();
        this.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 3));
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanel2.setLayout(new GridLayout(2, 3, 10, 0));
        this.leftFilename.setFont(this.leftFilename.getFont().deriveFont(this.leftFilename.getFont().getStyle() | 1, this.leftFilename.getFont().getSize() + 2));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${leftTmx.name}"), (Object)this.leftFilename, (Property)BeanProperty.create((String)"text"), (String)"leftFileName");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${leftTmx.metadata}"), (Object)this.leftFilename, (Property)BeanProperty.create((String)"toolTipText"), (String)"leftTmxMetadata");
        binding.setSourceNullValue((Object)LocString.get("STM_TMX_DETAILS_UNAVAILABLE"));
        binding.setConverter((Converter)this.mapToTextConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.leftFilename);
        this.centerFilename.setFont(this.centerFilename.getFont().deriveFont(this.centerFilename.getFont().getStyle() | 1, this.centerFilename.getFont().getSize() + 2));
        this.centerFilename.setHorizontalAlignment(0);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${baseTmx.name}"), (Object)this.centerFilename, (Property)BeanProperty.create((String)"text"), (String)"baseFileName");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${baseTmx.metadata}"), (Object)this.centerFilename, (Property)BeanProperty.create((String)"toolTipText"), (String)"centerTmxMetadata");
        binding.setSourceNullValue((Object)LocString.get("STM_TMX_DETAILS_UNAVAILABLE"));
        binding.setConverter((Converter)this.mapToTextConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.centerFilename);
        this.rightFilename.setFont(this.rightFilename.getFont().deriveFont(this.rightFilename.getFont().getStyle() | 1, this.rightFilename.getFont().getSize() + 2));
        this.rightFilename.setHorizontalAlignment(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${rightTmx.name}"), (Object)this.rightFilename, (Property)BeanProperty.create((String)"text"), (String)"rightFileName");
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${rightTmx.metadata}"), (Object)this.rightFilename, (Property)BeanProperty.create((String)"toolTipText"), (String)"rightTmxMetadata");
        binding.setSourceNullValue((Object)LocString.get("STM_TMX_DETAILS_UNAVAILABLE"));
        binding.setConverter((Converter)this.mapToTextConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.rightFilename);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${leftTmx.size}"), (Object)this.leftTextUnits, (Property)BeanProperty.create((String)"text"), (String)"leftFileUnitCount");
        binding.setConverter((Converter)this.unitCountConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.leftTextUnits);
        this.centerTextUnits.setHorizontalAlignment(0);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${baseTmx.size}"), (Object)this.centerTextUnits, (Property)BeanProperty.create((String)"text"), (String)"baseFileUnitCount");
        binding.setConverter((Converter)this.unitCountConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.centerTextUnits);
        this.rightTextUnits.setHorizontalAlignment(4);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${rightTmx.size}"), (Object)this.rightTextUnits, (Property)BeanProperty.create((String)"text"), (String)"rightFileUnitCount");
        binding.setConverter((Converter)this.unitCountConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.rightTextUnits);
        this.topPanel.add(this.jPanel2);
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanel6.setLayout(new GridLayout(0, 1, 0, 4));
        this.conflictCountLabel.setForeground(new Color(255, 0, 0));
        this.conflictCountLabel.setHorizontalAlignment(0);
        this.conflictCountLabel.setHorizontalTextPosition(0);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${conflictCount}"), (Object)this.conflictCountLabel, (Property)BeanProperty.create((String)"text"), (String)"conflictCount");
        binding.setConverter((Converter)this.conflictCountConverter);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel6.add(this.conflictCountLabel);
        this.instructionsLabel.setHorizontalAlignment(0);
        this.instructionsLabel.setText(LocString.get("STM_MERGE_WINDOW_DIRECTIONS"));
        this.jPanel6.add(this.instructionsLabel);
        this.topPanel.add(this.jPanel6);
        this.jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 2));
        this.allLeftButton.setText(LocString.get("STM_USE_ALL_MINE_BUTTON"));
        this.allLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWindow.this.useAllLeft(evt);
            }
        });
        this.jPanel5.add(this.allLeftButton);
        this.jPanel5.add(this.filler1);
        this.allBaseButton.setText(LocString.get("STM_USE_ALL_BASE_BUTTON"));
        this.allBaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWindow.this.useAllBase(evt);
            }
        });
        this.jPanel5.add(this.allBaseButton);
        this.jPanel5.add(this.filler2);
        this.allRightButton.setText(LocString.get("STM_USE_ALL_THEIRS_BUTTON"));
        this.allRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWindow.this.useAllRight(evt);
            }
        });
        this.jPanel5.add(this.allRightButton);
        this.topPanel.add(this.jPanel5);
        this.add((Component)this.topPanel, "North");
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.conflictInfoPanel.setLayout(null);
        this.jScrollPane1.setViewportView(this.conflictInfoPanel);
        this.add((Component)this.jScrollPane1, "Center");
        this.bottomPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.bottomPanel.setLayout(new BorderLayout());
        this.modeSwtichButton.setText(LocString.get("STM_LIST_VIEW_BUTTON"));
        this.modeSwtichButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWindow.this.modeSwtichButtonActionPerformed(evt);
            }
        });
        this.bottomPanel.add((Component)this.modeSwtichButton, "West");
        this.bottomPanel.add((Component)this.jProgressBar1, "Center");
        this.bottomButtonsPanel.setLayout(new BoxLayout(this.bottomButtonsPanel, 2));
        this.bottomButtonsPanel.add(this.filler4);
        this.bottomButtonsPanel.add(this.currentConflict);
        this.bottomButtonsPanel.add(this.filler3);
        this.backButton.setText(LocString.get("STM_BACK_BUTTON"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWindow.this.backButtonActionPerformed(evt);
            }
        });
        this.bottomButtonsPanel.add(this.backButton);
        this.nextButton.setText(LocString.get("STM_NEXT_BUTTON"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWindow.this.nextButtonActionPerformed(evt);
            }
        });
        this.bottomButtonsPanel.add(this.nextButton);
        this.doneButton.setText(LocString.get("STM_DONE_BUTTON"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.controller, (Property)ELProperty.create((String)"${conflictsAreResolved}"), (Object)this.doneButton, (Property)BeanProperty.create((String)"enabled"), (String)"conflictsResolved");
        this.bindingGroup.addBinding((Binding)binding);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeWindow.this.doneButtonActionPerformed(evt);
            }
        });
        this.bottomButtonsPanel.add(this.doneButton);
        this.bottomPanel.add((Component)this.bottomButtonsPanel, "East");
        this.add((Component)this.bottomPanel, "South");
        this.bindingGroup.bind();
    }

    private void useAllLeft(ActionEvent evt) {
        this.activateAllButtons(this.leftRadioButtons);
    }

    private void doneButtonActionPerformed(ActionEvent evt) {
        this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this.window, 201));
    }

    private void useAllBase(ActionEvent evt) {
        this.activateAllButtons(this.centerRadioButtons);
    }

    private void useAllRight(ActionEvent evt) {
        this.activateAllButtons(this.rightRadioButtons);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        int before = this.detailModeIndex;
        this.detailModeIndex = Math.min(this.detailModeCells.size() - 1, this.detailModeIndex + 1);
        this.swapCells(before, this.detailModeIndex);
        this.updateDetailModeState();
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        int before = this.detailModeIndex;
        this.detailModeIndex = Math.max(0, this.detailModeIndex - 1);
        this.swapCells(before, this.detailModeIndex);
        this.updateDetailModeState();
    }

    private void modeSwtichButtonActionPerformed(ActionEvent evt) {
        if (this.isDetailMode) {
            this.swapCells(this.detailModeIndex, -1);
        }
        this.isDetailMode = !this.isDetailMode;
        this.initContent();
        this.validate();
        this.repaint();
    }

    private class InitWorker
    extends SwingWorker<List<MergeCell>, MergeCell> {
        private final Map<Key, AbstractButton[]> presets;

        public InitWorker(Map<Key, AbstractButton[]> presets) {
            this.presets = presets;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("progress".equals(evt.getPropertyName())) {
                        MergeWindow.this.jProgressBar1.setValue((Integer)evt.getNewValue());
                    }
                }
            });
        }

        @Override
        protected List<MergeCell> doInBackground() throws Exception {
            ArrayList<MergeCell> result = new ArrayList<MergeCell>();
            int n = 1;
            for (MergeController.ConflictInfo info : MergeWindow.this.conflicts) {
                MergeCell cell = new MergeCell(n, info, MergeWindow.this.isDetailMode);
                cell.setIsTwoWayMerge(MergeWindow.this.isTwoWayMerge);
                result.add(cell);
                this.publish(cell);
                this.setProgress(100 * n / MergeWindow.this.conflicts.size());
                ++n;
            }
            return result;
        }

        @Override
        protected void process(List<MergeCell> chunks) {
            for (MergeCell cell : chunks) {
                AbstractButton[] preset;
                AbstractButton[] buttons = cell.getButtons();
                MergeWindow.this.leftRadioButtons.add(buttons[0]);
                MergeWindow.this.centerRadioButtons.add(buttons[1]);
                MergeWindow.this.rightRadioButtons.add(buttons[2]);
                if (this.presets.size() > 0 && (preset = this.presets.get(cell.getKey())) != null) {
                    for (int i = 0; i < preset.length; ++i) {
                        if (!preset[i].isSelected()) continue;
                        buttons[i].setSelected(true);
                        break;
                    }
                }
                for (AbstractButton button : buttons) {
                    button.addActionListener(MergeWindow.this.mergeSelectionListener);
                }
                MergeWindow.this.controller.addSelection(cell.getKey(), buttons);
                MergeWindow.this.addMergeCell(cell);
            }
            MergeWindow.this.conflictInfoPanel.revalidate();
        }

        @Override
        protected void done() {
            MergeWindow.this.jProgressBar1.setVisible(false);
            MergeWindow.this.doneButton.setEnabled(MergeWindow.this.controller.isConflictsAreResolved());
        }
    }
}

