/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.Map;

public abstract class AbstractTrainer {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String TRAINER_TYPE_PARAM = "TrainerType";
    public static final String CUTOFF_PARAM = "Cutoff";
    public static final int CUTOFF_DEFAULT = 5;
    public static final String ITERATIONS_PARAM = "Iterations";
    public static final int ITERATIONS_DEFAULT = 100;
    private Map<String, String> trainParams;
    private Map<String, String> reportMap;

    public void init(Map<String, String> trainParams, Map<String, String> reportMap) {
        this.trainParams = trainParams;
        this.reportMap = reportMap;
    }

    public String getAlgorithm() {
        return this.getStringParam(ALGORITHM_PARAM, "MAXENT");
    }

    public int getCutoff() {
        return this.getIntParam(CUTOFF_PARAM, 5);
    }

    public int getIterations() {
        return this.getIntParam(ITERATIONS_PARAM, 100);
    }

    protected String getStringParam(String key, String defaultValue) {
        String valueString = this.trainParams.get(key);
        if (valueString == null) {
            valueString = defaultValue;
        }
        if (this.reportMap != null) {
            this.reportMap.put(key, valueString);
        }
        return valueString;
    }

    protected int getIntParam(String key, int defaultValue) {
        String valueString = this.trainParams.get(key);
        if (valueString != null) {
            return Integer.parseInt(valueString);
        }
        return defaultValue;
    }

    protected double getDoubleParam(String key, double defaultValue) {
        String valueString = this.trainParams.get(key);
        if (valueString != null) {
            return Double.parseDouble(valueString);
        }
        return defaultValue;
    }

    protected boolean getBooleanParam(String key, boolean defaultValue) {
        String valueString = this.trainParams.get(key);
        if (valueString != null) {
            return Boolean.parseBoolean(valueString);
        }
        return defaultValue;
    }

    protected void addToReport(String key, String value) {
        if (this.reportMap != null) {
            this.reportMap.put(key, value);
        }
    }

    public boolean isValid() {
        try {
            String iterationsString;
            String cutoffString = this.trainParams.get(CUTOFF_PARAM);
            if (cutoffString != null) {
                Integer.parseInt(cutoffString);
            }
            if ((iterationsString = this.trainParams.get(ITERATIONS_PARAM)) != null) {
                Integer.parseInt(iterationsString);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

