/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.regex.Pattern;

public class Token {
    private int hash;
    private static final Pattern AMP = Pattern.compile("\\&");
    private final int length;
    private final int offset;

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Token) {
            return this.hash == ((Token)other).hash;
        }
        return false;
    }

    public boolean deepEquals(Token other) {
        return this.equals(other) && this.offset == other.offset && this.length == other.length;
    }

    public int hashCode() {
        return this.hash;
    }

    private String stripAmpersand(String s) {
        return AMP.matcher(s).replaceAll("");
    }

    public Token(String text, int offset) {
        this(text, offset, text.length());
    }

    public Token(String text, int offset, int length) {
        this.length = length;
        this.hash = text == null ? -1 : this.stripAmpersand(text).hashCode();
        this.offset = offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final String toString() {
        return this.hash + "@" + this.offset;
    }

    public String getTextFromString(String input) {
        return input.substring(this.offset, this.length + this.offset);
    }

    public static String[] getTextsFromString(Token[] tokens, String string) {
        String[] result = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            result[i] = tokens[i].getTextFromString(string);
        }
        return result;
    }
}

