/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

public class SearchMatch
implements Comparable<SearchMatch> {
    private int start;
    private int end;
    private String replacement;

    public SearchMatch(int start, int end) {
        this.start = start;
        this.end = end;
        this.replacement = null;
    }

    public SearchMatch(int start, int end, String replacement) {
        this.start = start;
        this.end = end;
        this.replacement = replacement;
    }

    @Override
    public int compareTo(SearchMatch o) {
        int diff = this.start - o.start;
        if (diff == 0) {
            diff = this.end - o.end;
        }
        return diff;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void move(int offset) {
        this.start += offset;
        this.end += offset;
    }

    public String toString() {
        return String.format("[%d,%d] => %s", this.start, this.end, this.replacement);
    }
}

