/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.doublearray;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.trie4j.AbstractTermIdTrie;
import org.trie4j.Node;
import org.trie4j.TermIdNode;
import org.trie4j.TermIdTrie;
import org.trie4j.Trie;
import org.trie4j.bv.BytesRank1OnlySuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.util.BitSet;
import org.trie4j.util.FastBitSet;
import org.trie4j.util.Pair;

public class UnifiedIntDoubleArray
extends AbstractTermIdTrie
implements Externalizable,
TermIdTrie {
    private int size;
    private int nodeSize;
    private int[] baseAndCheckInt;
    private int firstEmptyCheck = 1;
    private int last;
    private SuccinctBitVector term;
    private Set<Character> chars = new TreeSet<Character>();
    private char[] charToCode = new char[65535];
    private static final int BASE_EMPTY = Integer.MAX_VALUE;
    private static final int CHECK_EMPTY = -1;
    private static final DoubleArrayNode[] emptyNodes = new DoubleArrayNode[0];

    public UnifiedIntDoubleArray() {
    }

    public UnifiedIntDoubleArray(Trie trie) {
        this(trie, trie.size() * 2);
    }

    public UnifiedIntDoubleArray(Trie trie, int arraySize) {
        this(trie, arraySize, new TermNodeListener(){

            @Override
            public void listen(Node node, int nodeIndex) {
            }
        });
    }

    public UnifiedIntDoubleArray(Trie trie, int arraySize, TermNodeListener listener) {
        if (arraySize <= 1) {
            arraySize = 2;
        }
        this.size = trie.size();
        this.baseAndCheckInt = new int[0];
        this.extend(arraySize - 1);
        FastBitSet bs = new FastBitSet(arraySize);
        this.nodeSize = 1;
        this.build(trie.getRoot(), 0, bs, listener);
        this.term = new BytesRank1OnlySuccinctBitVector(bs.getBytes(), bs.size());
        this.baseAndCheckInt = Arrays.copyOf(this.baseAndCheckInt, (this.last + this.chars.size()) * 2);
    }

    @Override
    public int nodeSize() {
        return this.nodeSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TermIdNode getRoot() {
        return this.newDoubleArrayNode(0);
    }

    public int[] getBaseAndCheck() {
        return this.baseAndCheckInt;
    }

    public BitSet getTerm() {
        return this.term;
    }

    @Override
    public boolean contains(String text) {
        int nodeIndex = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char cid = this.charToCode[text.charAt(i)];
            if (cid == '\u0000') {
                return false;
            }
            int next = this.getBase(nodeIndex) + cid;
            if (next < 0 || this.getCheck(next) != nodeIndex) {
                return false;
            }
            nodeIndex = next;
        }
        return this.term.get(nodeIndex);
    }

    public int getNodeId(String text) {
        int nodeIndex = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char cid = this.charToCode[text.charAt(i)];
            if (cid == '\u0000') {
                return -1;
            }
            int next = this.getBase(nodeIndex) + cid;
            if (next < 0 || this.getCheck(next) != nodeIndex) {
                return -1;
            }
            nodeIndex = next;
        }
        return nodeIndex;
    }

    @Override
    public int getTermId(String text) {
        int nid = this.getNodeId(text);
        if (nid == -1) {
            return -1;
        }
        return this.term.get(nid) ? this.term.rank1(nid) - 1 : -1;
    }

    @Override
    public Iterable<String> commonPrefixSearch(String query) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int checkLen = this.getBaseAndCheckLength();
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int b = this.getBase(nodeIndex);
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            int next = b + cid;
            if (next >= checkLen || this.getCheck(next) != nodeIndex) {
                return ret;
            }
            nodeIndex = next;
            if (!this.term.get(nodeIndex)) continue;
            ret.add(new String(chars, 0, i + 1));
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> commonPrefixSearchWithTermId(String query) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = query.toCharArray();
        int charsLen = chars.length;
        int checkLen = this.getBaseAndCheckLength();
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int b = this.getBase(nodeIndex);
            if (b == Integer.MAX_VALUE) {
                return ret;
            }
            int next = b + cid;
            if (next >= checkLen || this.getCheck(next) != nodeIndex) {
                return ret;
            }
            nodeIndex = next;
            if (!this.term.get(nodeIndex)) continue;
            ret.add(Pair.create(new String(chars, 0, i + 1), this.term.rank1(nodeIndex) - 1));
        }
        return ret;
    }

    @Override
    public int findWord(CharSequence chars, int start, int end, StringBuilder word) {
        for (int i = start; i < end; ++i) {
            int nodeIndex = 0;
            try {
                int next;
                int b;
                int cid;
                for (int j = i; j < end && (cid = this.findCharId(chars.charAt(j))) != -1 && (b = this.getBase(nodeIndex)) != Integer.MAX_VALUE && nodeIndex == this.getCheck(next = b + cid); ++j) {
                    nodeIndex = next;
                    if (!this.term.get(nodeIndex)) continue;
                    if (word != null) {
                        word.append(chars, i, j + 1);
                    }
                    return i;
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        }
        return -1;
    }

    @Override
    public Iterable<String> predictiveSearch(String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        char[] chars = prefix.toCharArray();
        int charsLen = chars.length;
        int checkLen = this.getBaseAndCheckLength();
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int next = this.getBase(nodeIndex) + cid;
            if (next < 0 || next >= checkLen || this.getCheck(next) != nodeIndex) {
                return ret;
            }
            nodeIndex = next;
        }
        if (this.term.get(nodeIndex)) {
            ret.add(prefix);
        }
        LinkedList<Pair<Integer, String>> q = new LinkedList<Pair<Integer, String>>();
        q.add(Pair.create(nodeIndex, prefix));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            int ni = (Integer)p.getFirst();
            int b = this.getBase(ni);
            if (b == Integer.MAX_VALUE) continue;
            String c = (String)p.getSecond();
            for (char v : this.chars) {
                int next = b + this.charToCode[v];
                if (next < 0 || next >= checkLen || this.getCheck(next) != ni) continue;
                String n = c + v;
                if (this.term.get(next)) {
                    ret.add(n);
                }
                q.push(Pair.create(next, n));
            }
        }
        return ret;
    }

    @Override
    public Iterable<Pair<String, Integer>> predictiveSearchWithTermId(String prefix) {
        ArrayList<Pair<String, Integer>> ret = new ArrayList<Pair<String, Integer>>();
        char[] chars = prefix.toCharArray();
        int charsLen = chars.length;
        if (charsLen == 0) {
            return ret;
        }
        if (this.nodeSize == 0) {
            return ret;
        }
        int checkLen = this.getBaseAndCheckLength();
        int nodeIndex = 0;
        for (int i = 0; i < charsLen; ++i) {
            int cid = this.findCharId(chars[i]);
            if (cid == -1) {
                return ret;
            }
            int next = this.getBase(nodeIndex) + cid;
            if (next < 0 || next >= checkLen || this.getCheck(next) != nodeIndex) {
                return ret;
            }
            nodeIndex = next;
        }
        if (this.term.get(nodeIndex)) {
            ret.add(Pair.create(prefix, this.term.rank1(nodeIndex) - 1));
        }
        LinkedList<Pair<Integer, String>> q = new LinkedList<Pair<Integer, String>>();
        q.add(Pair.create(nodeIndex, prefix));
        while (!q.isEmpty()) {
            Pair p = (Pair)q.pop();
            int ni = (Integer)p.getFirst();
            int b = this.getBase(ni);
            if (b == Integer.MAX_VALUE) continue;
            String c = (String)p.getSecond();
            for (char v : this.chars) {
                int next = b + this.charToCode[v];
                if (next < 0 || next >= checkLen || this.getCheck(next) != ni) continue;
                String n = c + v;
                if (this.term.get(next)) {
                    ret.add(Pair.create(n, this.term.rank1(next) - 1));
                }
                q.push(Pair.create(next, n));
            }
        }
        return ret;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.nodeSize);
        out.writeInt(this.baseAndCheckInt.length);
        for (int v : this.baseAndCheckInt) {
            out.writeInt(v);
        }
        out.writeObject(this.term);
        out.writeInt(this.firstEmptyCheck);
        out.writeInt(this.chars.size());
        Object object = this.chars.iterator();
        while (object.hasNext()) {
            char c = ((Character)object.next()).charValue();
            out.writeChar(c);
            out.writeChar(this.charToCode[c]);
        }
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(os);
        try {
            this.writeExternal(out);
        }
        finally {
            out.flush();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.nodeSize = in.readInt();
        int len = in.readInt();
        this.baseAndCheckInt = new int[len];
        for (int i = 0; i < len; ++i) {
            this.baseAndCheckInt[i] = in.readInt();
        }
        try {
            this.term = (SuccinctBitVector)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.firstEmptyCheck = in.readInt();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            char c = in.readChar();
            char v = in.readChar();
            this.chars.add(Character.valueOf(c));
            this.charToCode[c] = v;
        }
    }

    public void load(InputStream is) throws IOException {
        try {
            this.readExternal(new ObjectInputStream(is));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void trimToSize() {
        int sz = this.last + 1 + 65535;
        this.baseAndCheckInt = Arrays.copyOf(this.baseAndCheckInt, sz * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Writer w) {
        PrintWriter writer = new PrintWriter(w);
        try {
            int i;
            int n = Math.min(16, this.last);
            writer.println("array size: " + this.getBaseAndCheckLength());
            writer.print("      |");
            for (i = 0; i < n; ++i) {
                writer.print(String.format("%3d|", i));
            }
            writer.println();
            writer.print("|base |");
            for (i = 0; i < n; ++i) {
                if (this.getBase(i) == Integer.MAX_VALUE) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.getBase(i)));
            }
            writer.println();
            writer.print("|check|");
            for (i = 0; i < n; ++i) {
                if (this.getCheck(i) < 0) {
                    writer.print("N/A|");
                    continue;
                }
                writer.print(String.format("%3d|", this.getCheck(i)));
            }
            writer.println();
            writer.print("|term |");
            for (i = 0; i < n; ++i) {
                writer.print(String.format("%3d|", this.term.get(i) ? 1 : 0));
            }
            writer.println();
            writer.print("chars: ");
            int c = 0;
            for (char e : this.chars) {
                writer.print(String.format("%c:%d,", Character.valueOf(e), (int)this.charToCode[e]));
                if (++c <= 16) continue;
                break;
            }
            writer.println();
            writer.println("chars count: " + this.chars.size());
            writer.println();
        }
        finally {
            writer.flush();
        }
    }

    private void build(Node node, int nodeIndex, FastBitSet bs, TermNodeListener listener) {
        char[] letters = node.getLetters();
        int lettersLen = letters.length;
        if (lettersLen > 0) {
            ++this.nodeSize;
        }
        for (int i = 1; i < lettersLen; ++i) {
            bs.unsetIfLE(nodeIndex);
            int cid = this.getCharId(letters[i]);
            int empty = this.findFirstEmptyCheck();
            this.setCheck(empty, nodeIndex);
            this.setBaseFast(nodeIndex, empty - cid);
            ++this.nodeSize;
            nodeIndex = empty;
        }
        if (node.isTerminate()) {
            bs.set(nodeIndex);
            listener.listen(node, nodeIndex);
        } else {
            bs.unsetIfLE(nodeIndex);
        }
        Node[] children = node.getChildren();
        int childrenLen = children.length;
        if (childrenLen == 0) {
            return;
        }
        int[] heads = new int[childrenLen];
        int maxHead = 0;
        int minHead = Integer.MAX_VALUE;
        for (int i = 0; i < childrenLen; ++i) {
            heads[i] = this.getCharId(children[i].getLetters()[0]);
            maxHead = Math.max(maxHead, heads[i]);
            minHead = Math.min(minHead, heads[i]);
        }
        int offset = this.findInsertOffset(heads, minHead, maxHead);
        this.setBaseFast(nodeIndex, offset);
        for (int cid : heads) {
            this.setCheck(offset + cid, nodeIndex);
        }
        TreeMap<Integer, ArrayList<Pair<Node, Integer>>> nodes = new TreeMap<Integer, ArrayList<Pair<Node, Integer>>>(new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg1 - arg0;
            }
        });
        for (int i = 0; i < children.length; ++i) {
            ArrayList<Pair<Node, Integer>> p;
            Node[] c = children[i].getChildren();
            int n = 0;
            if (c != null) {
                n = c.length;
            }
            if ((p = (ArrayList<Pair<Node, Integer>>)nodes.get(n)) == null) {
                p = new ArrayList<Pair<Node, Integer>>();
                nodes.put(n, p);
            }
            p.add(Pair.create(children[i], heads[i]));
        }
        for (Map.Entry e : nodes.entrySet()) {
            for (Pair e2 : (List)e.getValue()) {
                this.build((Node)e2.getFirst(), (Integer)e2.getSecond() + offset, bs, listener);
            }
        }
    }

    private DoubleArrayNode newDoubleArrayNode(int id) {
        return new DoubleArrayNode(id);
    }

    private DoubleArrayNode newDoubleArrayNode(int id, char s) {
        return new DoubleArrayNode(id, s);
    }

    private int findCharId(char c) {
        char v = this.charToCode[c];
        if (v != '\u0000') {
            return v;
        }
        return -1;
    }

    private int findInsertOffset(int[] heads, int minHead, int maxHead) {
        int empty = this.findFirstEmptyCheck();
        while (true) {
            int offset;
            if ((offset = empty - minHead) + maxHead >= this.getBaseAndCheckLength()) {
                this.extend(offset + maxHead);
            }
            boolean found = true;
            for (int cid : heads) {
                if (this.getCheck(offset + cid) < 0) continue;
                found = false;
                break;
            }
            if (found) {
                return offset;
            }
            empty = this.findNextEmptyCheck(empty);
        }
    }

    private int getCharId(char c) {
        char v = this.charToCode[c];
        if (v != '\u0000') {
            return v;
        }
        v = (char)(this.chars.size() + 1);
        this.chars.add(Character.valueOf(c));
        this.charToCode[c] = v;
        return v;
    }

    private void extend(int i) {
        int sz = this.getBaseAndCheckLength();
        int nsz = Math.max(i + 65535, (int)((double)sz * 1.5));
        this.baseAndCheckInt = Arrays.copyOf(this.baseAndCheckInt, nsz * 2);
        for (int idx = sz * 2; idx < nsz * 2; ++idx) {
            this.baseAndCheckInt[idx++] = Integer.MAX_VALUE;
            this.baseAndCheckInt[idx] = -1;
        }
    }

    private int findFirstEmptyCheck() {
        int i = this.firstEmptyCheck;
        while (this.getCheck(i) >= 0 || this.getBase(i) != Integer.MAX_VALUE) {
            ++i;
        }
        this.firstEmptyCheck = i;
        return i;
    }

    private int findNextEmptyCheck(int i) {
        int d = this.getCheck(i) * -1;
        if (d <= 0) {
            throw new RuntimeException();
        }
        int prev = i;
        if (this.getBaseAndCheckLength() <= (i += d)) {
            this.extend(i);
            return i;
        }
        if (this.getCheck(i) < 0) {
            return i;
        }
        ++i;
        while (i < this.getBaseAndCheckLength()) {
            if (this.getCheck(i) < 0) {
                this.setCheckFast(prev, prev - i);
                return i;
            }
            ++i;
        }
        this.extend(i);
        this.setCheckFast(prev, prev - i);
        return i;
    }

    private int getBaseAndCheckLength() {
        return this.baseAndCheckInt.length / 2;
    }

    private int getBase(int index) {
        return this.baseAndCheckInt[index * 2];
    }

    private void setBaseFast(int index, int value) {
        this.baseAndCheckInt[index * 2] = value;
    }

    private int getCheck(int index) {
        return this.baseAndCheckInt[index * 2 + 1];
    }

    private void setCheckFast(int index, int value) {
        this.baseAndCheckInt[index * 2 + 1] = value;
    }

    private void setCheck(int index, int value) {
        if (this.firstEmptyCheck == index) {
            this.firstEmptyCheck = this.findNextEmptyCheck(this.firstEmptyCheck);
        }
        this.baseAndCheckInt[index * 2 + 1] = value;
        this.last = Math.max(this.last, index);
    }

    protected class DoubleArrayNode
    implements TermIdNode {
        private char firstChar = '\u0000';
        private int nodeId;

        public DoubleArrayNode(int nodeId) {
            this.nodeId = nodeId;
        }

        public DoubleArrayNode(int nodeId, char firstChar) {
            this.nodeId = nodeId;
            this.firstChar = firstChar;
        }

        @Override
        public boolean isTerminate() {
            return UnifiedIntDoubleArray.this.term.get(this.nodeId);
        }

        @Override
        public char[] getLetters() {
            StringBuilder ret = new StringBuilder();
            if (this.firstChar != '\u0000') {
                ret.append(this.firstChar);
            }
            return ret.toString().toCharArray();
        }

        public DoubleArrayNode[] getChildren() {
            CharSequence children = this.listupChildChars(this.nodeId);
            if (children.length() == 0) {
                return emptyNodes;
            }
            return this.listupChildNodes(UnifiedIntDoubleArray.this.getBase(this.nodeId), children);
        }

        @Override
        public DoubleArrayNode getChild(char c) {
            char code = UnifiedIntDoubleArray.this.charToCode[c];
            if (code == '\uffffffff') {
                return null;
            }
            int nid = UnifiedIntDoubleArray.this.getBase(this.nodeId) + code;
            if (nid >= 0 && nid < UnifiedIntDoubleArray.this.getBaseAndCheckLength() && UnifiedIntDoubleArray.this.getCheck(nid) == this.nodeId) {
                return new DoubleArrayNode(nid, c);
            }
            return null;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getTermId() {
            if (!UnifiedIntDoubleArray.this.term.get(this.nodeId)) {
                return -1;
            }
            return UnifiedIntDoubleArray.this.term.rank1(this.nodeId) - 1;
        }

        private CharSequence listupChildChars(int nodeId) {
            StringBuilder b = new StringBuilder();
            int bs = UnifiedIntDoubleArray.this.getBase(nodeId);
            Iterator iterator = UnifiedIntDoubleArray.this.chars.iterator();
            while (iterator.hasNext()) {
                char c = ((Character)iterator.next()).charValue();
                int nid = bs + UnifiedIntDoubleArray.this.charToCode[c];
                if (nid < 0 || nid >= UnifiedIntDoubleArray.this.getBaseAndCheckLength() || UnifiedIntDoubleArray.this.getCheck(nid) != nodeId) continue;
                b.append(c);
            }
            return b;
        }

        private DoubleArrayNode[] listupChildNodes(int base, CharSequence chars) {
            int n = chars.length();
            DoubleArrayNode[] ret = new DoubleArrayNode[n];
            for (int i = 0; i < n; ++i) {
                char c = chars.charAt(i);
                char code = UnifiedIntDoubleArray.this.charToCode[c];
                ret[i] = UnifiedIntDoubleArray.this.newDoubleArrayNode(base + code, c);
            }
            return ret;
        }
    }

    public static interface TermNodeListener {
        public void listen(Node var1, int var2);
    }
}

