/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.util.Map;
import org.omegat.core.machinetranslators.AbstractMyMemoryTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;

public final class MyMemoryHumanTranslate
extends AbstractMyMemoryTranslate {
    @Override
    protected String getPreferenceName() {
        return "allow_mymemory_human_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_MYMEMORY_HUMAN");
    }

    @Override
    protected boolean includeMT() {
        return false;
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        Map<String, Object> jsonResponse;
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        try {
            jsonResponse = this.getMyMemoryResponse(sLang, tLang, text);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
        String translation = "";
        try {
            Map dataNode = (Map)jsonResponse.get("responseData");
            translation = dataNode.get("translatedText").toString();
        }
        catch (NullPointerException e) {
            return null;
        }
        this.putToCache(sLang, tLang, text, translation);
        return translation;
    }
}

