/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.model.vocabulary;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Vocabulary {
    public static final int NULL_WID = 0;
    public static final String NULL_WORD = "{NULL}";
    private List<String> wordArray = new ArrayList<String>();
    private Map<String, Integer> wordMap = new HashMap<String, Integer>();

    public Vocabulary() {
        this.putWord(NULL_WORD);
    }

    public Vocabulary(Collection<String> wordCollection) {
        this();
        for (String word : wordCollection) {
            this.putWord(word);
        }
    }

    public Integer getWid(String word) {
        Integer wid = this.wordMap.get(word);
        return wid;
    }

    public List<Integer> getWidList(List<String> wordList) {
        ArrayList<Integer> widList = new ArrayList<Integer>();
        for (String word : wordList) {
            widList.add(this.getWid(word));
        }
        return widList;
    }

    public boolean containsWid(int wid) {
        return wid >= 0 && wid < this.wordArray.size();
    }

    public String getWord(int wid) {
        if (wid < this.wordArray.size()) {
            return this.wordArray.get(wid);
        }
        return null;
    }

    public boolean containsWord(String word) {
        return this.wordMap.containsKey(word);
    }

    public int putWord(String word) {
        Integer wid = this.wordMap.get(word);
        if (wid == null) {
            wid = this.wordArray.size();
            this.wordArray.add(word);
            this.wordMap.put(word, wid);
        }
        return wid;
    }

    public void putWordList(List<String> wordList) {
        for (String word : wordList) {
            this.putWord(word);
        }
    }

    public int getWordCount() {
        return this.wordArray.size() - 1;
    }

    public void format(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        for (int i = 0; i < this.wordArray.size(); ++i) {
            printWriter.println(i + "\t" + this.wordArray.get(i));
        }
    }
}

