/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.stat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.omegat.core.Core;
import org.omegat.gui.stat.BaseStatisticsPanel;
import org.omegat.gui.stat.StatisticsWindow;
import org.omegat.gui.stat.TitledTablePanel;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DataTableStyling;

public class StatisticsPanel
extends BaseStatisticsPanel {
    public StatisticsPanel(StatisticsWindow window) {
        super(window);
        this.setLayout(new BorderLayout());
    }

    @Override
    public void appendTable(String title, String[] headers, String[][] data) {
    }

    @Override
    public void appendTextData(String result) {
    }

    @Override
    public void setTable(String[] headers, String[][] data) {
    }

    public void setProjectTableData(final String[] headers, final String[][] projectData) {
        if (headers == null || headers.length == 0) {
            return;
        }
        if (projectData == null || projectData.length == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = OStrings.getString("CT_STATS_Project_Statistics");
                StatisticsPanel.this.add((Component)StatisticsPanel.this.generateTableDisplay(title, headers, projectData), "North");
            }
        });
    }

    public void setFilesTableData(String[] headers, String[][] filesData) {
        if (headers == null || headers.length == 0) {
            return;
        }
        if (filesData == null || filesData.length == 0) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            String title = OStrings.getString("CT_STATS_FILE_Statistics");
            final TitledTablePanel panel = this.generateTableDisplay(title, headers, filesData);
            TableModel dataModel = panel.table.getModel();
            TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(dataModel);
            Comparator intComparator = (s1, s2) -> {
                try {
                    return Integer.compare(Integer.parseInt(s1), Integer.parseInt(s2));
                }
                catch (NumberFormatException e) {
                    return s1.compareTo((String)s2);
                }
            };
            for (int i = 0; i < dataModel.getColumnCount(); ++i) {
                rowSorter.setComparator(i, intComparator);
            }
            panel.table.setRowSorter(rowSorter);
            panel.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        try {
                            int row = panel.table.rowAtPoint(e.getPoint());
                            int fileIndex = panel.table.convertRowIndexToModel(row);
                            StatisticsPanel.this.gotoFile(fileIndex);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
            });
            panel.table.getColumnModel().getColumn(0).setCellRenderer(DataTableStyling.getTextCellRenderer());
            this.add((Component)panel, "Center");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoFile(int fileIndex) {
        if (!Core.getProject().isProjectLoaded()) {
            return;
        }
        Cursor hourglassCursor = Cursor.getPredefinedCursor(3);
        Cursor oldCursor = this.getCursor();
        this.setCursor(hourglassCursor);
        try {
            Core.getEditor().gotoFile(fileIndex);
            Core.getEditor().requestFocus();
        }
        finally {
            this.setCursor(oldCursor);
        }
    }
}

