/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.issues;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.tagvalidation.ErrorReport;
import org.omegat.core.tagvalidation.TagValidationTool;
import org.omegat.gui.issues.IIssue;
import org.omegat.gui.issues.SimpleColorIcon;
import org.omegat.gui.issues.TripleSplitButtonPanel;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.gui.CharacterWrapEditorKit;
import org.omegat.util.gui.Styles;
import org.openide.awt.Mnemonics;

public class TagIssue
implements IIssue {
    private static final Icon ICON = new SimpleColorIcon(Styles.EditorColor.COLOR_PLACEHOLDER.getColor());
    private final ErrorReport report;

    public TagIssue(ErrorReport report) {
        this.report = report;
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getTypeName() {
        return OStrings.getString("ISSUES_TAGS_TYPE");
    }

    @Override
    public int getSegmentNumber() {
        return this.report.entryNum;
    }

    @Override
    public String getDescription() {
        Map freq = Stream.of(this.report.srcErrors, this.report.transErrors).flatMap(m -> m.values().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return "<html>" + freq.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> {
            ErrorReport.TagError error = (ErrorReport.TagError)((Object)((Object)e.getKey()));
            String message = ErrorReport.localizedTagError((ErrorReport.TagError)((Object)((Object)e.getKey())));
            String html = TagIssue.colorizeByHTML(message, error);
            return StringUtil.format(OStrings.getString("ISSUES_TAGS_ERROR_TEMPLATE"), html, e.getValue());
        }).collect(Collectors.joining(OStrings.getString("ISSUES_TAGS_ERROR_DELIMITER"))) + "</html>";
    }

    @Override
    public Component getDetailComponent() {
        TripleSplitButtonPanel panel = new TripleSplitButtonPanel();
        panel.firstTextPane.setEditorKit(new CharacterWrapEditorKit());
        panel.middleTextPane.setEditorKit(new CharacterWrapEditorKit());
        panel.lastTextPane.setEditorKit(new CharacterWrapEditorKit());
        panel.firstButton.setBorderPainted(false);
        panel.middleButton.setBorderPainted(false);
        try {
            this.insertText(panel.firstTextPane.getStyledDocument(), this.report.source, this.report.srcErrors);
            this.insertText(panel.middleTextPane.getStyledDocument(), this.report.translation, this.report.transErrors);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int minHeight = panel.firstTextPane.getFont().getSize() * 6;
        String fixText = TagValidationTool.fixErrors(this.report);
        if (fixText == null) {
            panel.lastPanel.setVisible(false);
            panel.firstButton.setVisible(false);
            panel.middleButton.setVisible(false);
        } else {
            panel.lastTextPane.setText(fixText);
            Mnemonics.setLocalizedText((AbstractButton)panel.lastButton, (String)OStrings.getString("ISSUES_TAGS_BUTTON_APPLY_FIX"));
            panel.lastButton.addActionListener(this.getFixActionListener(fixText));
            minHeight += panel.lastButton.getPreferredSize().height;
        }
        panel.setMinimumSize(new Dimension(0, minHeight));
        return panel;
    }

    private void insertText(StyledDocument doc, String text, Map<TagUtil.Tag, ErrorReport.TagError> errors) throws BadLocationException {
        doc.insertString(0, text, null);
        for (Map.Entry<TagUtil.Tag, ErrorReport.TagError> e : errors.entrySet()) {
            TagUtil.Tag tag = e.getKey();
            doc.setCharacterAttributes(tag.pos, tag.tag.length(), TagIssue.styleForError(e.getValue()), false);
        }
    }

    @Override
    public boolean hasMenuComponents() {
        return true;
    }

    @Override
    public List<? extends JMenuItem> getMenuComponents() {
        String fixText = TagValidationTool.fixErrors(this.report);
        if (fixText == null) {
            return Collections.emptyList();
        }
        JMenuItem doFix = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)doFix, (String)OStrings.getString("ISSUES_TAGS_BUTTON_APPLY_FIX"));
        doFix.addActionListener(this.getFixActionListener(fixText));
        return Collections.singletonList(doFix);
    }

    private ActionListener getFixActionListener(String fixText) {
        return e -> {
            if (!TagIssue.doFix(this.report, fixText)) {
                JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TAG_FIX_ERROR_MESSAGE"), OStrings.getString("TAG_FIX_ERROR_TITLE"), 0);
            }
        };
    }

    public static AttributeSet styleForError(ErrorReport.TagError error) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setBold(attr, true);
        switch (error) {
            case EXTRANEOUS: {
                StyleConstants.setStrikeThrough(attr, true);
            }
            case MISSING: 
            case MALFORMED: 
            case WHITESPACE: {
                StyleConstants.setForeground(attr, Color.RED);
                break;
            }
            case DUPLICATE: {
                StyleConstants.setForeground(attr, Color.decode("#800080"));
                break;
            }
            case ORPHANED: {
                StyleConstants.setUnderline(attr, true);
            }
            case ORDER: {
                StyleConstants.setForeground(attr, Color.decode("#FF8C00"));
                break;
            }
            case UNSPECIFIED: {
                StyleConstants.setForeground(attr, Color.BLUE);
            }
        }
        return attr;
    }

    private static boolean doFix(ErrorReport report, String fixed) {
        TMXEntry prevTrans = Core.getProject().getTranslationInfo(report.ste);
        if (!report.translation.equals(prevTrans.translation)) {
            return false;
        }
        Core.getEditor().gotoEntry(report.entryNum);
        Core.getEditor().replaceEditTextAndMark(fixed);
        return true;
    }

    public static String colorizeByHTML(String text, ErrorReport.TagError error) {
        String color = "black";
        switch (error) {
            case EXTRANEOUS: {
                text = "<strike>" + text + "</strike>";
            }
            case MISSING: 
            case MALFORMED: 
            case WHITESPACE: {
                color = "red";
                break;
            }
            case DUPLICATE: {
                color = "purple";
                break;
            }
            case ORPHANED: {
                text = "<u>" + text + "</u>";
            }
            case ORDER: {
                color = "#FF8C00";
                break;
            }
            case UNSPECIFIED: {
                color = "blue";
            }
        }
        return "<font color=\"" + color + "\"><b>" + text + "</b></font>";
    }
}

