/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.util.gui.FontFallbackManager;

public class FontFallbackMarker
implements IMarker {
    private Font editorFont = Core.getMainWindow().getApplicationFont();

    public FontFallbackMarker() {
        CoreEvents.registerFontChangedEventListener(newFont -> {
            this.editorFont = newFont;
            Core.getEditor().remarkOneMarker(this.getClass().getName());
        });
    }

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        int trgGlyphMissing;
        if (!this.isEnabled()) {
            return null;
        }
        int srcGlyphMissing = sourceText == null ? -1 : this.editorFont.canDisplayUpTo(sourceText);
        int n = trgGlyphMissing = translationText == null ? -1 : this.editorFont.canDisplayUpTo(translationText);
        if (srcGlyphMissing == -1 && trgGlyphMissing == -1) {
            return null;
        }
        ArrayList<Mark> marks = new ArrayList<Mark>();
        if (srcGlyphMissing != -1) {
            this.createMarks(marks, Mark.ENTRY_PART.SOURCE, sourceText, srcGlyphMissing);
        }
        if (trgGlyphMissing != -1) {
            this.createMarks(marks, Mark.ENTRY_PART.TRANSLATION, translationText, trgGlyphMissing);
        }
        return marks;
    }

    private boolean isEnabled() {
        return Core.getEditor().getSettings().isDoFontFallback();
    }

    private void createMarks(List<Mark> acc, Mark.ENTRY_PART part, String text, int firstMissing) {
        char[] chars = text.toCharArray();
        int i = firstMissing;
        while ((i = this.editorFont.canDisplayUpTo(chars, i, chars.length)) != -1) {
            int ccn;
            int cp = Character.codePointAt(chars, i);
            int start = i;
            i += Character.charCount(cp);
            Font font = FontFallbackManager.getCapableFont(cp);
            if (font == null) continue;
            for (int j = i; j < chars.length; j += ccn) {
                int cpn = Character.codePointAt(chars, j);
                ccn = Character.charCount(cpn);
                if (this.editorFont.canDisplay(cpn) || !font.canDisplay(cpn)) break;
                i += ccn;
            }
            Mark m = new Mark(part, start, i);
            m.attributes = this.getAttributes(font);
            acc.add(m);
        }
    }

    private AttributeSet getAttributes(Font font) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, this.editorFont.getSize());
        return attrs;
    }
}

