/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.impl;

import gen.core.project.RepositoryDefinition;
import gen.core.project.RepositoryMapping;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Formatter;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.ProjectTeamSettings;
import org.omegat.util.Log;

public class HTTPRemoteRepository
implements IRemoteRepository2 {
    private static final Logger LOGGER = Logger.getLogger(HTTPRemoteRepository.class.getName());
    private RepositoryDefinition config;
    private File baseDirectory;

    @Override
    public void init(RepositoryDefinition repo, File dir, ProjectTeamSettings teamSettings) throws Exception {
        Log.logDebug(LOGGER, "Initialize HTTP remote repository", new Object[0]);
        this.config = repo;
        this.baseDirectory = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFileVersion(String file) throws Exception {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        sha1.reset();
        byte[] buffer = new byte[8192];
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            int len;
            while ((len = ((InputStream)in).read(buffer)) >= 0) {
                sha1.update(buffer, 0, len);
            }
        }
        try (Formatter formatter = new Formatter();){
            for (byte b : sha1.digest()) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    @Override
    public void switchToVersion(String version) throws Exception {
        if (version != null) {
            throw new RuntimeException("Not supported");
        }
        Log.logDebug(LOGGER, "Update to latest", new Object[0]);
        Properties etags = this.loadETags();
        for (RepositoryMapping m : this.config.getMapping()) {
            String url = this.config.getUrl() + m.getRepository();
            File out = new File(this.baseDirectory, m.getRepository());
            this.retrieve(etags, m.getRepository(), url, out);
        }
        this.saveETags(etags);
    }

    @Override
    public void addForCommit(String path) throws Exception {
        Log.logDebug(LOGGER, String.format("Cannot add files for commit for HTTP repositories. Skipping \"%s\".", path), new Object[0]);
    }

    @Override
    public void addForDeletion(String path) throws Exception {
        Log.logDebug(LOGGER, String.format("Cannot add files for deletion for HTTP repositories. Skipping \"%s\".", path), new Object[0]);
    }

    @Override
    public File getLocalDirectory() {
        return this.baseDirectory;
    }

    @Override
    public String commit(String[] onVersions, String comment) throws Exception {
        Log.logDebug(LOGGER, "Commit not supported for HTTP repositories.", new Object[0]);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadETags() throws Exception {
        Properties props = new Properties();
        File f = new File(this.baseDirectory, ".etags");
        if (f.exists()) {
            try (FileInputStream in = new FileInputStream(f);){
                props.load(in);
            }
        }
        return props;
    }

    protected void saveETags(Properties props) throws Exception {
        try (FileOutputStream out = new FileOutputStream(new File(this.baseDirectory, ".etags"));){
            props.store(out, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieve(Properties etags, String file, String url, File out) throws Exception {
        String etag = etags.getProperty(file);
        Log.logDebug(LOGGER, "Retrieve " + url + " into " + out.getAbsolutePath() + " with ETag=" + etag, new Object[0]);
        out.getParentFile().mkdirs();
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        try {
            if (etag != null) {
                conn.setRequestProperty("If-None-Match", etag);
            }
            switch (conn.getResponseCode()) {
                case 200: {
                    etag = conn.getHeaderField("ETag");
                    Log.logDebug(LOGGER, "Retrieve " + url + ": 200 with ETag=" + etag, new Object[0]);
                    break;
                }
                case 304: {
                    Log.logDebug(LOGGER, "Retrieve " + url + ": not modified", new Object[0]);
                    return;
                }
                default: {
                    throw new RuntimeException("HTTP response code: " + conn.getResponseCode());
                }
            }
            File temp = new File(out.getAbsolutePath() + ".tmp");
            try (InputStream in = conn.getInputStream();){
                FileUtils.copyInputStreamToFile(in, temp);
            }
            if (out.exists() && !out.delete()) {
                throw new IOException();
            }
            if (!temp.renameTo(out)) {
                throw new IOException();
            }
            try {
                etags.setProperty(file, etag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (SocketException | UnknownHostException e) {
            throw new IRemoteRepository2.NetworkException(e);
        }
        finally {
            conn.disconnect();
        }
        Log.logDebug(LOGGER, "Retrieve " + url + " finished", new Object[0]);
    }
}

