/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class WhitespaceBeforePunctuationRule
extends Rule {
    public WhitespaceBeforePunctuationRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
    }

    @Override
    public final String getId() {
        return "WHITESPACE_PUNCTUATION";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_whitespace_before_punctuation");
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        boolean prevWhite = false;
        int prevLen = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            boolean isWhitespace = tokens[i].isWhitespace() || StringTools.isNonBreakingWhitespace(token) || tokens[i].isFieldCode();
            String msg = null;
            String suggestionText = null;
            if (prevWhite) {
                String prevPrevToken;
                if (token.equals(":")) {
                    msg = this.messages.getString("no_space_before_colon");
                    suggestionText = ":";
                    if (i + 2 < tokens.length && tokens[i + 1].isWhitespace() && Character.isDigit(tokens[i + 2].getToken().charAt(0))) {
                        msg = null;
                    }
                } else if (token.equals(";")) {
                    msg = this.messages.getString("no_space_before_semicolon");
                    suggestionText = ";";
                } else if (i > 1 && token.equals("%") && (prevPrevToken = tokens[i - 2].getToken()).length() > 0 && Character.isDigit(prevPrevToken.charAt(0))) {
                    msg = this.messages.getString("no_space_before_percentage");
                    suggestionText = "%";
                }
            }
            if (msg != null) {
                int fromPos = tokens[i - 1].getStartPos();
                int toPos = tokens[i - 1].getStartPos() + 1 + prevLen;
                RuleMatch ruleMatch = new RuleMatch(this, fromPos, toPos, msg);
                ruleMatch.setSuggestedReplacement(suggestionText);
                ruleMatches.add(ruleMatch);
            }
            prevWhite = isWhitespace && !tokens[i].isFieldCode();
            prevLen = tokens[i].getToken().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

