/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.mozdtd;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.mozdtd.MozillaDTDOptionsDialog;
import org.omegat.util.Log;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class MozillaDTDFilter
extends AbstractFilter {
    public static final String OPTION_REMOVE_STRINGS_UNTRANSLATED = "unremoveStringsUntranslated";
    protected static final Pattern RE_ENTITY = Pattern.compile("<\\!ENTITY\\s+(\\S+)\\s+([\"'])(.+)\\2\\s*>", 32);
    protected Map<String, String> align;
    public static boolean removeStringsUntranslated = false;

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.dtd")};
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("MOZDTD_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    protected BufferedReader createReader(File inFile, String inEncoding) throws UnsupportedEncodingException, IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), StandardCharsets.UTF_8));
    }

    @Override
    protected BufferedWriter createWriter(File outFile, String outEncoding) throws UnsupportedEncodingException, IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), StandardCharsets.UTF_8));
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        int c;
        String removeStringsUntranslatedStr = (String)this.processOptions.get(OPTION_REMOVE_STRINGS_UNTRANSLATED);
        removeStringsUntranslated = removeStringsUntranslatedStr != null && removeStringsUntranslatedStr.equalsIgnoreCase("true");
        StringBuilder block = new StringBuilder();
        boolean isInBlock = false;
        boolean foundQuotes = false;
        int quotes = 34;
        int previousChar = 0;
        while ((c = inFile.read()) != -1) {
            if (c == 60 && !isInBlock) {
                isInBlock = true;
            }
            if (isInBlock) {
                block.append((char)c);
            } else {
                outFile.write(c);
            }
            if (!(foundQuotes || c != 34 && c != 39)) {
                foundQuotes = true;
                quotes = c;
            }
            if (c == 62 && isInBlock && previousChar == quotes) {
                isInBlock = false;
                foundQuotes = false;
                this.processBlock(block.toString(), outFile);
                block.setLength(0);
            } else if (c == 62 && isInBlock && previousChar == 45) {
                isInBlock = false;
                foundQuotes = false;
                outFile.write(block.toString());
                block.setLength(0);
            }
            if (Character.isWhitespace(c)) continue;
            previousChar = c;
        }
    }

    protected void processBlock(String block, BufferedWriter out) throws IOException {
        Matcher m = RE_ENTITY.matcher(block);
        if (!m.matches()) {
            out.write(block);
            return;
        }
        String id = m.group(1);
        String text = m.group(3);
        if (this.entryParseCallback != null) {
            this.entryParseCallback.addEntry(id, text, null, false, null, null, this, null);
        } else if (this.entryTranslateCallback != null) {
            String trans = this.entryTranslateCallback.getTranslation(id, text, null);
            if (trans != null || !removeStringsUntranslated) {
                out.write(block.substring(0, m.start(3)));
                out.write(trans != null ? trans : text);
                out.write(block.substring(m.end(3)));
            }
        } else if (this.entryAlignCallback != null && id != null) {
            this.align.put(id, text);
        }
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    @Override
    public String getInEncodingLastParsedFile() {
        return StandardCharsets.UTF_8.name();
    }

    @Override
    public Map<String, String> changeOptions(Window parent, Map<String, String> config) {
        try {
            MozillaDTDOptionsDialog dialog = new MozillaDTDOptionsDialog(parent, config);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions();
            }
            return null;
        }
        catch (Exception e) {
            Log.log(OStrings.getString("MOZDTD_FILTER_EXCEPTION"));
            Log.log(e);
            return null;
        }
    }

    @Override
    public boolean hasOptions() {
        return true;
    }
}

