/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsReader
extends StoredFieldsReader {
    private final int version;
    private final FieldInfos fieldInfos;
    private final CompressingStoredFieldsIndexReader indexReader;
    private final long maxPointer;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final Decompressor decompressor;
    private final int numDocs;
    private final boolean merging;
    private final BlockState state;
    private final long numChunks;
    private final long numDirtyChunks;
    private boolean closed;

    private CompressingStoredFieldsReader(CompressingStoredFieldsReader reader, boolean merging) {
        this.version = reader.version;
        this.fieldInfos = reader.fieldInfos;
        this.fieldsStream = reader.fieldsStream.clone();
        this.indexReader = reader.indexReader.clone();
        this.maxPointer = reader.maxPointer;
        this.chunkSize = reader.chunkSize;
        this.packedIntsVersion = reader.packedIntsVersion;
        this.compressionMode = reader.compressionMode;
        this.decompressor = reader.decompressor.clone();
        this.numDocs = reader.numDocs;
        this.numChunks = reader.numChunks;
        this.numDirtyChunks = reader.numDirtyChunks;
        this.merging = merging;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompressingStoredFieldsReader(Directory d, SegmentInfo si, String segmentSuffix, FieldInfos fn, IOContext context, String formatName, CompressionMode compressionMode) throws IOException {
        CompressingStoredFieldsIndexReader indexReader;
        long maxPointer;
        int version;
        boolean success;
        String segment;
        block25: {
            this.compressionMode = compressionMode;
            segment = si.name;
            success = false;
            this.fieldInfos = fn;
            this.numDocs = si.maxDoc();
            version = -1;
            maxPointer = -1L;
            indexReader = null;
            String indexName = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdx");
            try (ChecksumIndexInput indexStream = d.openChecksumInput(indexName, context);){
                Throwable priorE = null;
                try {
                    String codecNameIdx = formatName + "Index";
                    version = CodecUtil.checkIndexHeader(indexStream, codecNameIdx, 0, 1, si.getId(), segmentSuffix);
                    assert ((long)CodecUtil.indexHeaderLength(codecNameIdx, segmentSuffix) == indexStream.getFilePointer());
                    indexReader = new CompressingStoredFieldsIndexReader(indexStream, si);
                    maxPointer = indexStream.readVLong();
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block25;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(indexStream, priorE);
                    }
                }
                CodecUtil.checkFooter(indexStream, priorE);
            }
        }
        this.version = version;
        this.maxPointer = maxPointer;
        this.indexReader = indexReader;
        String fieldsStreamFN = IndexFileNames.segmentFileName(segment, segmentSuffix, "fdt");
        try {
            this.fieldsStream = d.openInput(fieldsStreamFN, context);
            String codecNameDat = formatName + "Data";
            int fieldsVersion = CodecUtil.checkIndexHeader(this.fieldsStream, codecNameDat, 0, 1, si.getId(), segmentSuffix);
            if (version != fieldsVersion) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + version + " != " + fieldsVersion, this.fieldsStream);
            }
            assert ((long)CodecUtil.indexHeaderLength(codecNameDat, segmentSuffix) == this.fieldsStream.getFilePointer());
            this.chunkSize = this.fieldsStream.readVInt();
            this.packedIntsVersion = this.fieldsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.merging = false;
            this.state = new BlockState();
            if (version >= 1) {
                this.fieldsStream.seek(maxPointer);
                this.numChunks = this.fieldsStream.readVLong();
                this.numDirtyChunks = this.fieldsStream.readVLong();
                if (this.numDirtyChunks > this.numChunks) {
                    throw new CorruptIndexException("invalid chunk counts: dirty=" + this.numDirtyChunks + ", total=" + this.numChunks, this.fieldsStream);
                }
            } else {
                this.numDirtyChunks = -1L;
                this.numChunks = -1L;
            }
            CodecUtil.retrieveChecksum(this.fieldsStream);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.fieldsStream);
            this.closed = true;
        }
    }

    private static void readField(DataInput in, StoredFieldVisitor visitor, FieldInfo info, int bits) throws IOException {
        switch (bits & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 1: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.binaryField(info, data);
                break;
            }
            case 0: {
                int length = in.readVInt();
                byte[] data = new byte[length];
                in.readBytes(data, 0, length);
                visitor.stringField(info, data);
                break;
            }
            case 2: {
                visitor.intField(info, in.readZInt());
                break;
            }
            case 3: {
                visitor.floatField(info, CompressingStoredFieldsReader.readZFloat(in));
                break;
            }
            case 4: {
                visitor.longField(info, CompressingStoredFieldsReader.readTLong(in));
                break;
            }
            case 5: {
                visitor.doubleField(info, CompressingStoredFieldsReader.readZDouble(in));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    private static void skipField(DataInput in, int bits) throws IOException {
        switch (bits & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 0: 
            case 1: {
                int length = in.readVInt();
                in.skipBytes(length);
                break;
            }
            case 2: {
                in.readZInt();
                break;
            }
            case 3: {
                CompressingStoredFieldsReader.readZFloat(in);
                break;
            }
            case 4: {
                CompressingStoredFieldsReader.readTLong(in);
                break;
            }
            case 5: {
                CompressingStoredFieldsReader.readZDouble(in);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(bits)));
            }
        }
    }

    static float readZFloat(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        int bits = b << 24 | (in.readShort() & 0xFFFF) << 8 | in.readByte() & 0xFF;
        return Float.intBitsToFloat(bits);
    }

    static double readZDouble(DataInput in) throws IOException {
        int b = in.readByte() & 0xFF;
        if (b == 255) {
            return Double.longBitsToDouble(in.readLong());
        }
        if (b == 254) {
            return Float.intBitsToFloat(in.readInt());
        }
        if ((b & 0x80) != 0) {
            return (b & 0x7F) - 1;
        }
        long bits = (long)b << 56 | ((long)in.readInt() & 0xFFFFFFFFL) << 24 | ((long)in.readShort() & 0xFFFFL) << 8 | (long)in.readByte() & 0xFFL;
        return Double.longBitsToDouble(bits);
    }

    static long readTLong(DataInput in) throws IOException {
        int header = in.readByte() & 0xFF;
        long bits = header & 0x1F;
        if ((header & 0x20) != 0) {
            bits |= in.readVLong() << 5;
        }
        long l = BitUtil.zigZagDecode(bits);
        switch (header & 0xC0) {
            case 64: {
                l *= 1000L;
                break;
            }
            case 128: {
                l *= 3600000L;
                break;
            }
            case 192: {
                l *= 86400000L;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return l;
    }

    SerializedDocument document(int docID) throws IOException {
        if (!this.state.contains(docID)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(docID));
            this.state.reset(docID);
        }
        assert (this.state.contains(docID));
        return this.state.document(docID);
    }

    @Override
    public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
        SerializedDocument doc = this.document(docID);
        block5: for (int fieldIDX = 0; fieldIDX < doc.numStoredFields; ++fieldIDX) {
            long infoAndBits = doc.in.readVLong();
            int fieldNumber = (int)(infoAndBits >>> CompressingStoredFieldsWriter.TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            int bits = (int)(infoAndBits & (long)CompressingStoredFieldsWriter.TYPE_MASK);
            assert (bits <= 5) : "bits=" + Integer.toHexString(bits);
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    CompressingStoredFieldsReader.readField(doc.in, visitor, fieldInfo, bits);
                    continue block5;
                }
                case NO: {
                    CompressingStoredFieldsReader.skipField(doc.in, bits);
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    @Override
    public StoredFieldsReader clone() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, false);
    }

    @Override
    public StoredFieldsReader getMergeInstance() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, true);
    }

    int getVersion() {
        return this.version;
    }

    CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    CompressingStoredFieldsIndexReader getIndexReader() {
        return this.indexReader;
    }

    long getMaxPointer() {
        return this.maxPointer;
    }

    IndexInput getFieldsStream() {
        return this.fieldsStream;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    long getNumChunks() {
        return this.numChunks;
    }

    long getNumDirtyChunks() {
        return this.numDirtyChunks;
    }

    int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    @Override
    public long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable("stored field index", this.indexReader));
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.fieldsStream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        private int[] offsets = IntsRef.EMPTY_INTS;
        private int[] numStoredFields = IntsRef.EMPTY_INTS;
        private long startPointer;
        private final BytesRef spare = new BytesRef();
        private final BytesRef bytes = new BytesRef();

        private BlockState() {
        }

        boolean contains(int docID) {
            return docID >= this.docBase && docID < this.docBase + this.chunkDocs;
        }

        void reset(int docID) throws IOException {
            boolean success = false;
            try {
                this.doReset(docID);
                success = true;
            }
            finally {
                if (!success) {
                    this.chunkDocs = 0;
                }
            }
        }

        private void doReset(int docID) throws IOException {
            this.docBase = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int token = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            this.chunkDocs = token >>> 1;
            if (!this.contains(docID) || this.docBase + this.chunkDocs > CompressingStoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: docID=" + docID + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + CompressingStoredFieldsReader.this.numDocs, CompressingStoredFieldsReader.this.fieldsStream);
            }
            this.sliced = (token & 1) != 0;
            this.offsets = ArrayUtil.grow(this.offsets, this.chunkDocs + 1);
            this.numStoredFields = ArrayUtil.grow(this.numStoredFields, this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int i;
                int bitsPerStoredFields = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerStoredFields == 0) {
                    Arrays.fill(this.numStoredFields, 0, this.chunkDocs, CompressingStoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerStoredFields=" + bitsPerStoredFields, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, bitsPerStoredFields, 1);
                    for (int i2 = 0; i2 < this.chunkDocs; ++i2) {
                        this.numStoredFields[i2] = (int)it.next();
                    }
                }
                int bitsPerLength = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (bitsPerLength == 0) {
                    int length = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                    for (i = 0; i < this.chunkDocs; ++i) {
                        this.offsets[1 + i] = (1 + i) * length;
                    }
                } else {
                    if (bitsPerStoredFields > 31) {
                        throw new CorruptIndexException("bitsPerLength=" + bitsPerLength, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.ReaderIterator it = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, bitsPerLength, 1);
                    for (i = 0; i < this.chunkDocs; ++i) {
                        this.offsets[i + 1] = (int)it.next();
                    }
                    for (i = 0; i < this.chunkDocs; ++i) {
                        int n = i + 1;
                        this.offsets[n] = this.offsets[n] + this.offsets[i];
                    }
                }
                for (int i3 = 0; i3 < this.chunkDocs; ++i3) {
                    int storedFields;
                    int len = this.offsets[i3 + 1] - this.offsets[i3];
                    if (len == 0 == ((storedFields = this.numStoredFields[i3]) == 0)) continue;
                    throw new CorruptIndexException("length=" + len + ", numStoredFields=" + storedFields, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
            this.startPointer = CompressingStoredFieldsReader.this.fieldsStream.getFilePointer();
            if (CompressingStoredFieldsReader.this.merging) {
                int totalLength = this.offsets[this.chunkDocs];
                if (this.sliced) {
                    int toDecompress;
                    this.bytes.length = 0;
                    this.bytes.offset = 0;
                    for (int decompressed = 0; decompressed < totalLength; decompressed += toDecompress) {
                        toDecompress = Math.min(totalLength - decompressed, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, this.spare);
                        this.bytes.bytes = ArrayUtil.grow(this.bytes.bytes, this.bytes.length + this.spare.length);
                        System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                        this.bytes.length += this.spare.length;
                    }
                } else {
                    CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, totalLength, 0, totalLength, this.bytes);
                }
                if (this.bytes.length != totalLength) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + totalLength + ", got " + this.bytes.length, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
        }

        SerializedDocument document(int docID) throws IOException {
            DataInput documentInput;
            if (!this.contains(docID)) {
                throw new IllegalArgumentException();
            }
            int index = docID - this.docBase;
            int offset = this.offsets[index];
            final int length = this.offsets[index + 1] - offset;
            int totalLength = this.offsets[this.chunkDocs];
            int numStoredFields = this.numStoredFields[index];
            if (length == 0) {
                documentInput = new ByteArrayDataInput();
            } else if (CompressingStoredFieldsReader.this.merging) {
                documentInput = new ByteArrayDataInput(this.bytes.bytes, this.bytes.offset + offset, length);
            } else if (this.sliced) {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, CompressingStoredFieldsReader.this.chunkSize, offset, Math.min(length, CompressingStoredFieldsReader.this.chunkSize - offset), this.bytes);
                documentInput = new DataInput(){
                    int decompressed;
                    {
                        this.decompressed = ((BlockState)BlockState.this).bytes.length;
                    }

                    void fillBuffer() throws IOException {
                        assert (this.decompressed <= length);
                        if (this.decompressed == length) {
                            throw new EOFException();
                        }
                        int toDecompress = Math.min(length - this.decompressed, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, toDecompress, 0, toDecompress, BlockState.this.bytes);
                        this.decompressed += toDecompress;
                    }

                    @Override
                    public byte readByte() throws IOException {
                        if (((BlockState)BlockState.this).bytes.length == 0) {
                            this.fillBuffer();
                        }
                        --((BlockState)BlockState.this).bytes.length;
                        return ((BlockState)BlockState.this).bytes.bytes[((BlockState)BlockState.this).bytes.offset++];
                    }

                    @Override
                    public void readBytes(byte[] b, int offset, int len) throws IOException {
                        while (len > ((BlockState)BlockState.this).bytes.length) {
                            System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, b, offset, ((BlockState)BlockState.this).bytes.length);
                            len -= ((BlockState)BlockState.this).bytes.length;
                            offset += ((BlockState)BlockState.this).bytes.length;
                            this.fillBuffer();
                        }
                        System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, b, offset, len);
                        ((BlockState)BlockState.this).bytes.offset += len;
                        ((BlockState)BlockState.this).bytes.length -= len;
                    }
                };
            } else {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, totalLength, offset, length, this.bytes);
                assert (this.bytes.length == length);
                documentInput = new ByteArrayDataInput(this.bytes.bytes, this.bytes.offset, this.bytes.length);
            }
            return new SerializedDocument(documentInput, length, numStoredFields);
        }
    }

    static class SerializedDocument {
        final DataInput in;
        final int length;
        final int numStoredFields;

        private SerializedDocument(DataInput in, int length, int numStoredFields) {
            this.in = in;
            this.length = length;
            this.numStoredFields = numStoredFields;
        }
    }
}

