/*
 * Decompiled with CFR 0.152.
 */
package org.ioperm.morphology.el;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import morfologik.stemming.WordData;

public class Lemma {
    private final String wordForm;
    private final String lemma;
    private final String tag;
    private final Set<String> attributes = new LinkedHashSet<String>();

    Lemma(String wordForm, String lemma, String tag) {
        this.wordForm = wordForm;
        this.lemma = lemma;
        this.tag = tag;
        this.attributes.addAll(Arrays.asList(tag.split("\\:")));
    }

    Lemma(WordData w) {
        this.wordForm = w.getWord() == null ? null : w.getWord().toString();
        this.lemma = w.getStem() == null ? null : w.getStem().toString();
        String string = this.tag = w.getTag() == null ? null : w.getTag().toString();
        if (w.getTag() != null) {
            this.attributes.addAll(Arrays.asList(w.getTag().toString().split("\\:")));
        }
    }

    public String getWordForm() {
        return this.wordForm;
    }

    public String getLemma() {
        return this.lemma;
    }

    public String getTag() {
        return this.tag;
    }

    public Set<String> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.wordForm);
        hash = 79 * hash + Objects.hashCode(this.lemma);
        hash = 79 * hash + Objects.hashCode(this.attributes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Lemma other = (Lemma)obj;
        if (!Objects.equals(this.wordForm, other.wordForm)) {
            return false;
        }
        if (!Objects.equals(this.lemma, other.lemma)) {
            return false;
        }
        return Objects.equals(this.tag, other.tag);
    }
}

