/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public final class FileTools {
    private FileTools() {
    }

    public static Set<String> loadFileToSet(InputStream is, String charset) throws IOException {
        HashSet<String> words = new HashSet<String>();
        try (InputStreamReader isr = new InputStreamReader(is, charset);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                words.add(line.trim().toLowerCase());
            }
        }
        return words;
    }

    public static String loadFile(InputStream inputStream, String charset) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(inputStream, charset);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

