/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.Map;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;

public class TrainUtil {
    public static boolean isValid(Map<String, String> trainParams) {
        return TrainerFactory.isValid(trainParams);
    }

    public static MaxentModel train(ObjectStream<Event> events, Map<String, String> trainParams, Map<String, String> reportMap) throws IOException {
        if (!TrainerFactory.isSupportEvent(trainParams)) {
            throw new IllegalArgumentException("EventTrain is not supported");
        }
        EventTrainer trainer = TrainerFactory.getEventTrainer(trainParams, reportMap);
        return trainer.train(events);
    }

    public static boolean isSequenceTraining(Map<String, String> trainParams) {
        return TrainerFactory.isSupportSequence(trainParams);
    }

    public static MaxentModel train(SequenceStream events, Map<String, String> trainParams, Map<String, String> reportMap) throws IOException {
        if (!TrainerFactory.isSupportSequence(trainParams)) {
            throw new IllegalArgumentException("EventTrain is not supported");
        }
        EventModelSequenceTrainer trainer = TrainerFactory.getEventModelSequenceTrainer(trainParams, reportMap);
        return trainer.train(events);
    }
}

