/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.codecs.blocktree.IntersectTermsEnumFrame;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.RunAutomaton;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;

final class IntersectTermsEnum
extends TermsEnum {
    final IndexInput in;
    static final Outputs<BytesRef> fstOutputs = ByteSequenceOutputs.getSingleton();
    IntersectTermsEnumFrame[] stack;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[5];
    final RunAutomaton runAutomaton;
    final Automaton automaton;
    final BytesRef commonSuffix;
    private IntersectTermsEnumFrame currentFrame;
    private final BytesRef term = new BytesRef();
    private final FST.BytesReader fstReader;
    private final boolean allowAutoPrefixTerms;
    final FieldReader fr;
    private final int sinkState;
    private BytesRef savedStartTerm;
    private boolean useAutoPrefixTerm;
    private final Transition transition = new Transition();

    public IntersectTermsEnum(FieldReader fr, Automaton automaton, RunAutomaton runAutomaton, BytesRef commonSuffix, BytesRef startTerm, int sinkState) throws IOException {
        this.fr = fr;
        this.sinkState = sinkState;
        assert (automaton != null);
        assert (runAutomaton != null);
        this.runAutomaton = runAutomaton;
        this.allowAutoPrefixTerms = sinkState != -1;
        this.automaton = automaton;
        this.commonSuffix = commonSuffix;
        this.in = fr.parent.termsIn.clone();
        this.stack = new IntersectTermsEnumFrame[5];
        for (int idx = 0; idx < this.stack.length; ++idx) {
            this.stack[idx] = new IntersectTermsEnumFrame(this, idx);
        }
        for (int arcIdx = 0; arcIdx < this.arcs.length; ++arcIdx) {
            this.arcs[arcIdx] = new FST.Arc();
        }
        this.fstReader = fr.index == null ? null : fr.index.getBytesReader();
        FST.Arc<BytesRef> arc = fr.index.getFirstArc(this.arcs[0]);
        assert (arc.isFinal());
        IntersectTermsEnumFrame f = this.stack[0];
        f.fp = f.fpOrig = fr.rootBlockFP;
        f.prefix = 0;
        f.setState(runAutomaton.getInitialState());
        f.arc = arc;
        f.outputPrefix = (BytesRef)arc.output;
        f.load(fr.rootCode);
        assert (this.setSavedStartTerm(startTerm));
        this.currentFrame = f;
        if (startTerm != null) {
            this.seekToStartTerm(startTerm);
        }
    }

    private boolean setSavedStartTerm(BytesRef startTerm) {
        this.savedStartTerm = startTerm == null ? null : BytesRef.deepCopyOf(startTerm);
        return true;
    }

    @Override
    public TermState termState() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.clone();
    }

    private IntersectTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            IntersectTermsEnumFrame[] next = new IntersectTermsEnumFrame[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, next, 0, this.stack.length);
            for (int stackOrd = this.stack.length; stackOrd < next.length; ++stackOrd) {
                next[stackOrd] = new IntersectTermsEnumFrame(this, stackOrd);
            }
            this.stack = next;
        }
        assert (this.stack[ord].ord == ord);
        return this.stack[ord];
    }

    private FST.Arc<BytesRef> getArc(int ord) {
        if (ord >= this.arcs.length) {
            FST.Arc[] next = new FST.Arc[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, next, 0, this.arcs.length);
            for (int arcOrd = this.arcs.length; arcOrd < next.length; ++arcOrd) {
                next[arcOrd] = new FST.Arc();
            }
            this.arcs = next;
        }
        return this.arcs[ord];
    }

    private IntersectTermsEnumFrame pushFrame(int state) throws IOException {
        IntersectTermsEnumFrame f = this.getFrame(this.currentFrame == null ? 0 : 1 + this.currentFrame.ord);
        f.fp = f.fpOrig = this.currentFrame.lastSubFP;
        f.prefix = this.currentFrame.prefix + this.currentFrame.suffix;
        f.setState(state);
        FST.Arc<BytesRef> arc = this.currentFrame.arc;
        assert (this.currentFrame.suffix > 0);
        BytesRef output = this.currentFrame.outputPrefix;
        for (int idx = this.currentFrame.prefix; idx < f.prefix; ++idx) {
            int target = this.term.bytes[idx] & 0xFF;
            arc = this.fr.index.findTargetArc(target, arc, this.getArc(1 + idx), this.fstReader);
            assert (arc != null);
            output = fstOutputs.add(output, (BytesRef)arc.output);
        }
        f.arc = arc;
        f.outputPrefix = output;
        assert (arc.isFinal());
        f.load(fstOutputs.add(output, (BytesRef)arc.nextFinalOutput));
        return f;
    }

    @Override
    public BytesRef term() {
        return this.term;
    }

    @Override
    public int docFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.totalTermFreq;
    }

    @Override
    public PostingsEnum postings(Bits skipDocs, PostingsEnum reuse, int flags) throws IOException {
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.termState, skipDocs, reuse, flags);
    }

    private int getState() {
        int state = this.currentFrame.state;
        for (int idx = 0; idx < this.currentFrame.suffix; ++idx) {
            state = this.runAutomaton.step(state, this.currentFrame.suffixBytes[this.currentFrame.startBytePos + idx] & 0xFF);
            assert (state != -1);
        }
        return state;
    }

    private void seekToStartTerm(BytesRef target) throws IOException {
        assert (this.currentFrame.ord == 0);
        if (this.term.length < target.length) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, target.length);
        }
        FST.Arc<BytesRef> arc = this.arcs[0];
        assert (arc == this.currentFrame.arc);
        for (int idx = 0; idx <= target.length; ++idx) {
            block10: {
                boolean saveIsAutoPrefixTerm;
                int saveTermBlockOrd;
                long saveLastSubFP;
                int saveSuffix;
                int saveStartBytePos;
                int savePos;
                int savNextEnt;
                while (true) {
                    savNextEnt = this.currentFrame.nextEnt;
                    savePos = this.currentFrame.suffixesReader.getPosition();
                    saveStartBytePos = this.currentFrame.startBytePos;
                    saveSuffix = this.currentFrame.suffix;
                    saveLastSubFP = this.currentFrame.lastSubFP;
                    saveTermBlockOrd = this.currentFrame.termState.termBlockOrd;
                    saveIsAutoPrefixTerm = this.currentFrame.isAutoPrefixTerm;
                    boolean isSubBlock = this.currentFrame.next();
                    this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                    if (this.term.bytes.length < this.term.length) {
                        this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
                    }
                    System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                    if (isSubBlock && StringHelper.startsWith(target, this.term)) break block10;
                    int cmp = this.term.compareTo(target);
                    if (cmp < 0) {
                        if (this.currentFrame.nextEnt != this.currentFrame.entCount) continue;
                        if (!this.currentFrame.isLastInFloor) {
                            this.currentFrame.loadNextFloorBlock();
                            continue;
                        }
                        return;
                    }
                    if (cmp == 0) {
                        if (!this.allowAutoPrefixTerms && this.currentFrame.isAutoPrefixTerm) continue;
                        return;
                    }
                    if (this.allowAutoPrefixTerms || !this.currentFrame.isAutoPrefixTerm) break;
                }
                this.currentFrame.nextEnt = savNextEnt;
                this.currentFrame.lastSubFP = saveLastSubFP;
                this.currentFrame.startBytePos = saveStartBytePos;
                this.currentFrame.suffix = saveSuffix;
                this.currentFrame.suffixesReader.setPosition(savePos);
                this.currentFrame.termState.termBlockOrd = saveTermBlockOrd;
                this.currentFrame.isAutoPrefixTerm = saveIsAutoPrefixTerm;
                System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                return;
            }
            this.currentFrame = this.pushFrame(this.getState());
        }
        assert (false);
    }

    @Override
    public BytesRef next() throws IOException {
        block0: while (true) {
            boolean isSubBlock;
            block48: {
                if (this.useAutoPrefixTerm) {
                    int i;
                    int suffix;
                    int prefix;
                    assert (this.currentFrame.isAutoPrefixTerm);
                    this.useAutoPrefixTerm = false;
                    this.currentFrame.termState.isRealTerm = true;
                    int floorSuffixLeadEnd = this.currentFrame.floorSuffixLeadEnd;
                    if (floorSuffixLeadEnd == -1) {
                        prefix = this.currentFrame.prefix;
                        suffix = this.currentFrame.suffix;
                        if (suffix == 0) {
                            if (this.currentFrame.ord == 0) {
                                return null;
                            }
                            this.currentFrame = this.stack[this.currentFrame.ord - 1];
                            continue;
                        }
                        block1: while (true) {
                            if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                                if (!this.currentFrame.isLastInFloor) {
                                    this.currentFrame.loadNextFloorBlock();
                                } else {
                                    if (this.currentFrame.ord == 0) {
                                        return null;
                                    }
                                    this.currentFrame = this.stack[this.currentFrame.ord - 1];
                                    continue block0;
                                }
                            }
                            isSubBlock = this.currentFrame.next();
                            i = 0;
                            while (true) {
                                if (i >= suffix) continue block1;
                                if (this.term.bytes[prefix + i] == this.currentFrame.suffixBytes[this.currentFrame.startBytePos + i]) {
                                    ++i;
                                    continue;
                                }
                                break block48;
                                break;
                            }
                            break;
                        }
                    }
                    prefix = this.currentFrame.prefix;
                    suffix = this.currentFrame.suffix;
                    if (this.currentFrame.floorSuffixLeadStart == -1) {
                        ++suffix;
                    }
                    if (suffix == 0) {
                        if (this.currentFrame.ord == 0) {
                            return null;
                        }
                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                        prefix = this.currentFrame.prefix;
                        suffix = this.term.length - this.currentFrame.prefix;
                    }
                    do {
                        if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                            if (!this.currentFrame.isLastInFloor) {
                                this.currentFrame.loadNextFloorBlock();
                            } else {
                                if (this.currentFrame.ord == 0) {
                                    return null;
                                }
                                this.currentFrame = this.stack[this.currentFrame.ord - 1];
                                continue block0;
                            }
                        }
                        isSubBlock = this.currentFrame.next();
                        for (i = 0; i < suffix - 1; ++i) {
                            if (this.term.bytes[prefix + i] == this.currentFrame.suffixBytes[this.currentFrame.startBytePos + i]) {
                                continue;
                            }
                            break block48;
                        }
                    } while (this.currentFrame.suffix < suffix || (this.currentFrame.suffixBytes[this.currentFrame.startBytePos + suffix - 1] & 0xFF) <= floorSuffixLeadEnd);
                } else {
                    while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                        if (!this.currentFrame.isLastInFloor) {
                            this.currentFrame.loadNextFloorBlock();
                            break;
                        }
                        if (this.currentFrame.ord == 0) {
                            return null;
                        }
                        long lastFP = this.currentFrame.fpOrig;
                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                        assert (this.currentFrame.lastSubFP == lastFP);
                    }
                    isSubBlock = this.currentFrame.next();
                }
            }
            if (this.currentFrame.suffix != 0) {
                int label = this.currentFrame.suffixBytes[this.currentFrame.startBytePos] & 0xFF;
                while (label > this.currentFrame.curTransitionMax) {
                    if (this.currentFrame.transitionIndex >= this.currentFrame.transitionCount - 1) {
                        if (this.currentFrame.ord == 0) {
                            return null;
                        }
                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                        continue block0;
                    }
                    ++this.currentFrame.transitionIndex;
                    this.automaton.getNextTransition(this.currentFrame.transition);
                    this.currentFrame.curTransitionMax = this.currentFrame.transition.max;
                }
            }
            if (this.commonSuffix != null && !isSubBlock) {
                int suffixBytesPos;
                int termLen = this.currentFrame.prefix + this.currentFrame.suffix;
                if (termLen < this.commonSuffix.length) continue;
                byte[] suffixBytes = this.currentFrame.suffixBytes;
                byte[] commonSuffixBytes = this.commonSuffix.bytes;
                int lenInPrefix = this.commonSuffix.length - this.currentFrame.suffix;
                assert (this.commonSuffix.offset == 0);
                int commonSuffixBytesPos = 0;
                if (lenInPrefix > 0) {
                    byte[] termBytes = this.term.bytes;
                    int termBytesPos = this.currentFrame.prefix - lenInPrefix;
                    assert (termBytesPos >= 0);
                    int termBytesPosEnd = this.currentFrame.prefix;
                    while (termBytesPos < termBytesPosEnd) {
                        if (termBytes[termBytesPos++] == commonSuffixBytes[commonSuffixBytesPos++]) continue;
                        continue block0;
                    }
                    suffixBytesPos = this.currentFrame.startBytePos;
                } else {
                    suffixBytesPos = this.currentFrame.startBytePos + this.currentFrame.suffix - this.commonSuffix.length;
                }
                int commonSuffixBytesPosEnd = this.commonSuffix.length;
                while (commonSuffixBytesPos < commonSuffixBytesPosEnd) {
                    if (suffixBytes[suffixBytesPos++] == commonSuffixBytes[commonSuffixBytesPos++]) continue;
                    continue block0;
                }
            }
            int state = this.currentFrame.state;
            int lastState = this.currentFrame.lastState;
            for (int idx = 0; idx < this.currentFrame.suffix; ++idx) {
                lastState = state;
                if ((state = this.runAutomaton.step(state, this.currentFrame.suffixBytes[this.currentFrame.startBytePos + idx] & 0xFF)) == -1) continue block0;
            }
            if (isSubBlock) {
                this.copyTerm();
                this.currentFrame = this.pushFrame(state);
                this.currentFrame.lastState = lastState;
                continue;
            }
            if (this.currentFrame.isAutoPrefixTerm) {
                if (!this.allowAutoPrefixTerms) continue;
                if (this.currentFrame.floorSuffixLeadEnd == -1) {
                    this.useAutoPrefixTerm = state == this.sinkState;
                } else if (this.currentFrame.floorSuffixLeadStart == -1) {
                    if (this.automaton.isAccept(state)) {
                        this.useAutoPrefixTerm = this.acceptsSuffixRange(state, 0, this.currentFrame.floorSuffixLeadEnd);
                    }
                } else {
                    this.useAutoPrefixTerm = this.acceptsSuffixRange(lastState, this.currentFrame.floorSuffixLeadStart, this.currentFrame.floorSuffixLeadEnd);
                }
                if (!this.useAutoPrefixTerm) continue;
                this.copyTerm();
                this.currentFrame.termState.isRealTerm = false;
                return this.term;
            }
            if (this.runAutomaton.isAccept(state)) break;
        }
        this.copyTerm();
        assert (this.savedStartTerm == null || this.term.compareTo(this.savedStartTerm) > 0) : "saveStartTerm=" + this.savedStartTerm.utf8ToString() + " term=" + this.term.utf8ToString();
        return this.term;
    }

    private boolean acceptsSuffixRange(int state, int start, int end) {
        int count = this.automaton.initTransition(state, this.transition);
        for (int i = 0; i < count; ++i) {
            this.automaton.getNextTransition(this.transition);
            if (start < this.transition.min || end > this.transition.max || this.transition.dest != this.sinkState) continue;
            return true;
        }
        return false;
    }

    static String brToString(BytesRef b) {
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    private void copyTerm() {
        int len = this.currentFrame.prefix + this.currentFrame.suffix;
        if (this.term.bytes.length < len) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, len);
        }
        System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
        this.term.length = len;
    }

    @Override
    public boolean seekExact(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) {
        throw new UnsupportedOperationException();
    }
}

