/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.values;

import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.collections.LongToIntHashMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.Logger;
import edu.berkeley.nlp.lm.values.ProbBackoffPair;
import edu.berkeley.nlp.lm.values.ProbBackoffValueContainer;
import edu.berkeley.nlp.lm.values.RankedValueContainer;
import edu.berkeley.nlp.lm.values.ValueContainer;

public final class UncompressedProbBackoffValueContainer
extends RankedValueContainer<ProbBackoffPair>
implements ProbBackoffValueContainer {
    private static final long serialVersionUID = 964277160049236607L;
    @Annotations.PrintMemoryCount
    final long[] probsAndBackoffsForRank;
    transient LongToIntHashMap countIndexer;

    public UncompressedProbBackoffValueContainer(LongToIntHashMap countCounter, int valueRadix, boolean storePrefixes, long[] numNgramsForEachOrder) {
        super(valueRadix, storePrefixes, numNgramsForEachOrder);
        Logger.startTrack("Storing values", new Object[0]);
        long defaultVal = this.getDefaultVal().asLong();
        boolean hasDefaultVal = countCounter.get(defaultVal, -1) >= 0;
        this.probsAndBackoffsForRank = new long[countCounter.size() + (hasDefaultVal ? 0 : 1)];
        this.countIndexer = new LongToIntHashMap();
        int k = 0;
        for (LongToIntHashMap.Entry pair : countCounter.getObjectsSortedByValue(true)) {
            this.countIndexer.put(pair.key, this.countIndexer.size());
            this.probsAndBackoffsForRank[k++] = pair.key;
            if (this.countIndexer.size() != 10 || hasDefaultVal) continue;
            this.countIndexer.put(defaultVal, this.countIndexer.size());
            this.probsAndBackoffsForRank[k++] = defaultVal;
        }
        if (this.countIndexer.size() < 10 && !hasDefaultVal) {
            this.countIndexer.put(defaultVal, this.countIndexer.size());
            this.probsAndBackoffsForRank[k++] = defaultVal;
        }
        this.valueWidth = CustomWidthArray.numBitsNeeded(this.countIndexer.size());
        Logger.logss("Storing count indices using " + this.valueWidth + " bits.");
        Logger.endTrack();
    }

    public UncompressedProbBackoffValueContainer(int valueRadix, boolean storePrefixIndexes, long[] numNgramsForEachOrder, long[] probsAndBackoffsForRank, LongToIntHashMap countIndexer, int wordWidth) {
        super(valueRadix, storePrefixIndexes, numNgramsForEachOrder);
        this.countIndexer = countIndexer;
        this.probsAndBackoffsForRank = probsAndBackoffsForRank;
        this.valueWidth = wordWidth;
    }

    public UncompressedProbBackoffValueContainer createFreshValues(long[] numNgramsForEachOrder_) {
        return new UncompressedProbBackoffValueContainer(this.valueRadix, this.storeSuffixIndexes, numNgramsForEachOrder_, this.probsAndBackoffsForRank, this.countIndexer, this.valueWidth);
    }

    @Override
    public final float getProb(int ngramOrder, long index) {
        return this.getCount(ngramOrder, index, false);
    }

    public final long getInternalVal(int ngramOrder, long index) {
        return this.valueRanks[ngramOrder].get(index);
    }

    public final float getProb(CustomWidthArray valueRanksForOrder, long index) {
        return this.getCount(valueRanksForOrder, index, false);
    }

    @Override
    public void getFromOffset(long index, int ngramOrder, @Annotations.OutputParameter ProbBackoffPair outputVal) {
        long rank = this.getRank(ngramOrder, index);
        this.getFromRank(rank, outputVal);
    }

    private float getCount(int ngramOrder, long index, boolean backoff) {
        long rank = this.getRank(ngramOrder, index);
        return this.getFromRank(rank, backoff);
    }

    private float getCount(CustomWidthArray valueRanksForOrder, long index, boolean backoff) {
        long rank = valueRanksForOrder.get(index);
        return this.getFromRank(rank, backoff);
    }

    private float getFromRank(long rank, boolean backoff) {
        return backoff ? ProbBackoffPair.backoffOf(this.probsAndBackoffsForRank[(int)rank]) : ProbBackoffPair.probOf(this.probsAndBackoffsForRank[(int)rank]);
    }

    @Override
    public final float getBackoff(int ngramOrder, long index) {
        return this.getCount(ngramOrder, index, true);
    }

    public final float getBackoff(CustomWidthArray valueRanksForNgramOrder, long index) {
        return this.getCount(valueRanksForNgramOrder, index, true);
    }

    @Override
    protected ProbBackoffPair getDefaultVal() {
        return new ProbBackoffPair(Float.NaN, Float.NaN);
    }

    @Override
    protected void getFromRank(long rank, @Annotations.OutputParameter ProbBackoffPair outputVal) {
        outputVal.prob = this.getFromRank(rank, false);
        outputVal.backoff = this.getFromRank(rank, true);
    }

    @Override
    public ProbBackoffPair getScratchValue() {
        return new ProbBackoffPair(Float.NaN, Float.NaN);
    }

    @Override
    public void setFromOtherValues(ValueContainer<ProbBackoffPair> o) {
        super.setFromOtherValues(o);
        this.countIndexer = ((UncompressedProbBackoffValueContainer)o).countIndexer;
    }

    @Override
    public void trim() {
        super.trim();
        this.countIndexer = null;
    }

    @Override
    protected long getCountRank(long val) {
        return this.countIndexer.get(val, -1);
    }

    @Override
    protected boolean useValueStoringArray() {
        return true;
    }
}

