/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static <T> Comparator<T> localeComparator(Function<? super T, ? extends String> keyExtractor) {
        Collator localeCollator = Collator.getInstance();
        localeCollator.setStrength(0);
        return Comparator.comparing(keyExtractor, localeCollator::compare);
    }

    public static Comparator<String> comparatorByList(List<String> order) {
        return (o1, o2) -> {
            int pos2;
            int pos1;
            if (order != null) {
                pos1 = order.indexOf(o1);
                pos2 = order.indexOf(o2);
            } else {
                pos1 = 0;
                pos2 = 0;
            }
            if (pos1 < 0) {
                pos1 = Integer.MAX_VALUE;
            }
            if (pos2 < 0) {
                pos2 = Integer.MAX_VALUE;
            }
            if (pos1 < pos2) {
                return -1;
            }
            if (pos1 > pos2) {
                return 1;
            }
            return o1.compareToIgnoreCase((String)o2);
        };
    }

    public static <T> Predicate<T> patternFilter(String regex, Function<T, String> stringExtractor) {
        Predicate<String> p = Pattern.compile(regex).asPredicate();
        return o -> p.test((String)stringExtractor.apply(o));
    }
}

