/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.item;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderValidationException;
import org.omegat.util.OStrings;

public class ExternalFinderItemCommand {
    private final String command;
    private final ExternalFinderItem.TARGET target;
    private final ExternalFinderItem.ENCODING encoding;
    private final String delimiter;

    public ExternalFinderItemCommand(String command, ExternalFinderItem.TARGET target, ExternalFinderItem.ENCODING encoding, String delimiter) {
        this.command = command;
        this.target = target;
        this.encoding = encoding;
        this.delimiter = delimiter;
    }

    public String getCommand() {
        return this.command;
    }

    public ExternalFinderItem.TARGET getTarget() {
        return this.target;
    }

    public ExternalFinderItem.ENCODING getEncoding() {
        return this.encoding;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalFinderItemCommand other = (ExternalFinderItemCommand)obj;
        if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
            return false;
        }
        if (this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter)) {
            return false;
        }
        if (this.encoding != other.encoding) {
            return false;
        }
        return this.target == other.target;
    }

    public final String[] generateCommand(String findingWords) throws UnsupportedEncodingException {
        return ExternalFinderItemCommand.generateCommand(this.command, this.delimiter, this.encoding, findingWords);
    }

    private static String[] generateCommand(String command, String delimiter, ExternalFinderItem.ENCODING encoding, String findingWords) throws UnsupportedEncodingException {
        String encodedWords;
        if (encoding == ExternalFinderItem.ENCODING.NONE) {
            encodedWords = findingWords;
        } else {
            encodedWords = URLEncoder.encode(findingWords, StandardCharsets.UTF_8.name());
            if (encoding == ExternalFinderItem.ENCODING.ESCAPE) {
                encodedWords = encodedWords.replace("+", "%20");
            }
        }
        String[] ret = command.split(Pattern.quote(delimiter));
        for (int i = 0; i < ret.length; ++i) {
            String s = ret[i];
            ret[i] = s.replace("{target}", encodedWords);
        }
        return ret;
    }

    public static final class Builder {
        private String command;
        private ExternalFinderItem.TARGET target = ExternalFinderItem.TARGET.BOTH;
        private ExternalFinderItem.ENCODING encoding = ExternalFinderItem.ENCODING.NONE;
        private String delimiter = "|";

        public static Builder from(ExternalFinderItemCommand item) {
            return new Builder().setCommand(item.getCommand()).setTarget(item.getTarget()).setEncoding(item.getEncoding()).setDelimiter(item.getDelimiter());
        }

        public Builder setCommand(String command) {
            this.command = command;
            return this;
        }

        public String getCommand() {
            return this.command;
        }

        public Builder setTarget(ExternalFinderItem.TARGET target) {
            this.target = target;
            return this;
        }

        public ExternalFinderItem.TARGET getTarget() {
            return this.target;
        }

        public Builder setEncoding(ExternalFinderItem.ENCODING encoding) {
            this.encoding = encoding;
            return this;
        }

        public ExternalFinderItem.ENCODING getEncoding() {
            return this.encoding;
        }

        public Builder setDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public ExternalFinderItemCommand build() throws ExternalFinderValidationException {
            this.validate();
            return new ExternalFinderItemCommand(this.command, this.target, this.encoding, this.delimiter);
        }

        public String[] validate() throws ExternalFinderValidationException {
            if (this.command == null) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_COMMAND_ERROR_NOCOMMAND"));
            }
            if (!this.command.contains("{target}")) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_COMMAND_ERROR_NOTOKEN", "{target}"));
            }
            if (this.target == null) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_COMMAND_ERROR_NOTARGET"));
            }
            if (this.encoding == null) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_COMMAND_ERROR_NOENCODING"));
            }
            if (this.delimiter == null) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_COMMAND_ERROR_NODELIMITER"));
            }
            if (this.delimiter.isEmpty()) {
                throw new ExternalFinderValidationException(OStrings.getString("EXTERNALFINDER_COMMAND_ERROR_DELIMITEREMPTY"));
            }
            try {
                return this.generateSampleCommand();
            }
            catch (Throwable e) {
                throw new ExternalFinderValidationException(e);
            }
        }

        public String[] generateSampleCommand() throws UnsupportedEncodingException {
            String findingWords = this.target == ExternalFinderItem.TARGET.NON_ASCII_ONLY ? "f\u00f8\u00f8 b\u00e5r" : "foo bar";
            return ExternalFinderItemCommand.generateCommand(this.command, this.delimiter, this.encoding, findingWords);
        }
    }
}

