/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.Token;

public class GlossarySearcher {
    private final ITokenizer tok;
    private final Language lang;

    public GlossarySearcher(ITokenizer tok, Language lang) {
        this.tok = tok;
        this.lang = lang;
    }

    public List<GlossaryEntry> searchSourceMatches(SourceTextEntry ste, List<GlossaryEntry> entries) {
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        Token[] strTokens = this.tokenize(ste.getSrcText(), TagUtil.buildTagList(ste.getSrcText(), ste.getProtectedParts()));
        for (GlossaryEntry glosEntry : entries) {
            this.checkCancelled();
            if (!this.isTokenMatch(strTokens, ste.getSrcText(), glosEntry.getSrcText()) && !GlossarySearcher.isCjkMatch(ste.getSrcText(), glosEntry.getSrcText())) continue;
            result.add(glosEntry);
        }
        GlossarySearcher.sortGlossaryEntries(result);
        return GlossarySearcher.filterGlossary(result);
    }

    public List<Token[]> searchSourceMatchTokens(SourceTextEntry ste, GlossaryEntry entry) {
        Token[] strTokens = this.tokenize(ste.getSrcText(), TagUtil.buildTagList(ste.getSrcText(), ste.getProtectedParts()));
        List<Token[]> toks = this.getMatchingTokens(strTokens, ste.getSrcText(), entry.getSrcText());
        if (toks.isEmpty()) {
            toks = GlossarySearcher.getCjkMatchingTokens(ste.getSrcText(), entry.getSrcText());
        }
        return toks;
    }

    public List<String> searchTargetMatches(String trg, ProtectedPart[] protectedParts, GlossaryEntry entry) {
        ArrayList<String> result = new ArrayList<String>();
        Token[] strTokens = this.tokenize(trg, TagUtil.buildTagList(trg, protectedParts));
        for (String term : entry.getLocTerms(true)) {
            this.checkCancelled();
            if (!this.isTokenMatch(strTokens, trg, term) && !GlossarySearcher.isCjkMatch(trg, term)) continue;
            result.add(term);
        }
        return result;
    }

    protected void checkCancelled() {
    }

    private boolean isTokenMatch(Token[] fullTextTokens, String fullText, String term) {
        return !this.getMatchingTokens(fullTextTokens, fullText, term).isEmpty();
    }

    private List<Token[]> getMatchingTokens(Token[] fullTextTokens, String fullText, String term) {
        Token[] glosTokens = this.tokenize(term);
        if (glosTokens.length == 0) {
            return Collections.emptyList();
        }
        boolean notExact = Preferences.isPreferenceDefault("glossary_not_exact_match", true);
        List<Token[]> foundTokens = DefaultTokenizer.searchAll(fullTextTokens, glosTokens, notExact);
        foundTokens.removeIf(toks -> !GlossarySearcher.keepMatch(toks, fullText, term));
        return foundTokens;
    }

    private static boolean keepMatch(Token[] tokens, String srcTxt, String locTxt) {
        if (Preferences.isPreferenceDefault("glossary_require_similar_case", true) && StringUtil.isUpperCase(locTxt)) {
            for (Token tok : tokens) {
                String matched = tok.getTextFromString(srcTxt);
                if (StringUtil.isUpperCase(matched)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isCjkMatch(String fullText, String term) {
        IProject project = Core.getProject();
        return project.isProjectLoaded() && !project.getProjectProperties().getSourceLanguage().isSpaceDelimited() && StringUtil.isCJK(term) && fullText.contains(term);
    }

    private static List<Token[]> getCjkMatchingTokens(String fullText, String term) {
        IProject project = Core.getProject();
        if (!project.isProjectLoaded() || project.getProjectProperties().getSourceLanguage().isSpaceDelimited()) {
            return Collections.emptyList();
        }
        if (!StringUtil.isCJK(term)) {
            return Collections.emptyList();
        }
        int i = fullText.indexOf(term);
        if (i == -1) {
            return Collections.emptyList();
        }
        ArrayList<Token[]> result = new ArrayList<Token[]>();
        result.add(new Token[]{new Token(term, i)});
        while ((i = fullText.indexOf(term, i + 1)) != -1) {
            result.add(new Token[]{new Token(term, i)});
        }
        return result;
    }

    private Token[] tokenize(String str) {
        String strLower = str.toLowerCase(this.lang.getLocale());
        if (Preferences.isPreferenceDefault("glossary_stemming", true)) {
            return this.tok.tokenizeWords(strLower, ITokenizer.StemmingMode.GLOSSARY);
        }
        return this.tok.tokenizeVerbatim(strLower);
    }

    private Token[] tokenize(String str, List<TagUtil.Tag> tags) {
        Token[] tokens = this.tokenize(str);
        if (tags.isEmpty()) {
            return tokens;
        }
        ArrayList<Token> result = new ArrayList<Token>(tokens.length);
        for (Token tok : tokens) {
            if (GlossarySearcher.tokenInTag(tok, tags)) continue;
            result.add(tok);
        }
        return result.toArray(new Token[result.size()]);
    }

    private static boolean tokenInTag(Token tok, List<TagUtil.Tag> tags) {
        for (TagUtil.Tag tag : tags) {
            if (tok.getOffset() < tag.pos || tok.getOffset() + tok.getLength() > tag.pos + tag.tag.length()) continue;
            return true;
        }
        return false;
    }

    static void sortGlossaryEntries(List<GlossaryEntry> entries) {
        Collections.sort(entries, (o1, o2) -> {
            int p2;
            int p1 = o1.getPriority() ? 1 : 2;
            int c = p1 - (p2 = o2.getPriority() ? 1 : 2);
            if (c == 0) {
                c = o2.getSrcText().length() - o1.getSrcText().length();
            }
            if (c == 0) {
                c = o1.getSrcText().compareToIgnoreCase(o2.getSrcText());
            }
            if (c == 0) {
                c = o1.getSrcText().compareTo(o2.getSrcText());
            }
            if (c == 0) {
                c = o1.getLocText().compareToIgnoreCase(o2.getLocText());
            }
            return c;
        });
    }

    private static List<GlossaryEntry> filterGlossary(List<GlossaryEntry> result) {
        int i;
        if (result.isEmpty()) {
            return result;
        }
        LinkedList<GlossaryEntry> returnList = new LinkedList<GlossaryEntry>();
        GlossaryEntry replaceEntry = new GlossaryEntry("", "", "", false, null);
        boolean removedDuplicate = false;
        for (i = 0; i < result.size(); ++i) {
            GlossaryEntry nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            for (int j = i + 1; j < result.size(); ++j) {
                GlossaryEntry thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("") || !nowEntry.getSrcText().equals(thenEntry.getSrcText()) || !nowEntry.getLocText().equals(thenEntry.getLocText()) || !nowEntry.getCommentText().equals(thenEntry.getCommentText())) continue;
                result.set(j, replaceEntry);
                removedDuplicate = true;
            }
        }
        if (removedDuplicate) {
            Iterator<GlossaryEntry> myIter = result.iterator();
            LinkedList<GlossaryEntry> newList = new LinkedList<GlossaryEntry>();
            while (myIter.hasNext()) {
                GlossaryEntry checkEntry = myIter.next();
                if (checkEntry.getSrcText().equals("") || checkEntry.getLocText().equals("")) {
                    myIter.remove();
                    continue;
                }
                newList.add(checkEntry);
            }
            result = newList;
        }
        for (i = 0; i < result.size(); ++i) {
            LinkedList<GlossaryEntry> srcList = new LinkedList<GlossaryEntry>();
            GlossaryEntry nowEntry = result.get(i);
            if (nowEntry.getSrcText().equals("")) continue;
            srcList.add(nowEntry);
            for (int j = i + 1; j < result.size(); ++j) {
                GlossaryEntry thenEntry = result.get(j);
                if (thenEntry.getSrcText().equals("") || !nowEntry.getSrcText().equals(thenEntry.getSrcText())) continue;
                srcList.add(thenEntry);
                result.set(j, replaceEntry);
            }
            LinkedList<GlossaryEntry> sortList = new LinkedList<GlossaryEntry>();
            if (srcList.size() > 1) {
                for (int k = 0; k < srcList.size(); ++k) {
                    GlossaryEntry srcNow = (GlossaryEntry)srcList.get(k);
                    if (srcNow.getSrcText().equals("")) continue;
                    sortList.add(srcNow);
                    for (int l = k + 1; l < srcList.size(); ++l) {
                        GlossaryEntry srcThen = (GlossaryEntry)srcList.get(l);
                        if (srcThen.getSrcText().equals("") || !srcNow.getLocText().equals(srcThen.getLocText())) continue;
                        sortList.add(srcThen);
                        srcList.set(l, replaceEntry);
                    }
                }
            } else {
                sortList = srcList;
            }
            String srcTxt = ((GlossaryEntry)sortList.get(0)).getSrcText();
            ArrayList<String> locTxts = new ArrayList<String>();
            ArrayList<String> comTxts = new ArrayList<String>();
            ArrayList<Boolean> prios = new ArrayList<Boolean>();
            ArrayList<String> origins = new ArrayList<String>();
            for (GlossaryEntry e : sortList) {
                for (String s : e.getLocTerms(false)) {
                    locTxts.add(s);
                }
                for (String s : e.getComments()) {
                    comTxts.add(s);
                }
                for (boolean s : e.getPriorities()) {
                    prios.add(s);
                }
                for (String o : e.getOrigins(false)) {
                    origins.add(o);
                }
            }
            boolean[] priorities = new boolean[prios.size()];
            for (int j = 0; j < prios.size(); ++j) {
                priorities[j] = (Boolean)prios.get(j);
            }
            GlossaryEntry combineEntry = new GlossaryEntry(srcTxt, locTxts.toArray(new String[locTxts.size()]), comTxts.toArray(new String[comTxts.size()]), priorities, origins.toArray(new String[origins.size()]));
            returnList.add(combineEntry);
        }
        return returnList;
    }
}

