/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3;

import org.omegat.filters3.Attribute;
import org.omegat.filters3.Attributes;
import org.omegat.filters3.Element;

public abstract class Tag
implements Element {
    private String tag;
    private String shortcut;
    private Type type;
    private Attributes attributes;
    private Attributes startAttributes;
    private int index;

    public String getTag() {
        return this.tag;
    }

    public String getShortcut() {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        return String.valueOf(Character.toChars(this.getTag().codePointAt(0)));
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        for (Attribute a : this.attributes.list) {
            if (!name.equals(a.getName())) continue;
            return a.getValue();
        }
        return null;
    }

    public Attributes getStartAttributes() {
        return this.startAttributes;
    }

    public void setStartAttributes(Attributes startAttributes) {
        this.startAttributes = startAttributes;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int shortcut) {
        this.index = shortcut;
    }

    public Tag(String tag, String shortcut, Type type, Attributes attributes) {
        this.tag = tag;
        this.shortcut = shortcut;
        this.type = type;
        this.attributes = attributes;
    }

    @Override
    public String toTMX() {
        String tmxtag;
        switch (this.getType()) {
            case BEGIN: {
                tmxtag = "bpt";
                break;
            }
            case END: {
                tmxtag = "ept";
                break;
            }
            case ALONE: {
                tmxtag = "ph";
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't hapen!");
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        buf.append(tmxtag);
        buf.append(" i=\"");
        buf.append(this.getIndex());
        buf.append("\">");
        buf.append(this.toPartialTMX());
        buf.append("</");
        buf.append(tmxtag);
        buf.append(">");
        return buf.toString();
    }

    protected String toPartialTMX() {
        StringBuilder buf = new StringBuilder();
        buf.append("&amp;lt;");
        if (Type.END == this.getType()) {
            buf.append("/");
        }
        buf.append(this.getTag());
        buf.append(this.getAttributes().toString());
        if (Type.ALONE == this.getType()) {
            buf.append("/");
        }
        buf.append("&amp;gt;");
        return buf.toString();
    }

    @Override
    public String toShortcut() {
        StringBuilder buf = new StringBuilder();
        buf.append('<');
        if (Type.END == this.getType()) {
            buf.append('/');
        }
        buf.append(this.getShortcut());
        buf.append(this.getIndex());
        if (Type.ALONE == this.getType()) {
            buf.append('/');
        }
        buf.append('>');
        return buf.toString();
    }

    @Override
    public String toSafeCalcShortcut() {
        return '\b' + this.getShortcut().replace('<', '_').replace('>', '_') + '\b';
    }

    @Override
    public abstract String toOriginal();

    public static enum Type {
        BEGIN,
        END,
        ALONE;

    }
}

