/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderSequenceValidator;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleSequenceStream;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AdditionalContextFeatureGenerator;
import opennlp.tools.util.featuregen.BigramNameFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.featuregen.GeneratorFactory;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.PreviousMapFeatureGenerator;
import opennlp.tools.util.featuregen.SentenceFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;
import opennlp.tools.util.model.ModelUtil;

public class NameFinderME
implements TokenNameFinder {
    private static String[][] EMPTY = new String[0][0];
    public static final int DEFAULT_BEAM_SIZE = 3;
    private static final Pattern typedOutcomePattern = Pattern.compile("(.+)-\\w+");
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String OTHER = "other";
    private SequenceCodec<String> seqCodec = new BioCodec();
    protected SequenceClassificationModel<String> model;
    protected NameContextGenerator contextGenerator;
    private Sequence bestSequence;
    private AdditionalContextFeatureGenerator additionalContextFeatureGenerator = new AdditionalContextFeatureGenerator();
    private SequenceValidator<String> sequenceValidator;

    public NameFinderME(TokenNameFinderModel model) {
        TokenNameFinderFactory factory = model.getFactory();
        this.seqCodec = factory.createSequenceCodec();
        this.sequenceValidator = this.seqCodec.createSequenceValidator();
        this.model = model.getNameFinderSequenceModel();
        this.contextGenerator = factory.createContextGenerator();
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
    }

    @Deprecated
    public NameFinderME(TokenNameFinderModel model, AdaptiveFeatureGenerator generator, int beamSize, SequenceValidator<String> sequenceValidator) {
        this.seqCodec = model.getFactory().createSequenceCodec();
        this.sequenceValidator = sequenceValidator;
        this.model = model.getNameFinderSequenceModel() != null ? model.getNameFinderSequenceModel() : new BeamSearch<String>(beamSize, model.getNameFinderModel());
        if (generator != null) {
            this.contextGenerator = new DefaultNameContextGenerator(generator);
        } else {
            AdaptiveFeatureGenerator featureGenerator = model.createFeatureGenerators();
            if (featureGenerator == null) {
                featureGenerator = NameFinderME.createFeatureGenerator();
            }
            this.contextGenerator = new DefaultNameContextGenerator(featureGenerator);
        }
        this.contextGenerator.addFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)this.additionalContextFeatureGenerator, 8, 8));
        if (this.sequenceValidator == null) {
            this.sequenceValidator = new NameFinderSequenceValidator();
        }
    }

    @Deprecated
    public NameFinderME(TokenNameFinderModel model, AdaptiveFeatureGenerator generator, int beamSize) {
        this(model, generator, beamSize, null);
    }

    @Deprecated
    public NameFinderME(TokenNameFinderModel model, int beamSize) {
        this(model, null, beamSize);
    }

    static AdaptiveFeatureGenerator createFeatureGenerator() {
        return new CachedFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenFeatureGenerator(), 2, 2), new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenClassFeatureGenerator(true), 2, 2), new OutcomePriorFeatureGenerator(), new PreviousMapFeatureGenerator(), new BigramNameFeatureGenerator(), new SentenceFeatureGenerator(true, false));
    }

    private static AdaptiveFeatureGenerator createFeatureGenerator(byte[] generatorDescriptor, final Map<String, Object> resources) throws IOException {
        AdaptiveFeatureGenerator featureGenerator = generatorDescriptor != null ? GeneratorFactory.create(new ByteArrayInputStream(generatorDescriptor), new FeatureGeneratorResourceProvider(){

            @Override
            public Object getResource(String key) {
                if (resources != null) {
                    return resources.get(key);
                }
                return null;
            }
        }) : null;
        return featureGenerator;
    }

    @Override
    public Span[] find(String[] tokens) {
        return this.find(tokens, EMPTY);
    }

    public Span[] find(String[] tokens, String[][] additionalContext) {
        this.additionalContextFeatureGenerator.setCurrentContext(additionalContext);
        this.bestSequence = this.model.bestSequence((String[])tokens, (Object[])additionalContext, this.contextGenerator, this.sequenceValidator);
        List<String> c = this.bestSequence.getOutcomes();
        this.contextGenerator.updateAdaptiveData(tokens, c.toArray(new String[c.size()]));
        Span[] spans = this.seqCodec.decode(c);
        spans = this.setProbs(spans);
        return spans;
    }

    @Override
    public void clearAdaptiveData() {
        this.contextGenerator.clearAdaptiveData();
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    private Span[] setProbs(Span[] spans) {
        double[] probs = this.probs(spans);
        if (probs != null) {
            for (int i = 0; i < probs.length; ++i) {
                double prob = probs[i];
                spans[i] = new Span(spans[i], prob);
            }
        }
        return spans;
    }

    public double[] probs(Span[] spans) {
        double[] sprobs = new double[spans.length];
        double[] probs = this.bestSequence.getProbs();
        for (int si = 0; si < spans.length; ++si) {
            double p = 0.0;
            for (int oi = spans[si].getStart(); oi < spans[si].getEnd(); ++oi) {
                p += probs[oi];
            }
            sprobs[si] = p /= (double)spans[si].length();
        }
        return sprobs;
    }

    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, TrainingParameters trainParams, TokenNameFinderFactory factory) throws IOException {
        String beamSizeString = trainParams.getSettings().get("BeamSize");
        int beamSize = 3;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        MaxentModel nameFinderModel = null;
        SequenceClassificationModel<String> seqModel = null;
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(trainParams.getSettings());
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            NameFinderEventStream eventStream = new NameFinderEventStream(samples, type, factory.createContextGenerator(), factory.createSequenceCodec());
            EventTrainer trainer = TrainerFactory.getEventTrainer(trainParams.getSettings(), manifestInfoEntries);
            nameFinderModel = trainer.train(eventStream);
        } else if (TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER.equals((Object)trainerType)) {
            NameSampleSequenceStream ss = new NameSampleSequenceStream(samples, factory.createContextGenerator());
            EventModelSequenceTrainer trainer = TrainerFactory.getEventModelSequenceTrainer(trainParams.getSettings(), manifestInfoEntries);
            nameFinderModel = trainer.train(ss);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(trainParams.getSettings(), manifestInfoEntries);
            NameSampleSequenceStream ss = new NameSampleSequenceStream(samples, factory.createContextGenerator(), false);
            seqModel = trainer.train(ss);
        } else {
            throw new IllegalStateException("Unexpected trainer type!");
        }
        if (seqModel != null) {
            return new TokenNameFinderModel(languageCode, seqModel, factory.getFeatureGenerator(), factory.getResources(), manifestInfoEntries, factory.getSequenceCodec(), factory);
        }
        return new TokenNameFinderModel(languageCode, nameFinderModel, beamSize, factory.getFeatureGenerator(), factory.getResources(), manifestInfoEntries, factory.getSequenceCodec(), factory);
    }

    @Deprecated
    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, TrainingParameters trainParams, AdaptiveFeatureGenerator generator, Map<String, Object> resources) throws IOException {
        if (languageCode == null) {
            throw new IllegalArgumentException("languageCode must not be null!");
        }
        String beamSizeString = trainParams.getSettings().get("BeamSize");
        int beamSize = 3;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        AdaptiveFeatureGenerator featureGenerator = generator != null ? generator : NameFinderME.createFeatureGenerator();
        MaxentModel nameFinderModel = null;
        SequenceClassificationModel<String> seqModel = null;
        TrainerFactory.TrainerType trainerType = TrainerFactory.getTrainerType(trainParams.getSettings());
        if (TrainerFactory.TrainerType.EVENT_MODEL_TRAINER.equals((Object)trainerType)) {
            NameFinderEventStream eventStream = new NameFinderEventStream(samples, type, new DefaultNameContextGenerator(featureGenerator), new BioCodec());
            EventTrainer trainer = TrainerFactory.getEventTrainer(trainParams.getSettings(), manifestInfoEntries);
            nameFinderModel = trainer.train(eventStream);
        } else if (TrainerFactory.TrainerType.EVENT_MODEL_SEQUENCE_TRAINER.equals((Object)trainerType)) {
            NameSampleSequenceStream ss = new NameSampleSequenceStream(samples, featureGenerator);
            EventModelSequenceTrainer trainer = TrainerFactory.getEventModelSequenceTrainer(trainParams.getSettings(), manifestInfoEntries);
            nameFinderModel = trainer.train(ss);
        } else if (TrainerFactory.TrainerType.SEQUENCE_TRAINER.equals((Object)trainerType)) {
            SequenceTrainer trainer = TrainerFactory.getSequenceModelTrainer(trainParams.getSettings(), manifestInfoEntries);
            NameSampleSequenceStream ss = new NameSampleSequenceStream(samples, featureGenerator, false);
            seqModel = trainer.train(ss);
        } else {
            throw new IllegalStateException("Unexpected trainer type!");
        }
        if (seqModel != null) {
            return new TokenNameFinderModel(languageCode, seqModel, null, resources, manifestInfoEntries, new BioCodec(), new TokenNameFinderFactory());
        }
        return new TokenNameFinderModel(languageCode, nameFinderModel, beamSize, null, resources, manifestInfoEntries, new BioCodec(), new TokenNameFinderFactory());
    }

    @Deprecated
    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, TrainingParameters trainParams, byte[] featureGeneratorBytes, Map<String, Object> resources) throws IOException {
        TokenNameFinderModel model = NameFinderME.train(languageCode, type, samples, trainParams, NameFinderME.createFeatureGenerator(featureGeneratorBytes, resources), resources);
        if (featureGeneratorBytes != null) {
            model = model.updateFeatureGenerator(featureGeneratorBytes);
        }
        return model;
    }

    @Deprecated
    public static TokenNameFinderModel train(String languageCode, String type, ObjectStream<NameSample> samples, Map<String, Object> resources) throws IOException {
        return NameFinderME.train(languageCode, type, samples, ModelUtil.createDefaultTrainingParameters(), (byte[])null, resources);
    }

    static final String extractNameType(String outcome) {
        Matcher matcher = typedOutcomePattern.matcher(outcome);
        if (matcher.matches()) {
            String nameType = matcher.group(1);
            return nameType;
        }
        return null;
    }

    public static Span[] dropOverlappingSpans(Span[] spans) {
        ArrayList sortedSpans = new ArrayList(spans.length);
        Collections.addAll(sortedSpans, spans);
        Collections.sort(sortedSpans);
        Iterator it = sortedSpans.iterator();
        Span lastSpan = null;
        while (it.hasNext()) {
            Span span = (Span)it.next();
            if (lastSpan != null && lastSpan.intersects(span)) {
                it.remove();
                span = lastSpan;
            }
            lastSpan = span;
        }
        return sortedSpans.toArray(new Span[sortedSpans.size()]);
    }
}

