/**
 * This interface represents a CSS view. The getComputedStyle method provides a read only access to the computed values of an element.The expectation is that an instance of the ViewCSS interface can be obtained by using binding-specific casting methods on an instance of the AbstractView interface.Since a computed style is related to an Element node, if this element is removed from the document, the associated CSSStyleDeclaration and CSSValue related to this declaration are no longer valid.
 */
var ViewCSS = {
}
/**
 * This method is used to get the computed style as it is defined in [ CSS2].
 * @syntax viewCSS.getComputedStyle(elt, pseudoElt)
 * @param {Element} elt The element whose style is to be computed. This parameter cannot be null.
 * @param {String} pseudoElt The pseudo-element or null if none.
 * @returns {CSSStyleDeclaration} The computed style. The CSSStyleDeclaration is read-only and contains only absolute values.
 */
ViewCSS.prototype.getComputedStyle = function(elt,  pseudoElt) {};

/**
 * Represents the ViewCSS prototype object.
 * @syntax ViewCSS.prototype
 * @static
 */
ViewCSS.prototype;

